/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Base64;

public class TypeTranslators {
    public static final TypeTranslator<String, String> STRING = new TypeTranslator<String, String>(){

        @Override
        public String from(String data) throws IOException {
            return data;
        }

        @Override
        public String to(String source) throws IOException {
            return source;
        }
    };
    public static final TypeTranslator<String, String> JSON_STRING = new TypeTranslator<String, String>(){

        @Override
        public String from(String data) throws IOException {
            return StringUtils.escapeJson((String)data);
        }

        @Override
        public String to(String source) throws IOException {
            return StringUtils.unescapeJson((String)source);
        }
    };
    public static final TypeTranslator<String, Integer> INTEGER = new TypeTranslator<String, Integer>(){

        @Override
        public String from(Integer data) throws IOException {
            return data.toString();
        }

        @Override
        public Integer to(String source) throws IOException {
            try {
                return Integer.parseInt(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };
    public static final TypeTranslator<String, Long> LONG = new TypeTranslator<String, Long>(){

        @Override
        public String from(Long data) throws IOException {
            return data.toString();
        }

        @Override
        public Long to(String source) throws IOException {
            try {
                return Long.parseLong(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };
    public static final TypeTranslator<String, Boolean> BOOLEAN = new TypeTranslator<String, Boolean>(){

        @Override
        public String from(Boolean data) throws IOException {
            return data.toString();
        }

        @Override
        public Boolean to(String source) throws IOException {
            return Boolean.valueOf(source);
        }
    };
    public static final TypeTranslator<String, Double> DOUBLE = new TypeTranslator<String, Double>(){

        @Override
        public String from(Double data) throws IOException {
            return data.toString();
        }

        @Override
        public Double to(String source) throws IOException {
            try {
                return Double.parseDouble(source);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    };
    public static final TypeTranslator<byte[], String> BYTEARRAY_TO_BASE64 = new TypeTranslator<byte[], String>(){

        @Override
        public byte[] from(String data) throws IOException {
            return Base64.getDecoder().decode(data);
        }

        @Override
        public String to(byte[] source) throws IOException {
            return Base64.getEncoder().encodeToString(source);
        }
    };
    public static final TypeTranslator<String, byte[]> BASE64_TO_BYTEARRAY = new TypeTranslator<String, byte[]>(){

        @Override
        public String from(byte[] data) throws IOException {
            return Base64.getEncoder().encodeToString(data);
        }

        @Override
        public byte[] to(String source) throws IOException {
            return Base64.getDecoder().decode(source);
        }
    };

    public static TypeTranslator<?, ?> createTypeTranslator(ClassLoader loader, String className) {
        TypeTranslator result = null;
        try {
            Class<?> translatorClass = loader.loadClass(className);
            result = (TypeTranslator)translatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(TypeTranslators.class).error("Cannot instantiate instance of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage());
        }
        return result;
    }

    public static Serializer<?> createSerializer(ClassLoader loader, String className) {
        return (Serializer)TypeTranslators.createTypeTranslator(loader, className);
    }
}

