/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public abstract class AbstractTestServer
implements Server {
    private static File configDir;

    public static final File setConfigDir(File directory) {
        configDir = directory;
        return directory;
    }

    public static File getConfigDir(String deflt) {
        return AbstractTestServer.getConfigDir(new File(deflt));
    }

    public static File getConfigDir(File deflt) {
        return null == configDir ? deflt : configDir;
    }

    public static void extractConfiguration(String location, String dfltConfigDir) throws IOException {
        AbstractTestServer.extractConfiguration(AbstractTestServer.class.getClassLoader(), location, dfltConfigDir);
    }

    public static void extractConfiguration(ClassLoader loader, String location, String dfltConfigDir) throws IOException {
        File cfgDir = AbstractTestServer.getConfigDir(dfltConfigDir);
        cfgDir.mkdirs();
        InputStream in = loader.getResourceAsStream(location);
        if (null == in) {
            throw new IOException("Location '" + location + "' cannot be found");
        }
        ZipUtils.extractZip((InputStream)in, (Path)cfgDir.toPath());
    }

    public static boolean runsFromJar() {
        String intlName = AbstractTestServer.class.getName().replace('.', '/');
        String classJar = AbstractTestServer.class.getResource("/" + intlName + ".class").toString();
        return classJar.startsWith("jar:");
    }

    public static int getInteger(String[] args, int dflt) {
        return AbstractTestServer.getInteger(args, 0, dflt);
    }

    public static int getInteger(String[] args, int argIndex, int dflt) {
        int result = dflt;
        if (args.length > 0 && argIndex < args.length) {
            try {
                result = Integer.parseInt(args[argIndex]);
            }
            catch (NumberFormatException e) {
                System.out.println("Cannot read port number from " + args[0] + ": " + e.getMessage());
            }
        } else {
            System.out.println("No args given to read the port number from (" + (argIndex + 1) + ". argument). Falling back to: " + dflt);
        }
        return result;
    }

    public static String getString(String[] args, int argIndex, String dflt) {
        String result = dflt;
        if (args.length > 0 && argIndex < args.length) {
            result = args[argIndex];
        }
        return result;
    }

    public static File applyBaseDir(String[] args, int argIndex, String suffix) {
        File f = null;
        String configDir = AbstractTestServer.getString(args, 1, "");
        if (configDir.length() > 0) {
            File tmp;
            f = new File(configDir);
            if (f.isDirectory() && suffix != null && (tmp = new File(configDir, suffix)).isDirectory()) {
                f = tmp;
            }
            if (f.isDirectory()) {
                AbstractTestServer.setConfigDir(f);
            }
        }
        return f;
    }
}

