/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.jsl.ExcludeFirst;
import de.iip_ecosphere.platform.transport.AppIntercom;
import de.iip_ecosphere.platform.transport.DefaultTransportFactoryDescriptor;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.connectors.impl.DirectMemoryTransferTransportConnector;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonToStringTranslator;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.ComponentType;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import de.iip_ecosphere.platform.transport.status.StatusMessageSerializer;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;
import test.de.iip_ecosphere.platform.transport.ProductProtobufSerializer;

@ExcludeFirst
public class DirectMemoryTransportConnectorTest {
    private static boolean factoryUseDmcAsTransport = false;
    private static final DirectMemoryTransferTransportConnector MY_DM_CONNECTOR = new DirectMemoryTransferTransportConnector();
    private static final TransportConnector MY_FAKE_CONNECTOR = new FakeConnector();

    @Test
    public void testMemoryConnector() throws IOException {
        Assert.assertTrue((TransportFactory.createConnector() == MY_DM_CONNECTOR ? 1 : 0) != 0);
        Assert.assertTrue((TransportFactory.createDirectMemoryConnector() == MY_FAKE_CONNECTOR ? 1 : 0) != 0);
        Assert.assertTrue((TransportFactory.createIpcConnector() == MY_FAKE_CONNECTOR ? 1 : 0) != 0);
        Assert.assertEquals((Object)"IIP-Ecosphere direct memory transfer", (Object)TransportFactory.getConnectorName());
        Assert.assertNull((Object)MY_FAKE_CONNECTOR.enabledEncryption());
        Assert.assertNull((Object)MY_FAKE_CONNECTOR.supportedEncryption());
        ServerAddress addr = new ServerAddress(Schema.IGNORE, "", 0);
        AbstractTransportConnectorTest.doTest(addr, ProductJsonSerializer.class);
        MY_DM_CONNECTOR.clear();
        AbstractTransportConnectorTest.doTest(addr, ProductProtobufSerializer.class);
    }

    @Test
    public void testStatusMessage() throws IOException {
        final AtomicReference received = new AtomicReference();
        TransportConnector conn = TransportFactory.createDirectMemoryConnector();
        ReceptionCallback<StatusMessage> callback = new ReceptionCallback<StatusMessage>(){

            public void received(StatusMessage data) {
                received.set(data);
            }

            public Class<StatusMessage> getType() {
                return StatusMessage.class;
            }
        };
        conn.setReceptionCallback("ComponentStatus", (ReceptionCallback)callback);
        StatusMessage msg = new StatusMessage((ComponentType)ComponentTypes.CONTAINER, (ActionType)ActionTypes.ADDED, "AAA", "BBB", new String[]{"CCC"});
        msg.send(conn);
        StatusMessage rcv = (StatusMessage)received.get();
        Assert.assertNotNull((Object)rcv);
        Assert.assertEquals((Object)msg.getComponentType(), (Object)rcv.getComponentType());
        Assert.assertEquals((Object)msg.getAction(), (Object)rcv.getAction());
        Assert.assertEquals((Object)msg.getId(), (Object)rcv.getId());
        Assert.assertEquals((Object)msg.getDeviceId(), (Object)rcv.getDeviceId());
        Assert.assertArrayEquals((Object[])msg.getAliasIds(), (Object[])rcv.getAliasIds());
        TypeTranslator tt = StatusMessageSerializer.createTypeTranslator();
        tt.from((Object)((String)tt.to((Object)msg)));
        msg.withResult((Object)-1);
        tt.from((Object)((String)tt.to((Object)msg)));
    }

    @Test
    public void testGenericJsonTypeTranslator() {
        GenericJsonToStringTranslator tt = new GenericJsonToStringTranslator(Object.class);
        Assert.assertNotNull((Object)tt.getMapper());
    }

    @Test
    public void testResourceStatusMessage() {
        StatusMessage msg = new StatusMessage((ActionType)ActionTypes.REMOVED, "AAA", new String[]{"BBB", "CCC"});
        Assert.assertEquals((Object)msg.getComponentType(), (Object)ComponentTypes.DEVICE);
        Assert.assertEquals((Object)msg.getAction(), (Object)ActionTypes.REMOVED);
        Assert.assertEquals((Object)msg.getId(), (Object)"AAA");
        Assert.assertEquals((Object)msg.getDeviceId(), (Object)"");
        Assert.assertArrayEquals((Object[])msg.getAliasIds(), (Object[])new String[]{"BBB", "CCC"});
    }

    @Test
    public void testTransport() throws IOException {
        factoryUseDmcAsTransport = true;
        Transport.setTransportSetup(() -> null);
        final AtomicInteger statusReceivedCount = new AtomicInteger();
        final AtomicInteger traceReceivedCount = new AtomicInteger();
        MY_DM_CONNECTOR.setReceptionCallback("ComponentStatus", (ReceptionCallback)new ReceptionCallback<StatusMessage>(){

            public void received(StatusMessage data) {
                statusReceivedCount.getAndIncrement();
            }

            public Class<StatusMessage> getType() {
                return StatusMessage.class;
            }
        });
        MY_DM_CONNECTOR.setReceptionCallback("Trace", (ReceptionCallback)new ReceptionCallback<TraceRecord>(){

            public void received(TraceRecord data) {
                traceReceivedCount.getAndIncrement();
            }

            public Class<TraceRecord> getType() {
                return TraceRecord.class;
            }
        });
        Transport.setTransportSetup(() -> new TransportSetup());
        Transport.sendResourceStatus((ActionType)ActionTypes.ADDED, (String[])new String[0]);
        Transport.sendContainerStatus((ActionType)ActionTypes.CHANGED, (String)"Container-1", (String[])new String[0]);
        Transport.sendServiceStatus((ActionType)ActionTypes.REMOVED, (String)"Service-1", (String[])new String[0]);
        Transport.sendServiceArtifactStatus((ActionType)ActionTypes.REMOVED, (String)"ServiceArtifact-1", (String[])new String[0]);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("src", "act", null));
        try {
            HashSet data = new HashSet();
            AppIntercom intercom = new AppIntercom(d -> data.add(d), String.class);
            intercom.start();
            intercom.asyncSend((Object)"async");
            intercom.syncSend((Object)"sync");
            intercom.stop();
            TimeUtils.sleep((int)1000);
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exception thrown: " + String.valueOf(e)));
        }
        Transport.releaseConnector();
        Transport.sendResourceStatus((ActionType)ActionTypes.ADDED, (String[])new String[0]);
        factoryUseDmcAsTransport = false;
        Assert.assertEquals((long)4L, (long)statusReceivedCount.get());
        Assert.assertEquals((long)1L, (long)traceReceivedCount.get());
    }

    private static class FakeConnector
    implements TransportConnector {
        private Map<String, ReceptionCallback<?>> callbacks = new HashMap();

        private FakeConnector() {
        }

        public void syncSend(String stream, Object data) throws IOException {
            this.serializeDeserializeNotify(stream, data);
        }

        public void asyncSend(String stream, Object data) throws IOException {
            this.serializeDeserializeNotify(stream, data);
        }

        private <T> void serializeDeserializeNotify(String stream, T data) throws IOException {
            Class<?> cls = data.getClass();
            Serializer serializer = SerializerRegistry.getSerializer(cls);
            if (null != serializer) {
                byte[] tmp = (byte[])serializer.to(data);
                ReceptionCallback<?> callback = this.callbacks.get(stream);
                if (null != callback) {
                    Serializer deserializer = SerializerRegistry.getSerializer((Class)callback.getType());
                    if (null != deserializer) {
                        callback.received(deserializer.from((Object)tmp));
                    } else {
                        System.out.println("No deserializer found for " + callback.getType().getName());
                    }
                } else {
                    System.out.println("No callback found for " + stream);
                }
            } else {
                System.out.println("No serializer found for " + cls.getName());
            }
        }

        public void setReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
            this.callbacks.put(stream, callback);
        }

        public void unsubscribe(String stream, boolean delete) throws IOException {
            this.callbacks.remove(stream);
        }

        public String composeStreamName(String parent, String name) {
            return parent + "/" + name;
        }

        public void connect(TransportParameter params) throws IOException {
        }

        public void disconnect() throws IOException {
        }

        public String getName() {
            return "Fake";
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public void detachReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
            this.unsubscribe(stream, true);
        }

        public void setSerializerProvider(SerializerRegistry.SerializerProvider serializerProvider) {
        }
    }

    @ExcludeFirst
    public static class TestFactoryDescriptor
    extends DefaultTransportFactoryDescriptor {
        private TransportFactory.ConnectorCreator dmc = new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return MY_DM_CONNECTOR;
            }

            public String getName() {
                return "IIP-Ecosphere direct memory transfer";
            }
        };
        private TransportFactory.ConnectorCreator fake = new TransportFactory.ConnectorCreator(){

            public TransportConnector createConnector() {
                return factoryUseDmcAsTransport ? MY_DM_CONNECTOR : MY_FAKE_CONNECTOR;
            }

            public String getName() {
                return "Fake";
            }
        };

        public TransportFactory.ConnectorCreator getMainCreator() {
            return this.dmc;
        }

        public TransportFactory.ConnectorCreator getIpcCreator() {
            return this.fake;
        }

        public TransportFactory.ConnectorCreator getDmCreator() {
            return this.fake;
        }
    }
}

