/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.transport.DefaultTransportFactoryDescriptor;
import de.iip_ecosphere.platform.transport.TransportFactoryDescriptor;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import java.util.Optional;

public class TransportFactory {
    private static ConnectorCreator mainCreator = DefaultTransportFactoryDescriptor.DEFAULT_DM_CREATOR;
    private static ConnectorCreator ipcCreator = DefaultTransportFactoryDescriptor.DEFAULT_DM_CREATOR;
    private static ConnectorCreator dmCreator = DefaultTransportFactoryDescriptor.DEFAULT_DM_CREATOR;
    private static boolean initialized = false;

    public static ConnectorCreator setMainImplementation(ConnectorCreator inst) {
        TransportFactory.initialize();
        ConnectorCreator old = mainCreator;
        if (null != inst) {
            mainCreator = inst;
        }
        return old;
    }

    public static ConnectorCreator setIpcImplementation(ConnectorCreator inst) {
        TransportFactory.initialize();
        ConnectorCreator old = ipcCreator;
        if (null != inst) {
            ipcCreator = inst;
        }
        return old;
    }

    public static ConnectorCreator setDmImplementation(ConnectorCreator inst) {
        TransportFactory.initialize();
        ConnectorCreator old = dmCreator;
        if (null != inst) {
            dmCreator = inst;
        }
        return old;
    }

    private static void initialize() {
        if (!initialized) {
            TransportFactoryDescriptor tDesc = null;
            Plugin pl = PluginManager.getPlugin(TransportFactoryDescriptor.class);
            if (null != pl) {
                tDesc = (TransportFactoryDescriptor)pl.getInstance();
            } else {
                Optional desc = ServiceLoaderUtils.filterExcluded(TransportFactoryDescriptor.class);
                if (desc.isPresent()) {
                    tDesc = (TransportFactoryDescriptor)desc.get();
                }
            }
            if (null != tDesc) {
                LoggerFactory.getLogger(TransportFactory.class).info("Configuring TransportFactory with " + tDesc.getClass().getName());
                mainCreator = TransportFactory.getCreator(tDesc.getMainCreator(), mainCreator);
                ipcCreator = TransportFactory.getCreator(tDesc.getIpcCreator(), ipcCreator);
                dmCreator = TransportFactory.getCreator(tDesc.getDmCreator(), dmCreator);
            }
            initialized = true;
        }
    }

    private static ConnectorCreator getCreator(ConnectorCreator creator, ConnectorCreator dflt) {
        return null == creator ? dflt : creator;
    }

    public static TransportConnector createConnector() {
        TransportFactory.initialize();
        return mainCreator.createConnector();
    }

    public static TransportConnector createIpcConnector() {
        TransportFactory.initialize();
        return ipcCreator.createConnector();
    }

    public static TransportConnector createDirectMemoryConnector() {
        TransportFactory.initialize();
        return dmCreator.createConnector();
    }

    public static String getConnectorName() {
        TransportFactory.initialize();
        return mainCreator.getName();
    }

    public static interface ConnectorCreator {
        public TransportConnector createConnector();

        public String getName();
    }
}

