/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.connectors.impl;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.impl.AbstractTransportConnector;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import java.io.IOException;

public class PrintTransportConnector
extends AbstractTransportConnector {
    private TransportConsumer consumer = (s, d) -> System.out.println(s + ":" + new String(d));

    public void setTransportConsumer(TransportConsumer consumer) {
        if (null != consumer) {
            this.consumer = consumer;
        }
    }

    @Override
    public void syncSend(String stream, Object data) throws IOException {
        this.send(stream, data);
    }

    @Override
    public void asyncSend(String stream, Object data) throws IOException {
        this.send(stream, data);
    }

    private void send(String stream, Object data) throws IOException {
        try {
            byte[] payload = this.serialize(stream, data);
            this.consumer.accept(stream, payload);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("While sending/serializing data: {}", (Object)e.getMessage());
        }
    }

    @Override
    protected <T> byte[] serialize(String stream, T data) throws IOException {
        byte[] result;
        Class<?> cls = data.getClass();
        Serializer<?> serializer = this.getSerializerProvider().getSerializer(cls);
        if (null != serializer) {
            System.out.println("Serializing " + String.valueOf(data.getClass()) + " through " + String.valueOf(this.getSerializerProvider().getClass()) + " by " + String.valueOf(serializer.getClass()));
            result = (byte[])serializer.to(data);
        } else {
            System.out.println("Serializing " + String.valueOf(data.getClass()) + " through " + String.valueOf(this.getSerializerProvider().getClass()) + " to default empty array as no serializer is available");
            result = new byte[]{};
        }
        return result;
    }

    @Override
    public String composeStreamName(String parent, String name) {
        return parent + "/" + name;
    }

    @Override
    public String getName() {
        return "Print transport connector (DEBUG)";
    }

    @Override
    public String supportedEncryption() {
        return null;
    }

    @Override
    public String enabledEncryption() {
        return null;
    }

    public static interface TransportConsumer {
        public void accept(String var1, byte[] var2);
    }
}

