/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.ant.modelcopy;

import de.uni_hildesheim.sse.easy.ant.AbstractModelTask;
import de.uni_hildesheim.sse.easy.ant.modelcopy.EASyModelFilter;
import de.uni_hildesheim.sse.easy.ant.modelcopy.ProjectUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.ProjectRewriteVisitor;
import net.ssehub.easy.varModel.model.rewrite.modifier.DeclarationNameFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.IModelElementFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectImportFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.ImportNameFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.ModelElementFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.tools.ant.BuildException;

public class ModelCopy
extends AbstractModelTask {
    private static final String CONFIG_FILE_EXTENSION = "cfg.ivml";
    private static final String BASICS_CONFIG = "BasicsCfg";
    private static final String PIPELINES_CONFIG = "PipelinesCfg";
    private static final String ALGORITHMS_CONFIG = "AlgorithmsCfg";
    private static final String DATAMGT_CONFIG = "DataManagementCfg";
    private static final String FAMILIES_CONFIG = "FamiliesCfg";
    private static final String HARDWARE_CONFIG = "HardwareCfg";
    private static final String INFRASTRUCTURE_CONFIG = "InfrastructureCfg";
    private static final String RECONFIGURABLE_HW_CONFIG = "ReconfigurableHardwareCfg";
    private static final String REMOVEABLE_CONFIG_EXTENSION = "^.*(_\\p{Digit}*|prioritypip)cfg.ivml$";
    private ProjectRewriteVisitor rewriter;

    public ModelCopy() {
        this.setAllowDestDeletion(false);
        this.rewriter = null;
    }

    public ModelCopy(String orgFolder, String cpyfolder, String mainProject) {
        this.setSourceFolder(orgFolder);
        this.setDestinationFolder(cpyfolder);
        this.setMainProject(mainProject);
        this.setAllowDestDeletion(true);
        this.rewriter = null;
    }

    private void copy() throws ModelManagementException, IOException {
        this.loadProject(this.getSourceFolder(), this.getMainProject());
        ArrayList originalFiles = new ArrayList(FileUtils.listFiles((File)this.getSourceFolder(), (IOFileFilter)new EASyModelFilter(), (IOFileFilter)TrueFileFilter.INSTANCE));
        Collections.sort(originalFiles, (f1, f2) -> f1.getAbsolutePath().compareTo(f2.getAbsolutePath()));
        for (File file : originalFiles) {
            String relativeFileName = this.getSourceFolder().toURI().relativize(file.toURI()).getPath();
            this.debugMessage("Processing: " + relativeFileName);
            File copyDestination = new File(this.getDestinationFolder(), relativeFileName);
            if (copyDestination.exists()) continue;
            File destFolder = copyDestination.getParentFile();
            destFolder.mkdirs();
            if (!relativeFileName.toLowerCase().endsWith(CONFIG_FILE_EXTENSION)) {
                FileUtils.copyFile((File)file, (File)copyDestination, (boolean)false);
                continue;
            }
            this.handleConfigFile(relativeFileName, destFolder);
        }
    }

    private void handleConfigFile(String relativeFileName, File destFolder) throws ModelManagementException, IOException {
        if (!relativeFileName.toLowerCase().matches(REMOVEABLE_CONFIG_EXTENSION)) {
            int lastDot = relativeFileName.lastIndexOf(46);
            int lastSeparator = relativeFileName.lastIndexOf(47);
            if (-1 == lastSeparator) {
                lastSeparator = relativeFileName.lastIndexOf(92);
            }
            String projectName = relativeFileName.substring(lastSeparator + 1, lastDot);
            Project p = ProjectUtilities.loadProject(projectName);
            this.debugMessage("Filter: " + projectName);
            if (BASICS_CONFIG.equals(p.getName())) {
                this.clearRewriter(p, FilterType.NO_IMPORTS);
                this.rewriter.addModelCopyModifier((IModelElementFilter)new DeclarationNameFilter(new String[]{"IntegerType", "LongType", "StringType", "BooleanType", "FloatType", "DoubleType", "RealType", "ObjectType"}));
                p.accept((IModelVisitor)this.rewriter);
            } else if (PIPELINES_CONFIG.equals(p.getName())) {
                this.clearRewriter(p, FilterType.NO_IMPORTS);
                this.rewriter.addImportModifier((IProjectImportFilter)new ImportNameFilter(new String[]{"Basics", "Pipelines", FAMILIES_CONFIG, DATAMGT_CONFIG}));
                p.accept((IModelVisitor)this.rewriter);
            } else if (ALGORITHMS_CONFIG.equals(p.getName())) {
                p = this.processDefaultConfig(p);
            } else if (DATAMGT_CONFIG.equals(p.getName())) {
                p = this.processDefaultConfig(p);
            } else if (FAMILIES_CONFIG.equals(p.getName())) {
                p = this.processDefaultConfig(p);
            } else if (HARDWARE_CONFIG.equals(p.getName())) {
                p = this.processDefaultConfig(p);
            } else if (RECONFIGURABLE_HW_CONFIG.equals(p.getName())) {
                p = this.processDefaultConfig(p);
            } else {
                int i;
                ArrayList<ProjectImport> imports = new ArrayList<ProjectImport>();
                for (i = 0; i < p.getImportsCount(); ++i) {
                    ProjectImport projectImport = p.getImport(i);
                    String importName = projectImport.getName().toLowerCase();
                    if ((importName + ".ivml").matches(REMOVEABLE_CONFIG_EXTENSION)) continue;
                    imports.add(projectImport);
                }
                p.clear();
                for (i = 0; i < imports.size(); ++i) {
                    p.addImport((ProjectImport)imports.get(i));
                }
            }
            ProjectUtilities.saveProject(destFolder, p);
        } else {
            this.debugMessage("Omitting: " + relativeFileName);
        }
    }

    private Project processDefaultConfig(Project p) {
        this.clearRewriter(p, FilterType.NO_IMPORTS);
        this.rewriter.addModelCopyModifier((IModelElementFilter)new ModelElementFilter(DecisionVariableDeclaration.class));
        p.accept((IModelVisitor)this.rewriter);
        return p;
    }

    private void clearRewriter(Project project, FilterType filterType) {
        if (null == this.rewriter) {
            this.rewriter = new ProjectRewriteVisitor(project, filterType);
        } else {
            this.rewriter.reset(project, filterType);
        }
    }

    @Override
    public void doModelOperation() throws BuildException {
        try {
            this.debugMessage("Start creation of copy");
            this.copy();
            this.debugMessage("Finished creation of copy");
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory((File)this.getDestinationFolder());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw new BuildException("IOError during copying models from \"" + this.getSourceFolder().getAbsolutePath() + "\" to \"" + this.getDestinationFolder().getAbsolutePath() + "\". Cause: " + e.getMessage());
            }
            if (e instanceof ModelManagementException) {
                throw new BuildException("Modelloadingerror during copying models from \"" + this.getSourceFolder().getAbsolutePath() + "\" to \"" + this.getDestinationFolder().getAbsolutePath() + "\". Cause: " + e.getMessage());
            }
            throw new BuildException("Unspecified error during copying models from \"" + this.getSourceFolder().getAbsolutePath() + "\" to \"" + this.getDestinationFolder().getAbsolutePath() + "\". Cause: " + e.getMessage());
        }
    }
}

