/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.ant.modelcopy;

import de.uni_hildesheim.sse.ModelUtility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class ProjectUtilities {
    private static ModelManagementException intialException;

    public static Project loadProject(String projectName) throws ModelManagementException, IOException {
        if (null != intialException) {
            throw intialException;
        }
        List infos = VarModel.INSTANCE.availableModels().getModelInfo(projectName);
        Project project = null;
        try {
            project = (Project)VarModel.INSTANCE.load((ModelInfo)infos.get(0));
        }
        catch (ModelManagementException mme) {
            System.out.println("Exception while loading : " + projectName);
            throw mme;
        }
        return project;
    }

    public static void saveProject(File destFolder, Project project) throws IOException {
        try (FileWriter fWriter = new FileWriter(new File(destFolder, project.getName() + ".ivml"));){
            IVMLWriter iWriter = new IVMLWriter((Writer)fWriter);
            project.accept((IModelVisitor)iWriter);
        }
    }

    static {
        try {
            VarModel.INSTANCE.loaders().registerLoader((IModelLoader)ModelUtility.INSTANCE, ProgressObserver.NO_OBSERVER);
        }
        catch (ModelManagementException e) {
            intialException = e;
        }
    }
}

