/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.ant;

import de.uni_hildesheim.sse.easy.ant.modelcopy.ProjectUtilities;
import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.impl.ReasonerRegistry;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.sseReasoner.Reasoner;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.validation.IvmlValidationVisitor;
import net.ssehub.easy.varModel.validation.ValidationMessage;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractModelTask
extends Task {
    private File sourceFolder;
    private File destinationFolder;
    private String mainProject;
    private boolean validate = true;
    private boolean verbose = true;
    private boolean allowDestDeletion = false;

    protected AbstractModelTask() {
        ReasonerRegistry.getInstance().register((IReasoner)new Reasoner());
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = new File(sourceFolder);
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = new File(destinationFolder);
    }

    public void setMainProject(String mainProject) {
        this.mainProject = mainProject;
    }

    public void setVebose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setAllowDestDeletion(boolean allowDestDeletion) {
        this.allowDestDeletion = allowDestDeletion;
    }

    public void setValidate(boolean valitate) {
        this.validate = valitate;
    }

    protected final File getSourceFolder() {
        return this.sourceFolder;
    }

    protected final File getDestinationFolder() {
        return this.destinationFolder;
    }

    protected final String getMainProject() {
        return this.mainProject;
    }

    protected final boolean getVebose() {
        return this.verbose;
    }

    protected final boolean getAllowDestDeletion() {
        return this.allowDestDeletion;
    }

    protected final boolean getValidate() {
        return this.validate;
    }

    protected void debugMessage(String msg) {
        if (this.getVebose()) {
            System.out.println(msg);
        }
    }

    protected void addOrRemoveLocation(ModelManagement<? extends IModel> modelManagement, File folder, boolean add) throws ModelManagementException {
        if (add) {
            modelManagement.locations().addLocation(folder, ProgressObserver.NO_OBSERVER);
        } else {
            modelManagement.locations().removeLocation(folder, ProgressObserver.NO_OBSERVER);
        }
    }

    protected Project loadProject(File folder, String mainProjectName) throws ModelManagementException, IOException {
        this.addOrRemoveLocation((ModelManagement<? extends IModel>)VarModel.INSTANCE, folder, true);
        Project p = ProjectUtilities.loadProject(mainProjectName);
        this.debugMessage(p.getName() + " sucessfully loaded.");
        return p;
    }

    public void execute() throws BuildException {
        this.debugMessage("Source folder: " + this.getSourceFolder().getAbsolutePath());
        this.debugMessage("Destination folder: " + this.getDestinationFolder().getAbsolutePath());
        this.debugMessage("Main model: " + this.getMainProject());
        this.debugMessage("Prepare destination folder: " + this.getDestinationFolder().getAbsolutePath());
        boolean createFolder = false;
        if (this.getDestinationFolder().exists() && this.getAllowDestDeletion()) {
            try {
                FileUtils.deleteDirectory((File)this.getDestinationFolder());
                createFolder = true;
            }
            catch (IOException e) {
                throw new BuildException("Destination folder \"" + this.getDestinationFolder().getAbsolutePath() + "\" exists and could not be deleted. Cause: " + e.getMessage());
            }
        } else if (this.getDestinationFolder().exists() && !this.getAllowDestDeletion() && this.getDestinationFolder().listFiles().length > 0) {
            throw new BuildException("Destination folder \"" + this.getDestinationFolder().getAbsolutePath() + "\" exists and is not empty.");
        }
        if (createFolder && !this.getDestinationFolder().mkdirs()) {
            throw new BuildException("Destination folder \"" + this.getDestinationFolder().getAbsolutePath() + "\" could not be created.");
        }
        this.doModelOperation();
        this.debugMessage("Validate Result");
        try {
            VarModel.INSTANCE.locations().removeLocation(this.getSourceFolder(), ProgressObserver.NO_OBSERVER);
            VarModel.INSTANCE.locations().addLocation(this.getDestinationFolder(), ProgressObserver.NO_OBSERVER);
            Project copiedProject = ProjectUtilities.loadProject(this.getMainProject());
            IvmlValidationVisitor validator = new IvmlValidationVisitor();
            copiedProject.accept((IModelVisitor)validator);
            if (validator.getErrorCount() > 0) {
                StringBuffer errMsg = new StringBuffer("Project \"");
                errMsg.append(this.getMainProject());
                errMsg.append("\" was copied, but the result contains inconsistencies:");
                for (int i = 0; i < validator.getMessageCount(); ++i) {
                    ValidationMessage msg = validator.getMessage(i);
                    errMsg.append("\n - ");
                    errMsg.append(msg.getStatus().name());
                    errMsg.append(": ");
                    errMsg.append(msg.getDescription());
                }
                if (this.getValidate()) {
                    throw new BuildException(errMsg.toString());
                }
                System.out.println(errMsg.toString());
            }
        }
        catch (ModelManagementException e) {
            if (this.getValidate()) {
                throw new BuildException("Copied Project contains errors: " + e.getMessage());
            }
            System.out.println("Copied Project contains errors: " + e.getMessage());
        }
        catch (IOException e) {
            if (this.getValidate()) {
                throw new BuildException("Copied Project contains IO errors: " + e.getMessage());
            }
            System.out.println("Copied Project contains IO errors: " + e.getMessage());
        }
    }

    protected abstract void doModelOperation();
}

