/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.debug;

import eu.qualimaster.adaptation.events.AdaptationEvent;
import eu.qualimaster.coordination.RepositoryConnector;
import eu.qualimaster.coordination.RepositoryHelper;
import eu.qualimaster.coordination.RuntimeVariableMapping;
import eu.qualimaster.easy.extension.debug.AbstractDebug;
import eu.qualimaster.easy.extension.internal.ConfigurationInitializer;
import eu.qualimaster.easy.extension.internal.CoordinationHelper;
import eu.qualimaster.monitoring.events.FrozenSystemState;
import java.io.File;
import java.io.IOException;
import net.ssehub.easy.basics.modelManagement.ModelInitializer;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.Executor;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.RtVilModel;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.Script;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;

public class Debug
extends AbstractDebug {
    private static AdaptationEvent event = new AdaptationEvent(){
        private static final long serialVersionUID = 2164881726000323540L;
    };
    private static final ReasonerConfiguration CONFIGURATION = new ReasonerConfiguration();

    static {
        CONFIGURATION.setRuntimeMode(true);
        CONFIGURATION.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
    }

    private static void process(String prefix, Configuration config, Script rtVilModel) {
        int file = 0;
        File tmp = RepositoryHelper.createTmpFolder();
        while (true) {
            File stateFile = new File("files", prefix + file);
            System.out.println("Checking " + stateFile.getAbsolutePath());
            if (!stateFile.exists()) break;
            try {
                FrozenSystemState state = new FrozenSystemState(stateFile);
                Executor exec = RepositoryHelper.createExecutor((Script)rtVilModel, (File)tmp, (Configuration)config, (AdaptationEvent)event, (FrozenSystemState)state);
                exec.stopAfterBindValues();
                try {
                    exec.execute();
                    ReasonerFrontend.getInstance().check(config, CONFIGURATION, ProgressObserver.NO_OBSERVER);
                }
                catch (Exception e) {
                    System.err.println("During value binding: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
                break;
            }
            ++file;
        }
    }

    public static void main(String[] args) throws ModelManagementException, ModelQueryException {
        if (args.length == 0) {
            System.out.println("qualimaster.debug: <model location> [monitor|adapt]");
            System.exit(0);
        } else {
            File modelLocation = new File(args[0]);
            if (!modelLocation.exists()) {
                System.out.println("model location " + String.valueOf(modelLocation) + " does not exist");
                System.exit(0);
            }
            String prefix = null;
            RepositoryConnector.Phase phase = RepositoryConnector.Phase.MONITORING;
            if (args.length > 1) {
                if ("monitor".equals(args[1])) {
                    prefix = "monitoring_";
                } else if ("adapt".equals(args[1])) {
                    prefix = "adaptation_";
                    phase = RepositoryConnector.Phase.ADAPTATION;
                }
            }
            RepositoryHelper.setInitializer((RepositoryHelper.IConnectorInitializer)new RepositoryHelper.NullConnectorInitializer());
            CoordinationHelper.setInTesting(true);
            Debug.initialize();
            ModelInitializer.registerLoader((ProgressObserver)ProgressObserver.NO_OBSERVER);
            ModelInitializer.addLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            Project project = (Project)RepositoryHelper.obtainModel((ModelManagement)VarModel.INSTANCE, (String)"QM", null);
            Script rtVilModel = (Script)RepositoryHelper.obtainModel((ModelManagement)RtVilModel.INSTANCE, (String)"QM", null);
            RuntimeVariableMapping rMapping = new RuntimeVariableMapping();
            Configuration config = RepositoryHelper.createConfiguration((Project)project, (String)"TESTING", (RuntimeVariableMapping)rMapping);
            rMapping = ConfigurationInitializer.createVariableMapping(config, rMapping);
            new RepositoryConnector.Models(phase, config, rtVilModel, null, rMapping);
            System.out.println("Model loaded...");
            if (prefix != null) {
                Debug.process(prefix, config, rtVilModel);
            }
        }
    }
}

