/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.debug;

import eu.qualimaster.coordination.RepositoryHelper;
import eu.qualimaster.easy.extension.debug.AbstractDebug;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import net.ssehub.easy.basics.modelManagement.ModelInitializer;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class DebugParallel
extends AbstractDebug {
    private static final ReasonerConfiguration RCFG = new ReasonerConfiguration();
    private static AtomicInteger count = new AtomicInteger(10);

    static {
        RCFG.setRuntimeMode(true);
    }

    public static void main(String[] args) throws ModelManagementException {
        if (args.length == 0) {
            System.out.println("qualimaster.debug: <model location> [monitor|adapt]");
            System.exit(0);
        } else {
            File modelLocation = new File(args[0]);
            if (!modelLocation.exists()) {
                System.out.println("model location " + String.valueOf(modelLocation) + " does not exist");
                System.exit(0);
            }
            DebugParallel.initialize();
            ModelInitializer.registerLoader((ProgressObserver)ProgressObserver.NO_OBSERVER);
            ModelInitializer.addLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            Project project = (Project)RepositoryHelper.obtainModel((ModelManagement)VarModel.INSTANCE, (String)"QM", null);
            Configuration monConfig = RepositoryHelper.createConfiguration((Project)project, (String)"MONITORING", null);
            ModelInitializer.removeLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            ModelInitializer.addLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            project = (Project)RepositoryHelper.obtainModel((ModelManagement)VarModel.INSTANCE, (String)"QM", null);
            Configuration adaptConfig = RepositoryHelper.createConfiguration((Project)project, (String)"ADAPTATION", null);
            ModelInitializer.removeLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
            ReasoningRunnable r1 = new ReasoningRunnable("Monitoring", monConfig);
            ReasoningRunnable r2 = new ReasoningRunnable("Adaptation", adaptConfig);
            Thread t1 = new Thread(r1);
            Thread t2 = new Thread(r2);
            t1.start();
            t2.start();
            while (count.get() > 0) {
                DebugParallel.sleep(500);
            }
        }
    }

    private static class ReasoningRunnable
    implements Runnable {
        private String name;
        private Configuration cfg;

        private ReasoningRunnable(String name, Configuration cfg) {
            this.name = name;
            this.cfg = cfg;
        }

        @Override
        public void run() {
            while (count.getAndDecrement() > 0) {
                System.out.println("> " + this.name);
                try {
                    ReasoningResult rr = ReasonerFrontend.getInstance().propagate(this.cfg, RCFG, ProgressObserver.NO_OBSERVER);
                    rr.logInformation(this.cfg.getProject(), RCFG);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println("< " + this.name);
                DebugParallel.sleep(5);
            }
        }
    }
}

