/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.easy.extension.internal.AlgorithmPredictionResult;
import eu.qualimaster.easy.extension.internal.AlgorithmPredictor;
import eu.qualimaster.easy.extension.internal.PredictionUtils;
import eu.qualimaster.events.IReturnableEvent;
import eu.qualimaster.events.SynchronousEventStore;
import eu.qualimaster.monitoring.events.AlgorithmProfilePredictionRequest;
import eu.qualimaster.monitoring.events.AlgorithmProfilePredictionResponse;
import eu.qualimaster.observables.IObservable;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

class AlgorithmPredictorImpl
extends AlgorithmPredictor {
    private SynchronousEventStore<AlgorithmProfilePredictionRequest, AlgorithmProfilePredictionResponse> store = new SynchronousEventStore(AlgorithmProfilePredictionResponse.class);

    AlgorithmPredictorImpl() {
    }

    @Override
    public Double algorithmPrediction(String pipeline, String pipelineElement, String algorithm, IObservable observable) {
        return this.algorithmPrediction(pipeline, pipelineElement, algorithm, observable, null);
    }

    @Override
    public Double algorithmPrediction(String pipeline, String pipelineElement, String algorithm, IObservable observable, Map<Object, Serializable> targetValues) {
        AlgorithmProfilePredictionResponse resp = this.waitFor(new AlgorithmProfilePredictionRequest(pipeline, pipelineElement, algorithm, observable, targetValues));
        double tmp = resp.getPrediction();
        Double result = Double.MIN_VALUE == tmp ? null : Double.valueOf(tmp);
        return result;
    }

    @Override
    public Map<String, Map<IObservable, Double>> algorithmPrediction(String pipeline, String pipelineElement, Set<String> algorithms, Set<IObservable> observables, Map<Object, Serializable> targetValues) {
        AlgorithmProfilePredictionResponse resp = this.waitFor(new AlgorithmProfilePredictionRequest(pipeline, pipelineElement, algorithms, observables, targetValues));
        return resp.getMassPrediction();
    }

    @Override
    public Map<String, Map<IObservable, Double>> parameterPrediction(String pipeline, String pipelineElement, String parameter, Set<IObservable> observables, Map<Object, Serializable> targetValues) {
        AlgorithmProfilePredictionResponse resp = this.waitFor(new AlgorithmProfilePredictionRequest(pipeline, pipelineElement, parameter, observables, targetValues));
        return resp.getMassPrediction();
    }

    @Override
    public AlgorithmPredictionResult algorithmPredictionEx(String pipeline, String pipelineElement, Set<String> algorithms, Set<IObservable> observables) {
        AlgorithmPredictionResult res = null;
        AlgorithmProfilePredictionRequest req = new AlgorithmProfilePredictionRequest(pipeline, pipelineElement, algorithms, observables, null);
        req.doMultiAlgorithmPrediction();
        AlgorithmProfilePredictionResponse resp = this.waitFor(req);
        if (resp != null) {
            res = new AlgorithmPredictionResult(PredictionUtils.transferMap(resp.getMassPrediction(), String.class, IObservable.class, Double.class), PredictionUtils.transferMap(resp.getParameters(), String.class, Object.class, Serializable.class));
        }
        return res;
    }

    private AlgorithmProfilePredictionResponse waitFor(AlgorithmProfilePredictionRequest request) {
        return (AlgorithmProfilePredictionResponse)this.store.waitFor(2000L, 100L, (IReturnableEvent)request);
    }
}

