/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.adaptation.AdaptationManager;
import eu.qualimaster.common.QMInternal;
import eu.qualimaster.coordination.INameMapping;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;

@Instantiator(value="getImplementationName")
public class NameMappingHelper
implements IVilType {
    public static String getImplementationName(String pipelineName, String pipelineNodeName) {
        return NameMappingHelper.getPipelineElementImplName(NameMappingHelper.getNameMapping(pipelineName), pipelineNodeName);
    }

    @QMInternal
    public static INameMapping getNameMapping(String pipelineName) {
        return AdaptationManager.getNameMapping((String)pipelineName);
    }

    @QMInternal
    public static String getPipelineElementImplName(INameMapping mapping, String pipelineElementName) {
        INameMapping.Component cmp;
        String result = pipelineElementName;
        if (mapping != null && (cmp = mapping.getPipelineNodeComponent(pipelineElementName)) != null) {
            result = cmp.getName();
        }
        return result;
    }

    public static String getAlgorithmImplName(INameMapping mapping, String algorithmName) {
        INameMapping.Algorithm alg;
        String result = algorithmName;
        if (mapping != null && (alg = mapping.getAlgorithm(algorithmName)) != null) {
            result = alg.getImplName();
        }
        return result;
    }

    public static String mapPipelineElementName(INameMapping mapping, String pipelineElementName) {
        INameMapping.Component cmp;
        String tmp;
        String result = pipelineElementName;
        if (mapping != null && (tmp = mapping.getPipelineNodeByImplName(pipelineElementName)) != null && (cmp = mapping.getPipelineNodeComponent(tmp)) != null) {
            result = cmp.getName();
        }
        return result;
    }

    public static String mapAlgorithmName(INameMapping mapping, String algorithmName) {
        INameMapping.Algorithm alg;
        String result = algorithmName;
        if (mapping != null && (alg = mapping.getAlgorithmByImplName(algorithmName)) != null) {
            result = alg.getName();
        }
        return result;
    }
}

