/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.easy.extension.internal.VariableHelper;
import eu.qualimaster.monitoring.events.ViolatingClause;
import java.util.HashSet;
import java.util.Iterator;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

@Instantiator(value="obtainPipeline")
public class PipelineHelper
implements IVilType {
    public static DecisionVariable obtainPipeline(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration configuration, String variableName) throws VilException {
        return PipelineHelper.obtainPipeline(configuration, variableName, false);
    }

    public static DecisionVariable obtainPipeline(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration configuration, String variableName, boolean strict) throws VilException {
        DecisionVariable var;
        DecisionVariable result = null;
        if (variableName != null && (var = PipelineHelper.getByName(configuration, variableName)) != null) {
            IDecisionVariable decVar = var.getVariable();
            while (decVar.getParent() instanceof IDecisionVariable) {
                decVar = (IDecisionVariable)decVar.getParent();
            }
            try {
                IDatatype pipelineType;
                IDecisionVariable pipVar = PipelineHelper.obtainPipeline(configuration.getConfiguration(), decVar);
                if (strict && pipVar == null && decVar != null && (pipelineType = ModelQuery.findType((IResolutionScope)configuration.getConfiguration().getProject(), (String)"Pipeline", null)).isAssignableFrom(decVar.getDeclaration().getType())) {
                    pipVar = decVar;
                }
                if (pipVar != null && (!strict || strict && pipVar == decVar)) {
                    result = configuration.getByName(Configuration.getInstanceName((IDecisionVariable)pipVar));
                }
            }
            catch (ModelQueryException e) {
                throw new VilException((Throwable)e, 40005);
            }
        }
        return result;
    }

    static DecisionVariable getByName(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration configuration, String variableName) {
        DecisionVariable result = configuration.getByName(variableName);
        if (result == null && variableName.length() > 0) {
            int pos = variableName.lastIndexOf("::");
            if (pos > 0) {
                String prefix = variableName.substring(0, pos);
                String postfix = variableName.substring(pos + 2);
                DecisionVariable tmp = PipelineHelper.getByName(configuration, prefix);
                if (tmp != null) {
                    result = tmp.getByName(postfix);
                }
            } else {
                variableName = "";
            }
        }
        return result;
    }

    @Invisible
    public static IDecisionVariable obtainPipeline(Configuration configuration, IDecisionVariable element) throws ModelQueryException {
        IDecisionVariable result = null;
        if (element != null) {
            IDatatype pipelineType;
            Project prj;
            IDatatype pipelineElementType;
            AbstractVariable elementDecl = element.getDeclaration();
            IDatatype elementType = elementDecl.getType();
            IModelElement par = elementDecl.getTopLevelParent();
            if (par instanceof Project && (pipelineElementType = ModelQuery.findType((IResolutionScope)(prj = (Project)par), (String)"PipelineElement", null)) != null && pipelineElementType.isAssignableFrom(elementType) && (pipelineType = ModelQuery.findType((IResolutionScope)prj, (String)"Pipeline", null)) != null) {
                result = PipelineHelper.searchScope(configuration, (IResolutionScope)prj, pipelineType);
            }
        }
        return result;
    }

    private static IDecisionVariable searchScope(Configuration configuration, IResolutionScope scope, IDatatype type) {
        IDecisionVariable result = null;
        DecisionVariableDeclaration decl = ModelQuery.findDeclaration((IResolutionScope)scope, (ModelQuery.IDeclarationSelector)new ModelQuery.FirstDeclTypeSelector(type));
        if (decl != null) {
            result = configuration.getConfiguration().getDecision((AbstractVariable)decl);
        }
        return result;
    }

    @ReturnGenerics(value={DecisionVariable.class})
    public static Set<DecisionVariable> obtainPipeline(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration configuration, Collection<?> clauses) throws VilException {
        Iterator iter = clauses == null ? null : clauses.iterator();
        return PipelineHelper.obtainPipeline(configuration, iter);
    }

    @ReturnGenerics(value={DecisionVariable.class})
    public static Set<DecisionVariable> obtainPipeline(net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration configuration, Iterator<?> clauses) throws VilException {
        HashSet<String> done = new HashSet<String>();
        HashSet<DecisionVariable> result = new HashSet<DecisionVariable>();
        if (clauses != null) {
            while (clauses.hasNext()) {
                String variableName;
                Object cl = clauses.next();
                if (!(cl instanceof ViolatingClause) || done.contains(variableName = ((ViolatingClause)cl).getVariable())) continue;
                done.add(variableName);
                DecisionVariable var = PipelineHelper.obtainPipeline(configuration, variableName);
                if (var == null) continue;
                result.add(var);
            }
        }
        return new SetSet(result, DecisionVariable.class);
    }

    @QMInternal
    public static IDecisionVariable obtainPipelineByName(Configuration config, String name) {
        return PipelineHelper.obtainPipelineByName(config, name, "pipelines");
    }

    @QMInternal
    public static IDecisionVariable obtainPipelineByName(Configuration config, String name, String varName) {
        IDecisionVariable result = null;
        try {
            AbstractVariable pips = ModelQuery.findVariable((IResolutionScope)config.getProject(), (String)varName, null);
            IDecisionVariable pipsVar = config.getDecision(pips);
            if (pipsVar != null) {
                int n = 0;
                while (result == null && n < pipsVar.getNestedElementsCount()) {
                    IDecisionVariable pip = Configuration.dereference((IDecisionVariable)pipsVar.getNestedElement(n));
                    if (VariableHelper.hasName(pip, name)) {
                        result = pip;
                    }
                    ++n;
                }
            }
        }
        catch (ModelQueryException modelQueryException) {
            // empty catch block
        }
        return result;
    }

    @QMInternal
    public static IDecisionVariable obtainFamilyByName(IDecisionVariable pipeline, String name) {
        IDecisionVariable result = null;
        if (pipeline != null) {
            try {
                IDatatype type = ModelQuery.findType((IResolutionScope)pipeline.getConfiguration().getProject(), (String)"FamilyElement", null);
                result = PipelineHelper.obtainPipelineElementByName(pipeline, type, name);
            }
            catch (ModelQueryException modelQueryException) {
                // empty catch block
            }
        }
        return result;
    }

    @QMInternal
    public static boolean isHardwareAlgorithm(IDecisionVariable var) {
        boolean result = false;
        if (var != null) {
            try {
                IDatatype hwAlgType = ModelQuery.findType((IResolutionScope)var.getConfiguration().getProject(), (String)"HardwareAlgorithm", null);
                if (hwAlgType != null) {
                    result = hwAlgType.isAssignableFrom(var.getDeclaration().getType());
                }
            }
            catch (ModelQueryException modelQueryException) {
                // empty catch block
            }
        }
        return result;
    }

    @QMInternal
    public static IDecisionVariable obtainAlgorithmByName(Configuration config, String name) {
        IDecisionVariable result = null;
        try {
            IDecisionVariable algs;
            AbstractVariable algVarDecl = ModelQuery.findVariable((IResolutionScope)config.getProject(), (String)"algorithms", null);
            if (algVarDecl != null && (algs = config.getDecision(algVarDecl)) != null) {
                int n = 0;
                while (result == null && n < algs.getNestedElementsCount()) {
                    IDecisionVariable nested = Configuration.dereference((IDecisionVariable)algs.getNestedElement(n));
                    if (VariableHelper.hasName(nested, name)) {
                        result = nested;
                    }
                    ++n;
                }
            }
        }
        catch (ModelQueryException modelQueryException) {
            // empty catch block
        }
        return result;
    }

    @QMInternal
    public static IDecisionVariable obtainPipelineElementByName(IDecisionVariable pipeline, IDatatype type, String name) {
        IDecisionVariable result = null;
        Configuration config = null;
        Project project = null;
        if (pipeline != null) {
            config = pipeline.getConfiguration();
            AbstractVariable var = pipeline.getDeclaration();
            project = var.getProject();
        }
        if (project != null) {
            int e = 0;
            int n = project.getElementCount();
            while (result == null && e < n) {
                ContainableModelElement elt = project.getElement(e);
                if (elt instanceof DecisionVariableDeclaration) {
                    IDecisionVariable decVar;
                    DecisionVariableDeclaration decl = (DecisionVariableDeclaration)elt;
                    if ((type == null || type.isAssignableFrom(decl.getType())) && (VariableHelper.hasName(decVar = config.getDecision((AbstractVariable)decl), name) || decVar.getDeclaration().getName().equals(name))) {
                        result = decVar;
                    }
                }
                ++e;
            }
        }
        return result;
    }

    @QMInternal
    public static IDecisionVariable obtainAlgorithmFromFamilyByName(IDecisionVariable family, String name) {
        return PipelineHelper.obtainAlgorithmFromFamilyByName(family, "available", name);
    }

    public static IDecisionVariable obtainAlgorithmFromFamilyByName(IDecisionVariable family, String slot, String name) {
        IDecisionVariable avail;
        IDecisionVariable result = null;
        if (family != null && (avail = family.getNestedElement(slot)) != null) {
            int n = 0;
            int c = avail.getNestedElementsCount();
            while (result == null && n < c) {
                IDecisionVariable alg = Configuration.dereference((IDecisionVariable)avail.getNestedElement(n));
                if (VariableHelper.hasName(alg, name)) {
                    result = alg;
                }
                ++n;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setActual(IDecisionVariable pElt, String algorithm) throws VilException {
        IDecisionVariable actual = pElt.getNestedElement("actual");
        if (actual == null) throw new VilException("No actual slot", 50502);
        if (AssignmentState.UNDEFINED != actual.getState() && NullValue.INSTANCE != actual.getValue()) return;
        IDecisionVariable available = pElt.getNestedElement("available");
        if (available == null) throw new VilException("No available slot", 50502);
        IDecisionVariable algVar = VariableHelper.findNamedVariable(available, null, algorithm);
        if (algVar == null) return;
        try {
            Value val = ValueFactory.createValue((IDatatype)actual.getDeclaration().getType(), (Object[])new Object[]{algVar.getDeclaration()});
            actual.setValue(val, (IAssignmentState)AssignmentState.USER_ASSIGNED);
            return;
        }
        catch (ValueDoesNotMatchTypeException e) {
            throw new VilException((Throwable)e, 50502);
        }
        catch (ConfigurationException e) {
            throw new VilException((Throwable)e, 50502);
        }
    }

    @QMInternal
    public static IDecisionVariable getAvailable(IDecisionVariable pElt, String algorithm) throws VilException {
        IDecisionVariable result = null;
        IDecisionVariable available = pElt.getNestedElement("available");
        if (available == null) {
            throw new VilException("No available slot", 50502);
        }
        result = VariableHelper.findNamedVariable(available, null, algorithm);
        return result;
    }

    public static void setActual(Configuration config, String pipeline, String pipelineElement, String algorithm) throws VilException {
        IDecisionVariable pVar = PipelineHelper.obtainPipelineByName(config, pipeline);
        IDecisionVariable pElt = PipelineHelper.obtainPipelineElementByName(pVar, null, pipelineElement);
        if (pElt != null) {
            PipelineHelper.setActual(pElt, algorithm);
        }
    }
}

