/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.debug;

import eu.qualimaster.coordination.RepositoryHelper;
import eu.qualimaster.easy.extension.debug.AbstractDebug;
import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.modelop.ModelModifier;
import java.io.File;
import net.ssehub.easy.basics.modelManagement.ModelInitializer;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.producer.core.persistence.standard.StandaloneProjectDescriptor;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import org.apache.commons.io.FileUtils;

public class DebugModelPruning
extends AbstractDebug {
    public static final ReasonerConfiguration RCONFIG = new ReasonerConfiguration();

    static {
        RCONFIG.enableCustomMessages();
    }

    public static void main(String[] args) throws Exception {
        File modelLocation = DebugModelPruning.loadModelLocation(args);
        File tmpFolder = new File(System.getProperty("java.io.tmpdir"), "DebugModelPruningTest");
        FileUtils.deleteQuietly((File)tmpFolder);
        tmpFolder.mkdirs();
        tmpFolder.deleteOnExit();
        File pruneFolder = new File(tmpFolder, "prune");
        File trgFolder = new File(tmpFolder, "trg");
        TracerFactory.setInstance((TracerFactory)ConsoleTracerFactory.INSTANCE);
        DebugModelPruning.initialize();
        ModelInitializer.registerLoader((ProgressObserver)ProgressObserver.NO_OBSERVER);
        ModelInitializer.addLocation((File)modelLocation, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        Project project = (Project)RepositoryHelper.obtainModel((ModelManagement)VarModel.INSTANCE, (String)"QM", null);
        Configuration config = new Configuration(project, true);
        Script script = (Script)RepositoryHelper.obtainModel((ModelManagement)BuildModel.INSTANCE, (String)"QM", null);
        ReasoningResult rr = ReasonerFrontend.getInstance().propagate(config, RCONFIG, ProgressObserver.NO_OBSERVER);
        rr.logInformation(config.getProject(), RCONFIG);
        ModelModifier modifier = new ModelModifier(pruneFolder, project, modelLocation, new ModelModifier.QMPlatformProvider(){

            @Override
            public void showExceptionDialog(String title, Exception exception) {
                Bundle.getLogger(this.getClass()).exception(exception);
            }

            @Override
            public void reason(Configuration config) {
                ReasoningResult rr = ReasonerFrontend.getInstance().propagate(config, RCONFIG, ProgressObserver.NO_OBSERVER);
                rr.logInformation(config.getProject(), RCONFIG);
            }
        });
        Executor executor = modifier.createExecutor();
        if (executor == null) {
            System.err.println("ModelModifier did not created an executor, an unknown exception must be occured.");
            System.exit(0);
        }
        StandaloneProjectDescriptor source = new StandaloneProjectDescriptor(script, modelLocation);
        StandaloneProjectDescriptor target = new StandaloneProjectDescriptor(script, trgFolder);
        executor.addSource((IProjectDescriptor)source).addTarget((IProjectDescriptor)target);
        executor.execute();
    }
}

