/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.internal.PipelineContentsContainer;
import eu.qualimaster.easy.extension.internal.Utils;
import eu.qualimaster.easy.extension.internal.VariableHelper;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public class PipelineVisitor {
    private PipelineContentsContainer container;
    private Configuration config;
    private boolean containerInitialized;
    private boolean initializeRuntimeMapping;
    private Set<IDecisionVariable> done = new HashSet<IDecisionVariable>();
    private IVariableMapper mapper;

    PipelineVisitor(IDecisionVariable pipeline, IVariableMapper mapper) {
        this(pipeline, true, mapper);
    }

    public PipelineVisitor(IDecisionVariable pipeline, boolean initializeRuntimeMapping) {
        this(pipeline, initializeRuntimeMapping, null);
    }

    public PipelineVisitor(IDecisionVariable pipeline, boolean initializeRuntimeMapping, IVariableMapper mapper) {
        this.mapper = mapper;
        this.initializeRuntimeMapping = initializeRuntimeMapping;
        String pipelineName = VariableHelper.getName(pipeline);
        if (pipelineName == null) {
            pipelineName = pipeline.getDeclaration().getName();
        }
        this.container = new PipelineContentsContainer(pipelineName);
        this.containerInitialized = false;
        this.config = pipeline.getConfiguration();
        ContainerValue sources = (ContainerValue)pipeline.getNestedElement("sources").getValue();
        this.visitContainerValue(sources);
    }

    public PipelineContentsContainer getPipelineContents() {
        if (!this.containerInitialized && this.initializeRuntimeMapping) {
            this.containerInitialized = true;
            this.container.init();
        }
        return this.container;
    }

    private void visitPipelineElement(IDecisionVariable pipelineElement) {
        if (pipelineElement != null && !this.done.contains(pipelineElement)) {
            this.done.add(pipelineElement);
            String typeName = pipelineElement.getDeclaration().getType().getName();
            if ("Source".equals(typeName)) {
                this.container.addSource(pipelineElement);
                IDecisionVariable nextVars = pipelineElement.getNestedElement("output");
                if (nextVars == null) {
                    nextVars = pipelineElement.getNestedElement("next");
                }
                if (nextVars != null) {
                    ContainerValue referencedVariables = (ContainerValue)nextVars.getValue();
                    this.visitContainerValue(referencedVariables);
                }
                this.visitAvailable(pipelineElement, pipelineElement.getNestedElement("source"));
            } else if ("Flow".equals(typeName)) {
                IDecisionVariable nextVar = pipelineElement.getNestedElement("destination");
                if (nextVar != null) {
                    ReferenceValue refValue = (ReferenceValue)nextVar.getValue();
                    IDecisionVariable referencedVariable = this.extractVar(refValue);
                    this.visitPipelineElement(referencedVariable);
                }
            } else if ("FamilyElement".equals(typeName)) {
                this.container.addFamilyElement(pipelineElement);
                this.visitProcessingElement(pipelineElement);
                IDecisionVariable family = Configuration.dereference((IDecisionVariable)pipelineElement.getNestedElement("family"));
                IDecisionVariable members = family.getNestedElement("members");
                this.visitAvailable(pipelineElement, members);
            } else if ("DataManagementElement".equals(typeName)) {
                this.container.addDataManagementElement(pipelineElement);
                this.visitProcessingElement(pipelineElement);
            } else if ("ReplaySink".equals(typeName)) {
                this.container.addReplaySink(pipelineElement);
                this.visitAvailable(pipelineElement, pipelineElement.getNestedElement("sink"));
            } else if ("Sink".equals(typeName)) {
                this.container.addSink(pipelineElement);
                this.visitAvailable(pipelineElement, pipelineElement.getNestedElement("sink"));
            } else {
                this.visitProcessingElement(pipelineElement);
            }
        }
    }

    private void visitAvailable(IDecisionVariable pipelineElement, IDecisionVariable oVar) {
        if (this.mapper != null) {
            IDecisionVariable aVar = pipelineElement.getNestedElement("available");
            if (oVar == null) {
                Bundle.getLogger(PipelineVisitor.class).warn("No original slot found in " + pipelineElement.getQualifiedName());
            } else if (aVar == null) {
                Bundle.getLogger(PipelineVisitor.class).warn("No slot available found in " + pipelineElement.getQualifiedName());
            } else {
                this.visitAvailable(oVar.getValue(), aVar.getValue(), pipelineElement.getQualifiedName());
            }
        }
    }

    private void visitAvailable(Value oValue, Value aValue, String eltName) {
        if (oValue == null) {
            Bundle.getLogger(PipelineVisitor.class).warn("Original value of is null " + eltName);
        } else if (!(aValue instanceof ContainerValue)) {
            Bundle.getLogger(PipelineVisitor.class).warn("Value of available is not a container " + eltName);
        } else {
            ContainerValue aCnt = (ContainerValue)aValue;
            if (oValue instanceof ContainerValue) {
                ContainerValue oCnt = (ContainerValue)oValue;
                int max = Math.max(oCnt.getElementSize(), aCnt.getElementSize());
                int i = 0;
                while (i < max) {
                    Value ov = oCnt.getElement(i);
                    Value av = aCnt.getElement(i);
                    if (ov instanceof ReferenceValue && av instanceof ReferenceValue) {
                        IDecisionVariable o = this.extractVar((ReferenceValue)ov);
                        IDecisionVariable a = this.extractVar((ReferenceValue)av);
                        this.mapper.map(o, a);
                    }
                    ++i;
                }
            } else if (aCnt.getElementSize() > 0 && oValue instanceof ReferenceValue) {
                IDecisionVariable o = this.extractVar((ReferenceValue)oValue);
                Value av = aCnt.getElement(0);
                if (av instanceof ReferenceValue) {
                    IDecisionVariable a = this.extractVar((ReferenceValue)av);
                    this.mapper.map(o, a);
                }
            }
        }
    }

    private void visitProcessingElement(IDecisionVariable pipelineElement) {
        IDecisionVariable nextVars = pipelineElement.getNestedElement("output");
        if (nextVars != null) {
            ContainerValue referencedVariables = (ContainerValue)nextVars.getValue();
            this.visitContainerValue(referencedVariables);
        }
    }

    private void visitContainerValue(ContainerValue containerValue) {
        if (containerValue != null) {
            int i = 0;
            int end = containerValue.getElementSize();
            while (i < end) {
                ReferenceValue refValue = (ReferenceValue)containerValue.getElement(i);
                IDecisionVariable referencedVariable = this.extractVar(refValue);
                this.visitPipelineElement(referencedVariable);
                ++i;
            }
        }
    }

    private IDecisionVariable extractVar(ReferenceValue refValue) {
        return Utils.extractVariable(refValue, this.config);
    }

    static interface IVariableMapper {
        public void map(IDecisionVariable var1, IDecisionVariable var2);
    }
}

