/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.modelop;

import de.uni_hildesheim.sse.ConstraintSyntaxException;
import de.uni_hildesheim.sse.ModelUtility;
import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.internal.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class BasicIVMLModelOperations {
    public static final String ADD = "add";
    public static final String DEL = "del";

    public static DecisionVariableDeclaration getDecisionVariable(Project source, String variableName, String suffix, Project destination) {
        DecisionVariableDeclaration decisionVariable = null;
        String projectName = destination.getName();
        Object givenName = projectName.substring(0, projectName.indexOf("Cfg"));
        if (suffix != null) {
            givenName = (String)givenName + "_" + variableName + suffix;
        }
        try {
            IDatatype dataType = ModelQuery.findType((IResolutionScope)source, (String)variableName, null);
            decisionVariable = new DecisionVariableDeclaration((String)givenName, dataType, (IModelElement)destination);
        }
        catch (ModelQueryException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        return decisionVariable;
    }

    public static ConstraintSyntaxTree obtainAssignment(Value value, AbstractVariable declarationVariable) {
        OCLFeatureCall assignment = new OCLFeatureCall((ConstraintSyntaxTree)new Variable(declarationVariable), "=", new ConstraintSyntaxTree[]{new ConstantValue(value)});
        return assignment;
    }

    public static Constraint getConstraint(Object[] objectValue, AbstractVariable declarationVariable, IModelElement parent) {
        Constraint constraint = new Constraint(parent);
        try {
            Value value = ValueFactory.createValue((IDatatype)declarationVariable.getType(), (Object[])objectValue);
            constraint.setConsSyntax(BasicIVMLModelOperations.obtainAssignment(value, declarationVariable));
        }
        catch (ValueDoesNotMatchTypeException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        catch (CSTSemanticException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        return constraint;
    }

    public static Map<String, IDatatype> getCompoundNameAndType(AbstractVariable decisionDeclaration) {
        String compoundName = null;
        HashMap<String, IDatatype> map = new HashMap<String, IDatatype>();
        Compound compoundType = (Compound)decisionDeclaration.getType();
        int i = 0;
        while (i < compoundType.getInheritedElementCount()) {
            DecisionVariableDeclaration nestedDecl = compoundType.getInheritedElement(i);
            compoundName = nestedDecl.getName();
            IDatatype type = nestedDecl.getType();
            if (type instanceof Reference) {
                Reference refType = (Reference)type;
                map.put(compoundName, (IDatatype)refType);
            } else {
                map.put(compoundName, type);
            }
            ++i;
        }
        return map;
    }

    public static Object[] configureCompoundValues(DecisionVariableDeclaration decisionVariable, Map<String, Object> compound) {
        ArrayList<Object> sourceObject = new ArrayList<Object>();
        DecisionVariableDeclaration compoundVariable = null;
        Map<Object, Object> compoundVariablesMap = new HashMap();
        compoundVariablesMap = BasicIVMLModelOperations.getCompoundNameAndType((AbstractVariable)decisionVariable);
        Set<String> compoundNames = compound.keySet();
        for (String name : compoundNames) {
            if (compound.get(name).getClass().isArray()) {
                sourceObject.add(name);
                Object[] arrayVar = (Object[])compound.get(name);
                if (arrayVar == null || arrayVar.length <= 0 || !(arrayVar[0] instanceof ConstraintSyntaxTree)) {
                    DecisionVariableDeclaration[] variables = new DecisionVariableDeclaration[arrayVar.length];
                    int i = 0;
                    while (i < arrayVar.length) {
                        Object var = arrayVar[i];
                        variables[i] = new DecisionVariableDeclaration(var.toString(), (IDatatype)compoundVariablesMap.get(name), (IModelElement)decisionVariable);
                        ++i;
                    }
                    arrayVar = variables;
                }
                sourceObject.add(arrayVar);
                continue;
            }
            if (compound.get(name) instanceof ConstraintSyntaxTree) {
                sourceObject.add(name);
                sourceObject.add(compound.get(name));
                continue;
            }
            compoundVariable = new DecisionVariableDeclaration(compound.get(name).toString(), (IDatatype)compoundVariablesMap.get(name), (IModelElement)decisionVariable);
            sourceObject.add(name);
            sourceObject.add(compoundVariable);
        }
        Object[] object = sourceObject.toArray();
        return object;
    }

    public static Value obtainConstraintValue(String constraint, IModelElement parent) {
        Value cstValue = null;
        try {
            ConstraintSyntaxTree cst = ModelUtility.INSTANCE.createExpression(constraint, parent);
            cstValue = ValueFactory.createValue((IDatatype)ConstraintType.TYPE, (Object[])new Object[]{cst});
        }
        catch (CSTSemanticException e) {
            e.printStackTrace();
        }
        catch (ConstraintSyntaxException e) {
            e.printStackTrace();
        }
        catch (ValueDoesNotMatchTypeException e) {
            e.printStackTrace();
        }
        return cstValue;
    }

    public static AbstractVariable getDeclaration(IDecisionVariable variable) {
        AbstractVariable decl = null;
        decl = variable.getValue() != null && variable.getValue() instanceof ReferenceValue ? ((ReferenceValue)variable.getValue()).getValue() : variable.getDeclaration();
        return decl;
    }

    public static boolean modifyImports(Project mainProject, String command, ProjectImport pImport) {
        boolean modified = false;
        switch (command) {
            case "add": {
                modified = mainProject.addImport(pImport);
                break;
            }
            case "del": {
                modified = mainProject.removeImport(pImport);
                break;
            }
        }
        return modified;
    }

    public static boolean addRuntimeAttributeToProject(Project project, Project fallbackForType) {
        boolean success = false;
        try {
            Utils.addRuntimeAttributeToProject(project, fallbackForType);
            success = true;
        }
        catch (CSTSemanticException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        catch (ValueDoesNotMatchTypeException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        catch (ModelQueryException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        return success;
    }

    public static FreezeBlock createFreezeBlock(IFreezable[] freezables, Project project, Project fallbackForType) {
        FreezeBlock result = null;
        try {
            result = Utils.createFreezeBlock(freezables, project, fallbackForType);
        }
        catch (CSTSemanticException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        catch (ValueDoesNotMatchTypeException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        catch (ModelQueryException e) {
            Bundle.getLogger(BasicIVMLModelOperations.class).exception((Exception)((Object)e));
        }
        return result;
    }

    public static void addFreezeBlock(List<IFreezable> freezables, Project project, Project fallbackForType) {
        IFreezable[] freezes;
        FreezeBlock block;
        if (freezables.size() > 0 && (block = BasicIVMLModelOperations.createFreezeBlock(freezes = freezables.toArray(new IFreezable[freezables.size()]), project, fallbackForType)) != null) {
            project.add((ContainableModelElement)block);
        }
    }
}

