/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.coordination.RepositoryHelper;
import eu.qualimaster.easy.extension.internal.Utils;
import eu.qualimaster.easy.extension.internal.VariableHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.producer.core.persistence.standard.StandaloneProjectDescriptor;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import org.apache.log4j.LogManager;
import org.eclipse.xtext.util.Arrays;

public class AlgorithmProfileHelper {
    public static final String PARAM_HDFS_DATAFILE = "hdfsDataFile";
    public static final String PARAM_DATAFILE = "dataFile";
    public static final String PARAM_REPLAYSPEED = "replaySpeed";
    public static final String SRC_NAME = "TestSource";
    public static final String FAM_NAME = "TestFamily";
    public static final String DATASRC_NAME = "TestSourceProfiling";
    private static final String[] PIPELINE_IMPORTS = new String[]{"Basics", "Pipelines", "FamiliesCfg", "DataManagementCfg"};
    private static final String[] PIPELINES_IMPORTS = new String[]{"Basics", "Pipelines"};
    private static final String[] INFRASTRUCTURE_IMPORTS = new String[]{"Infrastructure"};
    private static final String[] TOP_IMPORTS = new String[]{"HardwareCfg", "ReconfigurableHardwareCfg", "DataManagementCfg", "ObservablesCfg", "AdaptivityCfg", "AlgorithmsCfg", "FamiliesCfg"};
    private static final String PIP_VERSION = "0.0.1-SNAPSHOT";
    private static final String DATA_FILE = "profile.data";
    private static final String CTL_FILE = "profile.ctl";

    @QMInternal
    public static ProfileData createProfilePipeline(Configuration config, String pipelineName, String familyName, String algorithmName, IProjectDescriptor source) throws VilException {
        ProfileData result = null;
        if (config.getProject() == null) {
            throw new VilException("no project available - syntax/parsing error?", 30003);
        }
        try {
            Project qm = AlgorithmProfileHelper.createNewRoot(config, pipelineName, familyName, algorithmName);
            Configuration cfg = new Configuration(qm);
            TracerFactory.setInstance((TracerFactory)ConsoleTracerFactory.INSTANCE);
            StandaloneProjectDescriptor target = new StandaloneProjectDescriptor(source, source.getBase());
            Executor executor = new Executor(source.getMainVilScript()).addSource(source).addTarget((IProjectDescriptor)target).addConfiguration(cfg).addCustomArgument("pipelineName", (Object)pipelineName).addStartRuleName("pipeline");
            executor.execute();
            TracerFactory.setInstance(null);
            File base = source.getBase();
            Compound familyType = Utils.findCompound(qm, "Family");
            IDecisionVariable testFamily = Utils.findNamedVariable(config, (IDatatype)familyType, familyName);
            IDecisionVariable testAlgorithm = Configuration.dereference((IDecisionVariable)Utils.findAlgorithm(testFamily, algorithmName, true));
            String algArtifact = VariableHelper.getString(testAlgorithm, "artifact");
            AlgorithmProfileHelper.extractProfilingArtifact(algArtifact, algorithmName, base);
            File pipFile = new File(base, "pipelines/eu/qualimaster/" + pipelineName + "/target/" + pipelineName + "-0.0.1-SNAPSHOT-jar-with-dependencies.jar");
            File dataFile = AlgorithmProfileHelper.getDataFile(base);
            File controlFile = AlgorithmProfileHelper.getControlFile(base);
            result = new ProfileData(pipelineName, pipFile, dataFile, controlFile);
        }
        catch (ModelManagementException | CSTSemanticException | ModelQueryException | ValueDoesNotMatchTypeException e) {
            throw new VilException(e.getMessage(), 50502);
        }
        return result;
    }

    public static File getDataFile(File base) {
        return new File(base, DATA_FILE);
    }

    public static File getControlFile(File base) {
        return new File(base, CTL_FILE);
    }

    public static void extractProfilingArtifact(String artifactSpec, String name, File base) throws VilException {
        File dataArtifact;
        if (artifactSpec != null) {
            dataArtifact = RepositoryHelper.obtainArtifact((String)artifactSpec, (String)name, (String)"profiling", (String)".zip", (File)base);
            if (dataArtifact == null) {
                throw new VilException("artifact for spec " + artifactSpec + " not found", 50502);
            }
        } else {
            throw new VilException("no artifact spec given ", 50502);
        }
        AlgorithmProfileHelper.extractDataArtifact(dataArtifact, base);
    }

    private static void extractDataArtifact(File file, File base) {
        block6: {
            ZipInputStream zis = null;
            byte[] buf = new byte[2048];
            try {
                ZipEntry entry;
                zis = new ZipInputStream(new FileInputStream(file));
                do {
                    int count;
                    String name;
                    if ((entry = zis.getNextEntry()) == null || !(name = entry.getName()).equals(DATA_FILE) && !name.equals(CTL_FILE)) continue;
                    File outFile = new File(base, name);
                    FileOutputStream fos = new FileOutputStream(outFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, buf.length);
                    while ((count = zis.read(buf, 0, buf.length)) != -1) {
                        dest.write(buf, 0, count);
                    }
                    dest.flush();
                    dest.close();
                } while (entry != null);
                zis.close();
            }
            catch (IOException e) {
                LogManager.getLogger(AlgorithmProfileHelper.class).error((Object)("Extracting algorithm data artifact: " + e.getMessage()));
                if (zis == null) break block6;
                try {
                    zis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static Project createNewRoot(Configuration config, String pipelineName, String familyName, String algorithmName) throws ModelQueryException, ModelManagementException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Project qm;
        Project cfgProject = config.getProject();
        Project cfgInfra = ModelQuery.findProject((Project)cfgProject, (String)"Infrastructure");
        Compound familyType = Utils.findCompound(cfgProject, "Family");
        IDecisionVariable testFamily = Utils.findNamedVariable(config, (IDatatype)familyType, familyName);
        IDecisionVariable testAlgorithm = Utils.findAlgorithm(testFamily, algorithmName, true);
        Project pip = AlgorithmProfileHelper.createQmProject("ProfilingTestPipelineCfg", cfgProject);
        AlgorithmProfileHelper.addImports(cfgProject, PIPELINE_IMPORTS, pip, new Project[0]);
        Compound dataSourceType = Utils.findCompound(pip, "DataSource");
        Compound flowType = Utils.findCompound(pip, "Flow");
        Compound pipelineType = Utils.findCompound(pip, "Pipeline");
        Compound sourceType = Utils.findCompound(pip, "Source");
        Compound familyElementType = Utils.findCompound(pip, "FamilyElement");
        if (testFamily != null && testAlgorithm != null && dataSourceType != null && flowType != null) {
            IDecisionVariable famTuples = testFamily.getNestedElement("input");
            DecisionVariableDeclaration dataSourceVar = AlgorithmProfileHelper.createDecisionVariable(DATASRC_NAME, (IDatatype)dataSourceType, pip, "name", DATASRC_NAME, "input", famTuples.getValue().clone(), "artifact", "eu.qualimaster:genericSource:0.5.0-SNAPSHOT", "storageLocation", "null", "profilingSource", true, "strategy", "None", "parameters", AlgorithmProfileHelper.createDataSourceParameters(cfgProject), "sourceCls", "eu.qualimaster." + pipelineName + ".topology.imp.TestSourceProfilingProfiling");
            DecisionVariableDeclaration familyVar = AlgorithmProfileHelper.createDecisionVariable("prFamily0", (IDatatype)familyType, pip, "name", AlgorithmProfileHelper.getValue(testFamily, "name"), "input", AlgorithmProfileHelper.getValue(testFamily, "input"), "output", AlgorithmProfileHelper.getValue(testFamily, "output"), "parameters", AlgorithmProfileHelper.getValue(testFamily, "parameters"), "members", new Object[]{testAlgorithm.getValue()});
            DecisionVariableDeclaration familyEltVar = AlgorithmProfileHelper.createDecisionVariable(FAM_NAME, (IDatatype)familyElementType, pip, "name", FAM_NAME, "parallelism", 1, "family", familyVar);
            Object[] flowVars = new Object[famTuples.getNestedElementsCount()];
            int n = 0;
            while (n < flowVars.length) {
                flowVars[n] = AlgorithmProfileHelper.createDecisionVariable("prFlow" + n, (IDatatype)flowType, pip, "name", "f" + n, "destination", familyEltVar, "tupleType", AlgorithmProfileHelper.createRefToTuple(dataSourceVar, "input", n), "grouping", "shuffleGrouping");
                ++n;
            }
            DecisionVariableDeclaration sourceVar = AlgorithmProfileHelper.createDecisionVariable(SRC_NAME, (IDatatype)sourceType, pip, "name", SRC_NAME, "parallelism", 1, "output", flowVars, "source", dataSourceVar);
            DecisionVariableDeclaration pipVar = AlgorithmProfileHelper.createDecisionVariable("prPipeline0", (IDatatype)pipelineType, pip, "name", pipelineName, "artifact", "eu.qualimaster:" + pipelineName + ":0.0.1-SNAPSHOT", "sources", new Object[]{sourceVar}, "numworkers", 1);
            Utils.createFreezeBlock(pip);
            Project pipelines = AlgorithmProfileHelper.createPipelinesCfg(cfgProject, pip, pipVar);
            Project infra = AlgorithmProfileHelper.createInfrastructureCfg(config, pipelines, cfgInfra, pipVar);
            qm = AlgorithmProfileHelper.createQm(cfgProject, infra);
        } else {
            qm = cfgProject;
        }
        return qm;
    }

    private static Project createPipelinesCfg(Project cfgProject, Project pip, DecisionVariableDeclaration pipVar) throws ModelQueryException, ModelManagementException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Project pipelines = AlgorithmProfileHelper.createQmProject("PipelinesCfg", cfgProject);
        AlgorithmProfileHelper.addImports(cfgProject, PIPELINES_IMPORTS, pipelines, pip);
        DecisionVariableDeclaration pipelinesVar = AlgorithmProfileHelper.setPipelines(pipelines, "pipelines", pipVar);
        AlgorithmProfileHelper.createFreezeBlock(new IFreezable[]{pipelinesVar}, pipelines, pipelines);
        return pipelines;
    }

    private static Project createInfrastructureCfg(Configuration config, Project pipelines, Project cfgInfra, DecisionVariableDeclaration pipVar) throws ModelQueryException, ModelManagementException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Project cfgProject = config.getProject();
        Project infra = AlgorithmProfileHelper.createQmProject("InfrastructureCfg", cfgProject);
        AlgorithmProfileHelper.addImports(cfgProject, INFRASTRUCTURE_IMPORTS, infra, pipelines);
        List<IFreezable> freezes = AlgorithmProfileHelper.addTopLevelValues(config, cfgInfra, infra, "activePipelines");
        freezes.add((IFreezable)AlgorithmProfileHelper.setPipelines(infra, "activePipelines", pipVar));
        AlgorithmProfileHelper.createFreezeBlock(freezes, infra, infra);
        return infra;
    }

    private static Project createQm(Project cfgProject, Project infra) throws ModelQueryException, ModelManagementException, ValueDoesNotMatchTypeException, CSTSemanticException {
        Project qm = AlgorithmProfileHelper.createQmProject("QM", cfgProject);
        AlgorithmProfileHelper.addImports(cfgProject, TOP_IMPORTS, qm, infra);
        return qm;
    }

    private static ConstraintSyntaxTree createRefToTuple(DecisionVariableDeclaration var, String slotName, int index) throws CSTSemanticException, ValueDoesNotMatchTypeException {
        CompoundAccess slotAccess = new CompoundAccess((ConstraintSyntaxTree)new Variable((AbstractVariable)var), slotName);
        ConstantValue indexExpr = new ConstantValue(ValueFactory.createValue((IDatatype)IntegerType.TYPE, (Object[])new Object[]{OclKeyWords.toIvmlIndex((int)index)}));
        OCLFeatureCall result = new OCLFeatureCall((ConstraintSyntaxTree)slotAccess, "[]", new ConstraintSyntaxTree[]{indexExpr});
        result.inferDatatype();
        return result;
    }

    private static Object[] createDataSourceParameters(Project cfgProject) throws ModelQueryException, ValueDoesNotMatchTypeException {
        Compound stringParameterType = Utils.findCompound(cfgProject, "StringParameter");
        Compound intParameterType = Utils.findCompound(cfgProject, "IntegerParameter");
        Object[] result = new Object[]{ValueFactory.createValue((IDatatype)stringParameterType, (Object[])new Object[]{"name", PARAM_DATAFILE, "defaultValue", ""}), ValueFactory.createValue((IDatatype)stringParameterType, (Object[])new Object[]{"name", PARAM_HDFS_DATAFILE, "defaultValue", ""}), ValueFactory.createValue((IDatatype)intParameterType, (Object[])new Object[]{"name", PARAM_REPLAYSPEED})};
        return result;
    }

    private static FreezeBlock createFreezeBlock(IFreezable[] freezables, Project project, Project fallbackForType) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        FreezeBlock result = Utils.createFreezeBlock(freezables, project, fallbackForType);
        project.add((ContainableModelElement)result);
        return result;
    }

    public static FreezeBlock createFreezeBlock(List<IFreezable> freezables, Project project, Project fallbackForType) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        FreezeBlock result = Utils.createFreezeBlock(freezables, project, fallbackForType);
        project.add((ContainableModelElement)result);
        return result;
    }

    private static Project createQmProject(String name, Project typeFallback) throws CSTSemanticException, ValueDoesNotMatchTypeException, ModelQueryException {
        Project result = new Project(name);
        Utils.addRuntimeAttributeToProject(result, typeFallback);
        return result;
    }

    private static Value getValue(IDecisionVariable var, String slot) throws ModelQueryException {
        IDecisionVariable nested = var.getNestedElement(slot);
        if (nested == null) {
            throw new ModelQueryException("cannot find slot '" + slot + "' in '" + var.getDeclaration().getName() + "'", 10151);
        }
        Value val = nested.getValue();
        if (val != null) {
            val = val.clone();
        }
        return val;
    }

    private static List<IFreezable> addTopLevelValues(Configuration cfg, Project source, Project target, String ... exclude) throws CSTSemanticException {
        ArrayList<IFreezable> result = new ArrayList<IFreezable>();
        int e = 0;
        while (e < source.getElementCount()) {
            IDecisionVariable decVar;
            Value value;
            DecisionVariableDeclaration decl;
            ContainableModelElement elt = source.getElement(e);
            if (elt instanceof DecisionVariableDeclaration && !Arrays.contains((Object[])exclude, (Object)(decl = (DecisionVariableDeclaration)elt).getName()) && (value = (decVar = cfg.getDecision((AbstractVariable)decl)).getValue()) != null && !ConstraintType.isConstraint((IDatatype)decVar.getDeclaration().getType())) {
                OCLFeatureCall cst = new OCLFeatureCall((ConstraintSyntaxTree)new Variable((AbstractVariable)decl), "=", new ConstraintSyntaxTree[]{new ConstantValue(decVar.getValue().clone())});
                cst.inferDatatype();
                Constraint constraint = new Constraint((ConstraintSyntaxTree)cst, (IModelElement)target);
                target.addConstraint(constraint);
                result.add((IFreezable)decl);
            }
            ++e;
        }
        return result;
    }

    private static void addImports(Project source, String[] imports, Project target, Project ... furtherImports) throws ModelManagementException {
        String[] stringArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Project prj = ModelQuery.findProject((Project)source, (String)s);
            if (prj != null) {
                ProjectImport imp = new ProjectImport(s);
                imp.setResolved(prj);
                target.addImport(imp);
            }
            ++n2;
        }
        int f = 0;
        while (f < furtherImports.length) {
            Project prj = furtherImports[f];
            ProjectImport imp = new ProjectImport(prj.getName());
            imp.setResolved(prj);
            target.addImport(imp);
            ++f;
        }
    }

    private static DecisionVariableDeclaration createDecisionVariable(String name, IDatatype type, Project target, Object ... values) throws CSTSemanticException, ValueDoesNotMatchTypeException {
        DecisionVariableDeclaration result = new DecisionVariableDeclaration(name, type, (IModelElement)target);
        result.setValue((ConstraintSyntaxTree)new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])values)));
        target.add((ContainableModelElement)result);
        return result;
    }

    private static DecisionVariableDeclaration setPipelines(Project prj, String varName, DecisionVariableDeclaration pipeline) throws ModelQueryException, CSTSemanticException, ValueDoesNotMatchTypeException {
        DecisionVariableDeclaration pipelinesVar = (DecisionVariableDeclaration)ModelQuery.findVariable((IResolutionScope)prj, (String)varName, DecisionVariableDeclaration.class);
        if (pipelinesVar == null || !(pipelinesVar.getType() instanceof Container)) {
            throw new ModelQueryException("pipelines variable '" + varName + "' not found", 10151);
        }
        Container cType = (Container)pipelinesVar.getType();
        OCLFeatureCall cst = new OCLFeatureCall((ConstraintSyntaxTree)new Variable((AbstractVariable)pipelinesVar), "=", new ConstraintSyntaxTree[]{new ConstantValue(ValueFactory.createValue((IDatatype)cType, (Object[])new Object[]{pipeline}))});
        cst.inferDatatype();
        Constraint constraint = new Constraint((ConstraintSyntaxTree)cst, (IModelElement)prj);
        prj.addConstraint(constraint);
        return pipelinesVar;
    }

    public static class ProfileData {
        private String pipelineName;
        private File pipeline;
        private File dataFile;
        private File controlFile;

        public ProfileData(String pipelineName, File pipeline, File dataFile, File controlFile) {
            this.pipelineName = pipelineName;
            this.pipeline = pipeline;
            this.dataFile = dataFile;
            this.controlFile = controlFile;
        }

        public String getPipelineName() {
            return this.pipelineName;
        }

        public File getPipeline() {
            return this.pipeline;
        }

        public File getDataFile() {
            return this.dataFile;
        }

        public File getControlFile() {
            return this.controlFile;
        }
    }
}

