/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.modelop;

import eu.qualimaster.easy.extension.ProjectFreezeModifier;
import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.modelop.QmPrunedConfigSaver;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.RtVilModel;
import net.ssehub.easy.producer.core.persistence.IVMLFileWriter;
import net.ssehub.easy.producer.core.persistence.standard.StandaloneProjectDescriptor;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.filter.DeclarationFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.rewrite.ProjectCopyVisitor;
import net.ssehub.easy.varModel.model.rewrite.ProjectRewriteVisitor;
import net.ssehub.easy.varModel.model.rewrite.UncopiedElement;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenCompoundConstraintsOmitter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintVarFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenConstraintsFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.FrozenTypeDefResolver;
import net.ssehub.easy.varModel.model.rewrite.modifier.IModelElementFilter;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectModifier;
import net.ssehub.easy.varModel.model.rewrite.modifier.ModelElementFilter;
import org.apache.commons.io.FileUtils;

public class ModelModifier {
    private static final boolean FREEZE = false;
    private static final boolean SAVE_VALUES = true;
    private static final boolean WRITE_MODIFIED_CONFIG = true;
    private static final boolean PRUNE_CONFIG = true;
    private static final String COPIED_MODELS_LOCATION = "QM-Model";
    private File targetFolder;
    private IProjectDescriptor source;
    private File orgModelsFolder;
    private File tempModelsFolder;
    private final Project toplevelProject;
    private final File baseLocation;
    private final QMPlatformProvider qmApp;

    public ModelModifier(File targetFolder, Project toplevelProject, File baseLocation, QMPlatformProvider qmApp) {
        this.targetFolder = targetFolder;
        this.toplevelProject = toplevelProject;
        this.baseLocation = baseLocation;
        this.qmApp = qmApp;
        this.orgModelsFolder = null;
        this.tempModelsFolder = null;
        this.source = null;
    }

    public Executor createExecutor() {
        Executor executor = null;
        this.prepareConfig(this.targetFolder);
        this.tempModelsFolder = new File(this.targetFolder, COPIED_MODELS_LOCATION);
        ModelInfo oldProjectInfo = VarModel.INSTANCE.availableModels().getModelInfo((IModel)this.toplevelProject);
        this.orgModelsFolder = new File(oldProjectInfo.getLocation().getPath()).getParentFile();
        this.copyBuildModel();
        BuildModel.INSTANCE.locations().getLocation(0);
        this.addOrRemoveLocation(this.orgModelsFolder, false);
        this.addOrRemoveLocation(this.tempModelsFolder, true);
        Project project = (Project)this.load((ModelManagement)VarModel.INSTANCE, ".ivml");
        if (project != null) {
            Configuration config = new Configuration(project, true);
            Script startScript = (Script)this.load((ModelManagement)BuildModel.INSTANCE, "_0.vil");
            if (config != null && startScript != null) {
                executor = new Executor(startScript);
                executor.addConfiguration(config);
                try {
                    this.source = new StandaloneProjectDescriptor(startScript, this.tempModelsFolder);
                    executor.addSource(this.source);
                }
                catch (ModelManagementException e) {
                    executor = null;
                    Bundle.getLogger(ModelModifier.class).exception((Exception)((Object)e));
                }
            }
        }
        if (executor == null) {
            this.clear();
        }
        return executor;
    }

    public IProjectDescriptor getSourceDescriptor() {
        return this.source;
    }

    private <M extends IModel> M load(ModelManagement<M> management, String fileEnding) {
        IModel model = null;
        File file = new File(this.tempModelsFolder, "QM" + fileEnding);
        URI vilURI = file.toURI();
        ModelInfo info = management.availableModels().getModelInfo("QM", new Version(new int[]{0}), vilURI);
        if (info != null) {
            try {
                model = management.load(info);
            }
            catch (ModelManagementException e) {
                Bundle.getLogger(ModelModifier.class).exception((Exception)((Object)e));
            }
        }
        return (M)model;
    }

    public void clear() {
        this.addOrRemoveLocation(this.tempModelsFolder, false);
        this.addOrRemoveLocation(this.orgModelsFolder, true);
    }

    private void addOrRemoveLocation(File folder, boolean add) {
        this.addOrRemoveLocation((ModelManagement<? extends IModel>)VarModel.INSTANCE, folder, add);
        this.addOrRemoveLocation((ModelManagement<? extends IModel>)BuildModel.INSTANCE, folder, add);
        this.addOrRemoveLocation((ModelManagement<? extends IModel>)TemplateModel.INSTANCE, folder, add);
        this.addOrRemoveLocation((ModelManagement<? extends IModel>)RtVilModel.INSTANCE, folder, add);
    }

    private void addOrRemoveLocation(ModelManagement<? extends IModel> modelManagement, File folder, boolean add) {
        try {
            if (add) {
                modelManagement.locations().addLocation(folder, ProgressObserver.NO_OBSERVER);
            } else {
                modelManagement.locations().removeLocation(folder, ProgressObserver.NO_OBSERVER);
            }
        }
        catch (ModelManagementException e) {
            Bundle.getLogger(ModelModifier.class).exception((Exception)((Object)e));
        }
    }

    private File copyBuildModel() {
        File srcFolder = new File(this.baseLocation, "EASy");
        File vilFolder = new File(this.targetFolder, COPIED_MODELS_LOCATION);
        vilFolder.mkdirs();
        try {
            FileUtils.copyDirectory((File)srcFolder, (File)vilFolder, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    return pathname.isDirectory() || fileName.endsWith("vil") || fileName.endsWith("vtl") || fileName.endsWith("rtvtl");
                }
            });
        }
        catch (IOException e) {
            Bundle.getLogger(ModelModifier.class).exception((Exception)e);
        }
        return vilFolder;
    }

    private Configuration prepareConfig(File targetLocation) {
        Project baseProject;
        block6: {
            baseProject = this.toplevelProject;
            ProjectCopyVisitor copier = new ProjectCopyVisitor(baseProject, FilterType.ALL);
            baseProject.accept((IModelVisitor)copier);
            baseProject = copier.getCopiedProject();
            List uncopiedElements = copier.getUncopiedElements();
            if (!uncopiedElements.isEmpty()) {
                StringBuffer errMsg = new StringBuffer(ProjectCopyVisitor.class.getSimpleName());
                errMsg.append(" could not copy ");
                errMsg.append(uncopiedElements.size());
                errMsg.append("elements of project \"");
                errMsg.append(this.toplevelProject.getName());
                errMsg.append("\". These are:");
                int i = 0;
                int end = uncopiedElements.size();
                while (i < end) {
                    errMsg.append("\n * ");
                    errMsg.append(((UncopiedElement)uncopiedElements.get(i)).getDescription());
                    ++i;
                }
                Bundle.getLogger(ModelModifier.class).warn(errMsg.toString());
            }
            this.saveValues(baseProject, new HashSet<Project>());
            ProjectRewriteVisitor rewriter = new ProjectRewriteVisitor(baseProject, FilterType.ALL);
            Configuration config = new Configuration(baseProject, true);
            rewriter.addModelCopyModifier((IModelElementFilter)new ModelElementFilter(Comment.class));
            rewriter.addModelCopyModifier((IModelElementFilter)new FrozenConstraintsFilter(config));
            rewriter.addModelCopyModifier((IModelElementFilter)new FrozenTypeDefResolver(config));
            rewriter.addModelCopyModifier((IModelElementFilter)new FrozenConstraintVarFilter(config));
            rewriter.addModelCopyModifier((IModelElementFilter)new FrozenCompoundConstraintsOmitter(config));
            baseProject.accept((IModelVisitor)rewriter);
            try {
                File modelFolder = new File(targetLocation, COPIED_MODELS_LOCATION);
                if (!modelFolder.exists()) {
                    modelFolder.mkdirs();
                }
                IVMLFileWriter writer = new IVMLFileWriter(modelFolder);
                writer.forceComponundTypes(true);
                writer.setFormatInitializer(true);
                writer.save(baseProject);
            }
            catch (IOException e) {
                if (this.qmApp == null) break block6;
                this.qmApp.showExceptionDialog("Model could not be saved", e);
            }
        }
        Configuration config = new Configuration(baseProject, true);
        if (this.qmApp != null) {
            this.qmApp.reason(config);
        }
        return config;
    }

    private void saveValues(Project project, Set<Project> done) {
        if (!done.contains(project)) {
            done.add(project);
            if (project.getName().endsWith("Cfg")) {
                Bundle.getLogger(ModelModifier.class).debug((Object)"Saving ", (Object)project.getName());
                try {
                    Configuration tmpConfig = new Configuration(project, true);
                    new QmPrunedConfigSaver(tmpConfig);
                }
                catch (ConfigurationException e1) {
                    Bundle.getLogger(ModelModifier.class).exception((Exception)((Object)e1));
                }
            }
            int i = 0;
            int end = project.getImportsCount();
            while (i < end) {
                this.saveValues((Project)project.getImport(i).getResolved(), done);
                ++i;
            }
        }
    }

    private void freezeProject(Project baseProject) {
        DeclarationFinder finder = new DeclarationFinder(baseProject, FilterType.ALL, null);
        ArrayList<DecisionVariableDeclaration> allDeclarations = new ArrayList<DecisionVariableDeclaration>();
        List tmpList = finder.getVariableDeclarations(DeclarationFinder.VisibilityType.ALL);
        int i = 0;
        int end = tmpList.size();
        while (i < end) {
            AbstractVariable declaration = (AbstractVariable)tmpList.get(i);
            if (!(!(declaration instanceof DecisionVariableDeclaration) || declaration.getNameSpace().equals("ObservablesCfg") && declaration.getName().equals("qualityParameters"))) {
                allDeclarations.add((DecisionVariableDeclaration)declaration);
            }
            ++i;
        }
        ProjectRewriteVisitor rewriter = new ProjectRewriteVisitor(baseProject, FilterType.ALL);
        ProjectFreezeModifier freezer = new ProjectFreezeModifier(baseProject, allDeclarations);
        rewriter.addProjectModifier((IProjectModifier)freezer);
        baseProject.accept((IModelVisitor)rewriter);
    }

    public static interface QMPlatformProvider {
        public void reason(Configuration var1);

        public void showExceptionDialog(String var1, Exception var2);
    }
}

