/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.easy.extension.internal.AlgorithmPredictionResult;
import eu.qualimaster.easy.extension.internal.AlgorithmPredictor;
import eu.qualimaster.easy.extension.internal.PredictionUtils;
import eu.qualimaster.easy.extension.internal.Registration;
import eu.qualimaster.observables.IObservable;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.ParameterMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@Instantiator(value="algorithmPrediction")
public class AlgorithmPrediction
implements IVilType {
    private static final AlgorithmPredictor IMPL;

    static {
        AlgorithmPredictor impl = null;
        try {
            Class<?> cls = Class.forName("eu.qualimaster.easy.extension.internal.AlgorithmPredictorImpl");
            impl = (AlgorithmPredictor)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            AlgorithmPrediction.error(e);
        }
        if (impl == null) {
            impl = new AlgorithmPredictor();
        }
        IMPL = impl;
    }

    static AlgorithmPredictor getInstance() {
        return IMPL;
    }

    private static void error(Throwable exc) {
        Registration.error("Error loading AlgorithmPredictorImpl - falling back to default: " + exc.getMessage());
    }

    public static Double algorithmPrediction(String pipeline, String pipelineElement, String algorithm, IObservable observable) {
        return IMPL.algorithmPrediction(pipeline, pipelineElement, algorithm, observable);
    }

    public static Double algorithmPrediction(String pipeline, String pipelineElement, String algorithm, IObservable observable, @ParameterMeta(generics={Object.class, Serializable.class}) Map<Object, Serializable> targetValues) {
        return IMPL.algorithmPrediction(pipeline, pipelineElement, algorithm, observable, PredictionUtils.toMappedMap(targetValues));
    }

    @ReturnGenerics(value={String.class, Map.class, IObservable.class, Double.class})
    public static Map<String, Map<IObservable, Double>> algorithmPrediction(String pipeline, String pipelineElement, @ParameterMeta(generics={String.class}) Set<String> algorithms, @ParameterMeta(generics={IObservable.class}) Set<IObservable> observables) {
        return AlgorithmPrediction.algorithmPrediction(pipeline, pipelineElement, algorithms, observables, null);
    }

    @ReturnGenerics(value={String.class, Map.class, IObservable.class, Double.class})
    public static Map<String, Map<IObservable, Double>> algorithmPrediction(String pipeline, String pipelineElement, @ParameterMeta(generics={String.class}) Set<String> algorithms, @ParameterMeta(generics={IObservable.class}) Set<IObservable> observables, @ParameterMeta(generics={Object.class, Serializable.class}) Map<Object, Serializable> targetValues) {
        return PredictionUtils.transferMap(IMPL.algorithmPrediction(pipeline, pipelineElement, algorithms.toMappedSet(), observables.toMappedSet(), PredictionUtils.toMappedMap(targetValues)), String.class, IObservable.class, Double.class);
    }

    @QMInternal
    static AlgorithmPredictionResult algorithmPredictionEx(String pipeline, String pipelineElement, @ParameterMeta(generics={String.class}) Set<String> algorithms, @ParameterMeta(generics={IObservable.class}) Set<IObservable> observables) {
        return IMPL.algorithmPredictionEx(pipeline, pipelineElement, algorithms.toMappedSet(), observables.toMappedSet());
    }
}

