/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.adaptation.AdaptationManager;
import eu.qualimaster.coordination.INameMapping;
import eu.qualimaster.coordination.RepositoryConnector;
import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.internal.NameMappingHelper;
import eu.qualimaster.easy.extension.internal.Utils;
import eu.qualimaster.monitoring.MonitoringManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;

public class PipelineContentsContainer {
    private static Set<IDecisionVariable> allMappedVariables = new HashSet<IDecisionVariable>();
    private String pipelineName;
    private List<IDecisionVariable> sources = new ArrayList<IDecisionVariable>();
    private List<IDecisionVariable> familyElements = new ArrayList<IDecisionVariable>();
    private List<IDecisionVariable> dataManagementElements = new ArrayList<IDecisionVariable>();
    private List<IDecisionVariable> sinks = new ArrayList<IDecisionVariable>();
    private List<IDecisionVariable> replaySinks = new ArrayList<IDecisionVariable>();
    private Map<String, IDecisionVariable> algorithmMapping = new HashMap<String, IDecisionVariable>();
    private Map<String, IDecisionVariable> sourceMapping = new HashMap<String, IDecisionVariable>();
    private Map<String, IDecisionVariable> sinkMapping = new HashMap<String, IDecisionVariable>();
    private RepositoryConnector.Models models = null;

    public PipelineContentsContainer() {
        this("<Unknown Pipeline>");
    }

    public PipelineContentsContainer(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    void addSource(IDecisionVariable source) {
        this.sources.add(source);
    }

    void addSink(IDecisionVariable sink) {
        this.sinks.add(sink);
    }

    void addReplaySink(IDecisionVariable replaySink) {
        this.replaySinks.add(replaySink);
    }

    void addFamilyElement(IDecisionVariable familyElement) {
        this.familyElements.add(familyElement);
    }

    void addDataManagementElement(IDecisionVariable dataManagement) {
        this.dataManagementElements.add(dataManagement);
    }

    public static boolean isMappingVariable(IDecisionVariable var) {
        return allMappedVariables.contains(var);
    }

    private void gatherAlgorithms() {
        int i = 0;
        int end = this.familyElements.size();
        while (i < end) {
            IDecisionVariable familyElement = this.familyElements.get(i);
            List<IDecisionVariable> runtimeAglrotihms = this.getMappedMembers(familyElement);
            IDecisionVariable familySlot = familyElement.getNestedElement("family");
            if (familySlot != null) {
                Configuration config = familySlot.getConfiguration();
                ReferenceValue familyRef = (ReferenceValue)familySlot.getValue();
                IDecisionVariable orgFamily = Utils.extractVariable(familyRef, config);
                ContainerValue referencedOrgAlgos = null;
                if (orgFamily != null) {
                    referencedOrgAlgos = (ContainerValue)orgFamily.getNestedElement("members").getValue();
                }
                this.collectAlgorithmFromFamily(config, referencedOrgAlgos, runtimeAglrotihms);
            }
            ++i;
        }
    }

    private void collectAlgorithmFromFamily(Configuration config, ContainerValue referencedOrgAlgos, List<IDecisionVariable> runtimeAlgorithms) {
        int lastIndex = referencedOrgAlgos != null ? referencedOrgAlgos.getElementSize() : 0;
        INameMapping nMapping = this.getNameMapping();
        int i = 0;
        while (i < lastIndex) {
            ReferenceValue orgRef = (ReferenceValue)referencedOrgAlgos.getElement(i);
            IDecisionVariable orgAlgorithm = Utils.extractVariable(orgRef, config);
            String orgName = orgAlgorithm.getNestedElement("name").getValue().getValue().toString();
            if (runtimeAlgorithms != null) {
                IDecisionVariable mappedAlgorithm = null;
                int j = 0;
                while (j < runtimeAlgorithms.size() && mappedAlgorithm == null) {
                    IDecisionVariable tmpAlgo = runtimeAlgorithms.get(j);
                    if (tmpAlgo.getNestedElement("name").getValue().getValue().equals(orgName)) {
                        mappedAlgorithm = tmpAlgo;
                        runtimeAlgorithms.remove(j);
                    }
                    ++j;
                }
                if (mappedAlgorithm != null) {
                    this.algorithmMapping.put(orgName, mappedAlgorithm);
                    String impl = NameMappingHelper.getAlgorithmImplName(nMapping, orgName);
                    if (impl != null && !impl.equals(orgName)) {
                        this.algorithmMapping.put(impl, mappedAlgorithm);
                    }
                    allMappedVariables.add(mappedAlgorithm);
                }
            }
            ++i;
        }
    }

    private List<IDecisionVariable> getMappedMembers(IDecisionVariable originalVariable) {
        List mappedVariable = null;
        RepositoryConnector.Models models = this.getModels();
        if (models != null) {
            mappedVariable = models.getVariableMapping().getMappedVariables(originalVariable);
        }
        return mappedVariable;
    }

    private void gatherMappedNonFamilyElement(List<IDecisionVariable> orignalVariables, String slotName, Map<String, IDecisionVariable> mapping) {
        INameMapping nMapping = this.getNameMapping();
        int i = 0;
        int end = orignalVariables.size();
        while (i < end) {
            IDecisionVariable orignalVariable = orignalVariables.get(i);
            List<IDecisionVariable> mappedRuntimeVariables = this.getMappedMembers(orignalVariable);
            IDecisionVariable pointerVariable = orignalVariable.getNestedElement(slotName);
            if (pointerVariable != null && mappedRuntimeVariables != null && !mappedRuntimeVariables.isEmpty()) {
                Configuration config = orignalVariable.getConfiguration();
                ReferenceValue referencedValue = (ReferenceValue)pointerVariable.getValue();
                IDecisionVariable orgReferencedVariable = Utils.extractVariable(referencedValue, config);
                if (orgReferencedVariable != null) {
                    String orgName = orgReferencedVariable.getNestedElement("name").getValue().getValue().toString();
                    IDecisionVariable var = mappedRuntimeVariables.get(0);
                    mapping.put(orgName, var);
                    String impl = NameMappingHelper.getPipelineElementImplName(nMapping, orgName);
                    if (impl != null && !impl.equals(orgName)) {
                        mapping.put(impl, var);
                    }
                    this.algorithmMapping.put(orgName, null);
                    impl = NameMappingHelper.getAlgorithmImplName(nMapping, orgName);
                    if (impl != null && !impl.equals(orgName)) {
                        this.algorithmMapping.put(impl, null);
                    }
                    allMappedVariables.add(mappedRuntimeVariables.get(0));
                }
            }
            ++i;
        }
    }

    private RepositoryConnector.Models getModels() {
        if (this.models == null) {
            RepositoryConnector.IPhase phase = RepositoryConnector.getPhase((Thread)Thread.currentThread());
            if (phase != null) {
                this.models = RepositoryConnector.getModels((RepositoryConnector.IPhase)phase);
            }
            if (this.models == null) {
                RepositoryConnector.Models tmpModels = RepositoryConnector.getModels((RepositoryConnector.IPhase)RepositoryConnector.Phase.ADAPTATION);
                if (tmpModels != null && tmpModels.getVariableMapping() != null) {
                    this.models = tmpModels;
                }
                if (this.models == null && (tmpModels = RepositoryConnector.getModels((RepositoryConnector.IPhase)RepositoryConnector.Phase.MONITORING)) != null && tmpModels.getVariableMapping() != null) {
                    this.models = tmpModels;
                }
            }
        }
        return this.models;
    }

    private INameMapping getNameMapping() {
        INameMapping result = null;
        RepositoryConnector.Models models = this.getModels();
        if (models != null) {
            if (RepositoryConnector.Phase.ADAPTATION == models.getPhase()) {
                AdaptationManager.getNameMapping((String)this.pipelineName);
            } else if (RepositoryConnector.Phase.MONITORING == models.getPhase()) {
                MonitoringManager.getNameMapping((String)this.pipelineName);
            }
        }
        return result;
    }

    void init() {
        this.gatherAlgorithms();
        this.gatherMappedNonFamilyElement(this.sources, "source", this.sourceMapping);
        this.gatherMappedNonFamilyElement(this.sinks, "sink", this.sinkMapping);
        this.gatherMappedNonFamilyElement(this.replaySinks, "sink", this.sinkMapping);
    }

    public IDecisionVariable getMappedInstance(MappedInstanceType type, String orgName) {
        IDecisionVariable result = null;
        if (type != null) {
            switch (type) {
                case SOURCE: {
                    result = this.sourceMapping.get(orgName);
                    break;
                }
                case ALGORITHM: {
                    result = this.algorithmMapping.get(orgName);
                    break;
                }
                case SINK: {
                    result = this.sinkMapping.get(orgName);
                    break;
                }
                default: {
                    Bundle.getLogger(PipelineContentsContainer.class).error("Undefined type passed: " + type.name());
                }
            }
        }
        return result;
    }

    public boolean hasMapping(MappedInstanceType type, String orgName) {
        boolean result = false;
        if (type != null) {
            switch (type) {
                case SOURCE: {
                    result = this.sourceMapping.containsKey(orgName);
                    break;
                }
                case ALGORITHM: {
                    result = this.algorithmMapping.containsKey(orgName);
                    break;
                }
                case SINK: {
                    result = this.sinkMapping.containsKey(orgName);
                    break;
                }
                default: {
                    Bundle.getLogger(PipelineContentsContainer.class).error("Undefined type passed: " + type.name());
                }
            }
        }
        return result;
    }

    public List<IDecisionVariable> getSources() {
        return Collections.unmodifiableList(new ArrayList<IDecisionVariable>(this.sources));
    }

    public List<IDecisionVariable> getSinks() {
        return Collections.unmodifiableList(new ArrayList<IDecisionVariable>(this.sinks));
    }

    public List<IDecisionVariable> getReplaySinks() {
        return Collections.unmodifiableList(new ArrayList<IDecisionVariable>(this.replaySinks));
    }

    public List<IDecisionVariable> getFamilyElements() {
        return Collections.unmodifiableList(new ArrayList<IDecisionVariable>(this.familyElements));
    }

    public List<IDecisionVariable> getDataManagementElements() {
        return Collections.unmodifiableList(new ArrayList<IDecisionVariable>(this.dataManagementElements));
    }

    public String toString() {
        return "Sources: " + String.valueOf(this.sources) + "\nFamilyElements: " + String.valueOf(this.familyElements) + "\nDataManagementElement: " + String.valueOf(this.dataManagementElements) + "\nReplaySinks: " + String.valueOf(this.replaySinks) + "\nSinks: " + String.valueOf(this.sinks);
    }

    public static enum MappedInstanceType {
        SOURCE,
        ALGORITHM,
        SINK;

    }
}

