/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension;

import eu.qualimaster.easy.extension.internal.Bundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.rewrite.RewriteContext;
import net.ssehub.easy.varModel.model.rewrite.modifier.IProjectModifier;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class ProjectFreezeModifier
implements IProjectModifier {
    private static final int RUNTIME_LEVEL = 2;
    private static final Set<String> BLACKLIST = new HashSet<String>();
    private List<DecisionVariableDeclaration> declarations;
    private Map<String, Project> usedProjects;
    private Configuration config;

    static {
        BLACKLIST.add("qualityParameters");
    }

    public ProjectFreezeModifier(Project mainProject, List<DecisionVariableDeclaration> declarations) {
        this.declarations = declarations;
        this.usedProjects = new HashMap<String, Project>();
        this.config = new Configuration(mainProject, true);
    }

    public void modifyProject(Project project, RewriteContext context) {
        String pName = project.getName();
        if (pName.endsWith("Cfg") && !pName.equals("AdaptivityCfg")) {
            String projectNS = pName.substring(0, pName.length() - "Cfg".length());
            ArrayList<DecisionVariableDeclaration> toFreeze = new ArrayList<DecisionVariableDeclaration>();
            int i = 0;
            int end = this.declarations.size();
            while (i < end) {
                DecisionVariableDeclaration decl = this.declarations.get(i);
                if (!(!decl.getNameSpace().equals(projectNS) && !decl.getNameSpace().equals(pName) || ConstraintType.TYPE.isAssignableFrom(decl.getType()) || this.isRuntimeVariable(this.config, decl) || BLACKLIST.contains(decl.getName()))) {
                    toFreeze.add(decl);
                }
                ++i;
            }
            IFreezable[] freezes = toFreeze.toArray(new IFreezable[0]);
            DecisionVariableDeclaration itr = null;
            OCLFeatureCall selector = null;
            Attribute annotation = this.getBindingTimeAnnotation(project);
            if (annotation != null && annotation.getType() instanceof OrderedEnum) {
                OrderedEnum btType = (OrderedEnum)annotation.getType();
                EnumLiteral lit = null;
                ConstantValue cVal = null;
                int i2 = 0;
                int end2 = btType.getLiteralCount();
                while (i2 < end2 && lit == null) {
                    if (btType.getLiteral(i2).getName().equals("runtimeMon")) {
                        lit = btType.getLiteral(i2);
                        try {
                            cVal = new ConstantValue(ValueFactory.createValue((IDatatype)btType, (Object[])new Object[]{lit}));
                        }
                        catch (ValueDoesNotMatchTypeException e) {
                            Bundle.getLogger(ProjectFreezeModifier.class).exception((Exception)((Object)e));
                        }
                    }
                    ++i2;
                }
                if (cVal != null) {
                    FreezeVariableType freezeType = new FreezeVariableType(freezes, (IModelElement)project);
                    itr = new DecisionVariableDeclaration("var", (IDatatype)freezeType, (IModelElement)project);
                    AttributeVariable attrExpr = new AttributeVariable((ConstraintSyntaxTree)new Variable((AbstractVariable)itr), annotation);
                    selector = new OCLFeatureCall((ConstraintSyntaxTree)attrExpr, ">=", new ConstraintSyntaxTree[]{cVal});
                    try {
                        selector.inferDatatype();
                    }
                    catch (CSTSemanticException e) {
                        itr = null;
                        selector = null;
                    }
                }
            }
            FreezeBlock block = new FreezeBlock(freezes, itr, selector, (IModelElement)project);
            project.add((ContainableModelElement)block);
        }
    }

    private boolean isRuntimeVariable(Configuration config, DecisionVariableDeclaration declaration) {
        boolean isRuntimeVar = false;
        if (config != null) {
            IDecisionVariable var = config.getDecision((AbstractVariable)declaration);
            IDecisionVariable annotationVar = null;
            int i = 0;
            int end = var.getAttributesCount();
            while (i < end && annotationVar == null) {
                IDecisionVariable tmpVar = var.getAttribute(i);
                if ("bindingTime".equals(tmpVar.getDeclaration().getName())) {
                    annotationVar = tmpVar;
                }
                ++i;
            }
            if (annotationVar != null && annotationVar.getValue() != null && annotationVar.getValue() instanceof EnumValue) {
                EnumLiteral selectedLiteral = ((EnumValue)annotationVar.getValue()).getValue();
                isRuntimeVar = selectedLiteral.getOrdinal() >= 2;
            }
        }
        return isRuntimeVar;
    }

    private Attribute getBindingTimeAnnotation(Project project) {
        Attribute btAnnotation = project.getAttribute("bindingTime");
        if (btAnnotation == null && project.getName().endsWith("Cfg")) {
            int end;
            int i;
            String baseName = project.getName().substring(0, project.getName().length() - "Cfg".length());
            Project baseProject = this.usedProjects.get(baseName);
            if (baseProject == null) {
                i = 0;
                end = project.getImportsCount();
                while (i < end && baseProject == null) {
                    Project importedProject = (Project)project.getImport(i).getResolved();
                    String importedName = importedProject.getName();
                    if (!this.usedProjects.containsKey(importedName)) {
                        this.usedProjects.put(importedName, importedProject);
                    }
                    if (baseName.equals(importedName)) {
                        baseProject = importedProject;
                    }
                    ++i;
                }
            }
            if (baseProject != null) {
                i = 0;
                end = baseProject.getAttributesCount();
                while (i < end && btAnnotation == null) {
                    btAnnotation = baseProject.getAttribute("bindingTime");
                    ++i;
                }
            }
        }
        return btAnnotation;
    }
}

