/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.coordination.RuntimeVariableMapping;
import eu.qualimaster.easy.extension.internal.Utils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cstEvaluation.VariableValueCopier;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class ConfigurationInitializer {
    @QMInternal
    public static void initializeConfiguration(Configuration config, String newVariablePrefix, RuntimeVariableMapping mapping) throws VilException {
        ConfigurationInitializer.initializeConfiguration(config, newVariablePrefix, true, mapping);
    }

    @QMInternal
    public static void initializeConfiguration(Configuration config, String newVariablePrefix, boolean initActual, RuntimeVariableMapping mapping) throws VilException {
        Project project = config.getProject();
        if (project == null) {
            throw new VilException("no project available - syntax/parsing error?", 30003);
        }
        try {
            Enum bindingTime = (Enum)ModelQuery.findType((IResolutionScope)project, (String)"BindingTime", Enum.class);
            Attribute annotation = (Attribute)ModelQuery.findElementByName((IResolutionScope)project, (String)"bindingTime", Attribute.class);
            VariableValueCopier.EnumAttributeFreezeProvider freezeProvider = new VariableValueCopier.EnumAttributeFreezeProvider("b", annotation, ">=", bindingTime.getLiteral(1));
            Compound sourceType = Utils.findCompound(project, "Source");
            VariableValueCopier.CopySpec specSource = new VariableValueCopier.CopySpec(sourceType, "source", (VariableValueCopier.IFreezeProvider)freezeProvider, ConfigurationInitializer.select(initActual, "available", "actual"));
            Compound familyElementType = Utils.findCompound(project, "FamilyElement");
            VariableValueCopier.CopySpec specFamily = new VariableValueCopier.CopySpec(familyElementType, "family.members", (VariableValueCopier.IFreezeProvider)freezeProvider, ConfigurationInitializer.select(initActual, "available", "actual"));
            Compound sinkType = Utils.findCompound(project, "Sink");
            VariableValueCopier.CopySpec specSink = new VariableValueCopier.CopySpec(sinkType, "sink", (VariableValueCopier.IFreezeProvider)freezeProvider, ConfigurationInitializer.select(initActual, "available", "actual"));
            Compound replaySinkType = Utils.findCompound(project, "ReplaySink");
            VariableValueCopier.CopySpec specReplaySink = new VariableValueCopier.CopySpec(replaySinkType, "sink", (VariableValueCopier.IFreezeProvider)freezeProvider, ConfigurationInitializer.select(initActual, "available", "actual"));
            VariableValueCopier copier = new VariableValueCopier(newVariablePrefix, new VariableValueCopier.CopySpec[]{specSource, specFamily, specSink, specReplaySink});
            copier.process(config);
        }
        catch (ConfigurationException e1) {
            throw new VilException((Throwable)e1, 50502);
        }
        catch (ValueDoesNotMatchTypeException e2) {
            throw new VilException((Throwable)e2, 50502);
        }
        catch (ModelQueryException e3) {
            throw new VilException((Throwable)e3, 50502);
        }
        catch (CSTSemanticException e4) {
            throw new VilException((Throwable)e4, 50502);
        }
    }

    private static String[] select(boolean initActual, String available, String actual) {
        String[] result = initActual ? new String[]{available, actual} : new String[]{available};
        return result;
    }

    @Invisible
    public static RuntimeVariableMapping createVariableMapping(Configuration config, RuntimeVariableMapping result) throws ModelQueryException {
        Project project = config.getProject();
        Compound sourceType = Utils.findCompound(project, "Source");
        Compound familyElementType = Utils.findCompound(project, "FamilyElement");
        Compound sinkType = Utils.findCompound(project, "Sink");
        if (result == null) {
            result = new RuntimeVariableMapping();
        }
        for (IDecisionVariable var : config) {
            IDatatype type = var.getDeclaration().getType();
            if (!sourceType.isAssignableFrom(type) && !sinkType.isAssignableFrom(type) && !familyElementType.isAssignableFrom(type)) continue;
            ConfigurationInitializer.addVariableMapping(var, "available", result);
        }
        return result;
    }

    private static void addVariableMapping(IDecisionVariable var, String fieldName, RuntimeVariableMapping result) {
        IDecisionVariable nested = VariableValueCopier.findVariable((IDecisionVariable)var, (String)fieldName);
        if (nested != null) {
            int n = 0;
            while (n < nested.getNestedElementsCount()) {
                IDecisionVariable tmp = nested.getNestedElement(n);
                Value tmpValue = tmp.getValue();
                if (tmpValue instanceof ReferenceValue) {
                    ReferenceValue rValue = (ReferenceValue)tmpValue;
                    IDecisionVariable referenced = var.getConfiguration().getDecision(rValue.getValue());
                    if (referenced != null) {
                        result.addReferencedBy(referenced, var);
                    }
                }
                ++n;
            }
        }
    }
}

