/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import eu.qualimaster.common.QMInternal;
import eu.qualimaster.common.QMSupport;
import eu.qualimaster.coordination.commands.CoordinationCommand;
import eu.qualimaster.easy.extension.internal.AlgorithmPrediction;
import eu.qualimaster.easy.extension.internal.AlgorithmPredictionEx;
import eu.qualimaster.easy.extension.internal.AlgorithmPredictionResult;
import eu.qualimaster.easy.extension.internal.BindValuesInstantiator;
import eu.qualimaster.easy.extension.internal.ConstraintViolationConverter;
import eu.qualimaster.easy.extension.internal.CoordinationHelper;
import eu.qualimaster.easy.extension.internal.HardwareRepositoryHelper;
import eu.qualimaster.easy.extension.internal.InitializationModeHelper;
import eu.qualimaster.easy.extension.internal.NameMappingHelper;
import eu.qualimaster.easy.extension.internal.ObservableHelper;
import eu.qualimaster.easy.extension.internal.ParameterPrediction;
import eu.qualimaster.easy.extension.internal.PipelineElementHelper;
import eu.qualimaster.easy.extension.internal.PipelineHelper;
import eu.qualimaster.easy.extension.internal.RepositoryHelper;
import eu.qualimaster.easy.extension.internal.SourceVolumePrediction;
import eu.qualimaster.easy.extension.internal.SubPipelineHelper;
import eu.qualimaster.easy.extension.internal.SubTopologyComponentsHelper;
import eu.qualimaster.easy.extension.internal.SubTopologyScalingHelper;
import eu.qualimaster.easy.extension.internal.TypeAnalyzer;
import eu.qualimaster.easy.extension.internal.Weighting;
import eu.qualimaster.easy.extension.internal.WeightingSelector;
import eu.qualimaster.events.IEvent;
import eu.qualimaster.observables.IObservable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ILazyDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IRegistration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.BuiltIn;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.RtVilStorage;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.types.ITypeAnalyzer;
import net.ssehub.easy.instantiation.rt.core.model.rtVil.types.RtVilTypeRegistry;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registration
implements IRegistration {
    public static final String QM_LIB_PROPERTY = "eu.qualiMaster.rtVil.libs";
    public static final String RESOURCE_CLASS_LIST = "qmExtension.list";
    private static final String CLASS_EXTENSION = ".class";
    private static final Logging LOGGING;
    private static final TypeAnalyzer ANALYZER;
    private static boolean registered;
    private static boolean debug;
    private static ClassLoader loader;
    private static boolean writeOutput;

    static {
        ANALYZER = new TypeAnalyzer();
        registered = false;
        debug = false;
        loader = Registration.class.getClassLoader();
        writeOutput = false;
        Logging tmp = System.getProperty(QM_LIB_PROPERTY, null) != null ? new Logging(){
            private Logger logger = LoggerFactory.getLogger(Registration.class);

            @Override
            public void error(String message) {
                this.logger.error(message);
            }

            @Override
            public void error(String message, Exception exception) {
                this.logger.error(message, (Throwable)exception);
            }

            @Override
            public void info(String message) {
                this.logger.info(message);
            }
        } : new Logging(){
            private EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(Registration.class, "QualiMaster.Extension");

            @Override
            public void error(String message) {
                this.logger.error(message);
            }

            @Override
            public void error(String message, Exception exception) {
                this.logger.error(message);
                this.logger.exception(exception);
            }

            @Override
            public void info(String message) {
                this.logger.info(message);
            }
        };
        LOGGING = tmp;
    }

    private static void obtainStreamFromClassLoader(ClassLoader loader, String name, List<JarInputStream> result) {
        InputStream stream = loader.getResourceAsStream(name);
        if (stream != null) {
            try {
                result.add(new JarInputStream(stream));
            }
            catch (IOException e) {
                LOGGING.error("Resource " + name + ":" + e.getMessage(), e);
            }
        }
    }

    private static List<JarInputStream> getJars(ClassLoader loader, String jarLocations) {
        String libs;
        ArrayList<JarInputStream> result = new ArrayList<JarInputStream>();
        String string = libs = jarLocations != null ? jarLocations : System.getProperty(QM_LIB_PROPERTY, null);
        if (libs == null) {
            Registration.obtainStreamFromClassLoader(loader, "lib/CoordinationLayer.jar", result);
            Registration.obtainStreamFromClassLoader(loader, "lib/QualiMaster.Events.jar", result);
            Registration.obtainStreamFromClassLoader(loader, "lib/AdaptationLayer.jar", result);
        } else {
            String[] tmp = libs.split(File.pathSeparator);
            int i = 0;
            while (i < tmp.length) {
                try {
                    result.add(new JarInputStream(new FileInputStream(new File(tmp[i]))));
                }
                catch (IOException e) {
                    LOGGING.error(e.getMessage(), e);
                }
                ++i;
            }
        }
        return result;
    }

    private static void readClassList(List<Class<?>> classes, ClassLoader loader, String prefix) {
        InputStream in = loader.getResourceAsStream(prefix + RESOURCE_CLASS_LIST);
        if (in != null) {
            try {
                String line;
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in));
                do {
                    if ((line = lnr.readLine()) == null) continue;
                    try {
                        classes.add(loader.loadClass(line));
                    }
                    catch (ClassNotFoundException e) {
                        LOGGING.error("Class not found " + e.getMessage());
                    }
                } while (line != null);
                in.close();
            }
            catch (IOException e) {
                LOGGING.error("Reading: " + e.getMessage(), e);
            }
        } else {
            LOGGING.info("Reading: resource qmExtension.list not found");
        }
    }

    private static void scanJars(List<Class<?>> classes, String jarLocations, ClassLoader loader) {
        List<JarInputStream> jars = Registration.getJars(loader, jarLocations);
        int i = 0;
        while (i < jars.size()) {
            JarInputStream jis = jars.get(i);
            try {
                JarEntry entry;
                do {
                    String name;
                    if ((entry = jis.getNextJarEntry()) == null || entry.isDirectory() || !(name = entry.getName()).endsWith(CLASS_EXTENSION) || -1 != name.indexOf(36)) continue;
                    name = name.substring(0, name.length() - CLASS_EXTENSION.length());
                    name = name.replace("/", ".");
                    Registration.considerImporting(loader, name, classes);
                } while (entry != null);
                jis.close();
            }
            catch (IOException e) {
                LOGGING.error(e.getMessage(), e);
            }
            ++i;
        }
    }

    private static void writeClassList(List<Class<?>> classes) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(new File("resources", RESOURCE_CLASS_LIST)));
            for (Class<?> cls : classes) {
                out.println(cls.getName());
            }
            out.close();
        }
        catch (IOException e) {
            LOGGING.error("Writing: " + e.getMessage(), e);
        }
    }

    public static final void setClassLoader(ClassLoader userLoader) {
        if (userLoader != null) {
            loader = userLoader;
        }
    }

    public static final void register(String jarLocations) {
        if (!registered) {
            registered = true;
            RtVilStorage.setStorageHint((boolean)true);
            RtVilTypeRegistry.setTypeAnalyzer((ITypeAnalyzer)ANALYZER);
            TypeRegistry regSave = ReflectionResolver.setTypeRegistry((TypeRegistry)RtVilTypeRegistry.INSTANCE);
            LinkedList toImport = new LinkedList();
            if (jarLocations == null) {
                Registration.readClassList(toImport, loader, "");
                if (toImport.isEmpty()) {
                    Registration.readClassList(toImport, loader, "resources/");
                }
            }
            if (toImport.isEmpty()) {
                Registration.scanJars(toImport, jarLocations, loader);
                if (writeOutput) {
                    Registration.writeClassList(toImport);
                }
            }
            ANALYZER.setImportingTypes(toImport);
            try {
                RtVilTypeRegistry.registerRtTypes(toImport);
            }
            catch (VilException e) {
                LOGGING.error("While registering " + e.getMessage(), (Exception)((Object)e));
            }
            ArrayList toPrint = new ArrayList();
            toPrint.addAll(toImport);
            Registration.registerType(AlgorithmPredictionResult.class, toPrint);
            ReflectionResolver.setTypeRegistry((TypeRegistry)regSave);
            Registration.printClasses(toPrint);
        }
    }

    private static void printOperations(TypeDescriptor<?> desc) {
        int o = 0;
        while (o < desc.getOperationsCount()) {
            OperationDescriptor oDesc = desc.getOperation(o);
            Object ret = oDesc.getReturnType().getVilName() + " ";
            if (oDesc.isConstructor()) {
                ret = "";
            }
            if (((String)ret).startsWith("PseudoVoid")) {
                ret = "";
            }
            System.out.println("        * " + (String)ret + oDesc.getSignature());
            ++o;
        }
    }

    private static boolean isQmInternal(Class<?> cls) {
        return cls.getAnnotation(QMInternal.class) != null;
    }

    private static boolean isQmSupport(Class<?> cls) {
        return cls.getAnnotation(QMSupport.class) != null;
    }

    private static void considerImporting(ClassLoader loader, String className, List<Class<?>> toImport) {
        try {
            Class<?> cls = loader.loadClass(className);
            if (Modifier.isPublic(cls.getModifiers()) && !Registration.isQmInternal(cls)) {
                if (CoordinationCommand.class.isAssignableFrom(cls)) {
                    toImport.add(cls);
                } else if (IEvent.class.isAssignableFrom(cls)) {
                    toImport.add(cls);
                } else if (IObservable.class.isAssignableFrom(cls)) {
                    toImport.add(cls);
                } else if (Registration.isQmSupport(cls)) {
                    toImport.add(cls);
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGING.info("Loading " + className + ": " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            LOGGING.info("Loading " + className + ": " + e.getMessage());
        }
    }

    private static void printClasses(List<Class<?>> toPrint) {
        if (debug && toPrint != null) {
            Collections.sort(toPrint, new ClassNameComparator());
            for (Class<?> cls : toPrint) {
                String name = ANALYZER.getVilName(cls);
                TypeDescriptor desc = RtVilTypeRegistry.INSTANCE.getType(name);
                if (desc == null && name.startsWith("qualimaster::")) {
                    String tmp = name.substring(13);
                    desc = RtVilTypeRegistry.INSTANCE.getType(tmp);
                }
                if (desc != null) {
                    System.out.println("    * " + desc.getName() + " / " + desc.getQualifiedName());
                    int f = 0;
                    while (f < desc.getFieldCount()) {
                        FieldDescriptor fDesc = desc.getField(f);
                        System.out.println("        * " + fDesc.getSignature());
                        ++f;
                    }
                    Registration.printOperations(desc);
                    continue;
                }
                System.out.println("NOT FOUND " + cls.getName());
            }
        }
    }

    protected void activate(ComponentContext context) {
        Registration.register(null);
        RtVilTypeRegistry.setTypeAnalyzer((ITypeAnalyzer)ANALYZER);
        TypeRegistry regSave = ReflectionResolver.setTypeRegistry((TypeRegistry)RtVilTypeRegistry.INSTANCE);
        ArrayList instantiators = new ArrayList();
        Registration.registerInstantiator(PipelineHelper.class, instantiators);
        Registration.registerInstantiator(PipelineElementHelper.class, instantiators);
        Registration.registerInstantiator(RepositoryHelper.class, instantiators);
        Registration.registerInstantiator(HardwareRepositoryHelper.class, instantiators);
        Registration.registerInstantiator(CoordinationHelper.class, instantiators);
        Registration.registerInstantiator(ObservableHelper.class, instantiators);
        Registration.registerInstantiator(SubTopologyComponentsHelper.class, instantiators);
        Registration.registerInstantiator(SubTopologyScalingHelper.class, instantiators);
        Registration.registerInstantiator(InitializationModeHelper.class, instantiators);
        Registration.registerInstantiator(NameMappingHelper.class, instantiators);
        Registration.registerInstantiator(SubPipelineHelper.class, instantiators);
        Registration.registerInstantiator(AlgorithmPrediction.class, instantiators);
        Registration.registerInstantiator(AlgorithmPredictionEx.class, instantiators);
        Registration.registerInstantiator(ParameterPrediction.class, instantiators);
        Registration.registerInstantiator(SourceVolumePrediction.class, instantiators);
        Registration.registerInstantiator(ConstraintViolationConverter.class, instantiators);
        Registration.registerInstantiator(Weighting.class, instantiators);
        Registration.registerInstantiator(WeightingSelector.class, instantiators);
        Registration.registerInstantiator(BindValuesInstantiator.class, instantiators);
        ReflectionResolver.setTypeRegistry((TypeRegistry)regSave);
        if (debug) {
            System.out.println("    Instantiators:");
            for (TypeDescriptor typeDescriptor : instantiators) {
                Registration.printOperations(typeDescriptor);
            }
            System.out.println();
            System.err.println("Please refresh the project and commit the changes.");
        }
    }

    private static void registerType(Class<? extends IVilType> cls, List<Class<?>> classes) {
        try {
            RtVilTypeRegistry.registerRtType(cls);
            if (classes != null) {
                classes.add(cls);
            }
        }
        catch (VilException e) {
            LOGGING.info("Registering " + cls.getName() + ": " + e.getMessage());
        }
    }

    private static void registerInstantiator(Class<? extends IVilType> cls, List<TypeDescriptor<?>> instantiators) {
        try {
            TypeDescriptor desc = RtVilTypeRegistry.INSTANCE.register(cls);
            if (desc != null) {
                int o = 0;
                while (o < desc.getOperationsCount()) {
                    OperationDescriptor od = desc.getOperation(o);
                    if (od instanceof ILazyDescriptor) {
                        ((ILazyDescriptor)od).forceInitialization();
                    }
                    ++o;
                }
                instantiators.add(desc);
            }
        }
        catch (Throwable e) {
            LOGGING.info("Loading " + cls.getName() + ": " + e.getMessage());
        }
    }

    protected void deactivate(ComponentContext context) {
    }

    public static void main(String[] args) {
        writeOutput = true;
        net.ssehub.easy.instantiation.core.model.vilTypes.BuiltIn.initialize();
        BuiltIn.initialize();
        debug = true;
        String[] jarNames = new String[]{"CoordinationLayer", "QualiMaster.Events", "AdaptationLayer", "DataManagementLayer", "MonitoringLayer", "StormCommons"};
        Object jarLocations = "";
        int i = 0;
        while (i < jarNames.length) {
            if (i > 0) {
                jarLocations = (String)jarLocations + File.pathSeparator;
            }
            jarLocations = (String)jarLocations + "../libs.QualiMaster/" + jarNames[i] + ".jar";
            ++i;
        }
        Registration.register((String)jarLocations);
        Registration reg = new Registration();
        reg.activate(null);
        reg.deactivate(null);
    }

    public static void error(String message) {
        LOGGING.error(message);
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        private ClassNameComparator() {
        }

        private static String getName(Class<?> cls) {
            String name = ANALYZER.getVilName(cls);
            if (name == null) {
                name = cls.getName();
            }
            return name;
        }

        @Override
        public int compare(Class<?> cls1, Class<?> cls2) {
            return ClassNameComparator.getName(cls1).compareTo(ClassNameComparator.getName(cls2));
        }
    }

    private static interface Logging {
        public void error(String var1);

        public void error(String var1, Exception var2);

        public void info(String var1);
    }
}

