/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.modelop;

import eu.qualimaster.easy.extension.internal.Bundle;
import eu.qualimaster.easy.extension.modelop.BasicIVMLModelOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ConfigurationSaver;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.CopyVisitor;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.filter.FrozenElementsFinder;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class QualiMasterConfigurationSaver
extends ConfigurationSaver {
    private Map<AbstractVariable, AbstractVariable> varMapping;

    public QualiMasterConfigurationSaver(Configuration srcConfiguration) throws ConfigurationException {
        this(srcConfiguration, true, true);
    }

    protected QualiMasterConfigurationSaver(Configuration srcConfiguration, boolean ownProject, boolean onlyUserInput) throws ConfigurationException {
        super(srcConfiguration, ownProject, onlyUserInput);
    }

    private void lazyInit() {
        if (this.varMapping == null) {
            this.varMapping = new HashMap<AbstractVariable, AbstractVariable>();
        }
    }

    protected Project createProject(Configuration srcConfiguration) {
        return new Project(srcConfiguration.getProject().getName());
    }

    protected void addLocalVariables(Project destProject, Configuration srcConfiguration) {
        this.lazyInit();
        Project srcProject = srcConfiguration.getProject();
        int e = 0;
        while (e < srcProject.getElementCount()) {
            ContainableModelElement elt = srcProject.getElement(e);
            if (elt instanceof DecisionVariableDeclaration) {
                DecisionVariableDeclaration decl = (DecisionVariableDeclaration)elt;
                DecisionVariableDeclaration destDecl = new DecisionVariableDeclaration(decl.getName(), decl.getType(), (IModelElement)destProject);
                this.varMapping.put((AbstractVariable)decl, (AbstractVariable)destDecl);
                destProject.add((ContainableModelElement)destDecl);
            }
            ++e;
        }
        if (!this.varMapping.isEmpty()) {
            CopyVisitor vis = new CopyVisitor(this.varMapping);
            for (Map.Entry<AbstractVariable, AbstractVariable> entry : this.varMapping.entrySet()) {
                ConstraintSyntaxTree dflt = entry.getKey().getDefaultValue();
                if (dflt == null) continue;
                dflt.accept((IConstraintTreeVisitor)vis);
                try {
                    entry.getKey().setValue(vis.getResult());
                }
                catch (ValueDoesNotMatchTypeException e2) {
                    Bundle.getLogger(QualiMasterConfigurationSaver.class).exception((Exception)((Object)e2));
                }
                catch (CSTSemanticException e3) {
                    Bundle.getLogger(QualiMasterConfigurationSaver.class).exception((Exception)((Object)e3));
                }
                vis.clear();
            }
        }
    }

    private ConstraintSyntaxTree createIndexAccess(DecisionVariableDeclaration decl, Value containerValue, Value value) {
        int pos;
        OCLFeatureCall result = null;
        if (containerValue instanceof ContainerValue && (pos = ((ContainerValue)containerValue).indexOf(value)) >= 0) {
            try {
                Value indexValue = ValueFactory.createValue((IDatatype)IntegerType.TYPE, (Object[])new Object[]{OclKeyWords.toIvmlIndex((int)pos)});
                result = new OCLFeatureCall((ConstraintSyntaxTree)new Variable((AbstractVariable)decl), "[]", new ConstraintSyntaxTree[]{new ConstantValue(indexValue)});
            }
            catch (ValueDoesNotMatchTypeException ex) {
                Bundle.getLogger(QualiMasterConfigurationSaver.class).exception((Exception)((Object)ex));
            }
        }
        return result;
    }

    private ConstraintSyntaxTree searchSequenceValue(Project project, Value value, Configuration config) {
        return this.searchSequenceValue(project, value, config, new HashSet<Object>());
    }

    private ConstraintSyntaxTree searchSequenceValue(Project project, Value value, Configuration config, Set<Object> done) {
        ConstraintSyntaxTree result = null;
        if (!done.contains(project)) {
            done.add(project);
            IDatatype valueType = value.getType();
            int e = 0;
            while (e < project.getElementCount()) {
                DecisionVariableDeclaration decl;
                IDatatype declType;
                ContainableModelElement elt = project.getElement(e);
                if (elt instanceof DecisionVariableDeclaration && Sequence.isSequence((IDatatype)(declType = (decl = (DecisionVariableDeclaration)elt).getType()), (IDatatype[])new IDatatype[]{valueType})) {
                    IDecisionVariable candidateVar = config.getDecision((AbstractVariable)decl);
                    result = this.createIndexAccess(decl, candidateVar.getValue(), value);
                }
                ++e;
            }
            if (result == null) {
                int i = 0;
                while (result == null && i < project.getImportsCount()) {
                    Project imp = (Project)project.getImport(i).getResolved();
                    if (imp != null) {
                        result = this.searchSequenceValue(imp, value, config, done);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    protected ConstraintSyntaxTree createAssignmentConstraint(Project dstProject, AbstractVariable decl, IDecisionVariable var, Value value) {
        AbstractVariable dstDecl;
        Configuration config = var.getConfiguration();
        AbstractVariable abstractVariable = dstDecl = this.varMapping != null ? this.varMapping.get(decl) : decl;
        if (dstDecl == null) {
            dstDecl = decl;
        }
        ConstraintSyntaxTree rightSide = null;
        if (Reference.TYPE.isAssignableFrom(value.getType())) {
            rightSide = this.searchSequenceValue(dstProject, value, config);
        }
        if (rightSide == null) {
            rightSide = new ConstantValue(this.toSaveableValue(var, value));
        }
        OCLFeatureCall constraint = new OCLFeatureCall(this.deriveOperand(dstDecl, var), "=", new ConstraintSyntaxTree[]{rightSide});
        return constraint;
    }

    protected void addImports(Project destProject, Configuration srcConfiguration) {
        Project srcProject = srcConfiguration.getProject();
        int i = 0;
        while (i < srcProject.getImportsCount()) {
            ProjectImport srcImp = srcProject.getImport(i);
            try {
                IVersionRestriction restrictions = srcImp.copyVersionRestriction((IModel)destProject);
                ProjectImport dstImp = new ProjectImport(srcImp.getName(), srcImp.getInterfaceName(), srcImp.isConflict(), srcImp.isCopied(), restrictions);
                dstImp.setResolved((Project)srcImp.getResolved());
                destProject.addImport(dstImp);
            }
            catch (ModelManagementException e) {
                Bundle.getLogger(QualiMasterConfigurationSaver.class).exception((Exception)((Object)e));
            }
            catch (RestrictionEvaluationException e) {
                Bundle.getLogger(QualiMasterConfigurationSaver.class).exception((Exception)((Object)e));
            }
            ++i;
        }
    }

    protected boolean isSavingEnabled(Project destProject, IDecisionVariable var) {
        boolean enabled;
        AbstractVariable decl = var.getDeclaration();
        IDatatype type = decl.getType();
        if (ConstraintType.isConstraint((IDatatype)type)) {
            enabled = false;
        } else if (var.getParent() instanceof Configuration) {
            String decisionNamespace = var.getDeclaration().getNameSpace();
            String dstProjectNamespace = destProject.getName();
            enabled = dstProjectNamespace.equals(decisionNamespace);
            if (!enabled && dstProjectNamespace.endsWith("Cfg")) {
                String defProjectNamespace = dstProjectNamespace.substring(0, dstProjectNamespace.length() - "Cfg".length());
                enabled = defProjectNamespace.equals(decisionNamespace);
            }
        } else {
            enabled = true;
        }
        return enabled;
    }

    protected FreezeBlock createFreezeBlock(IFreezable[] freezables, Project parent) {
        FreezeBlock block = BasicIVMLModelOperations.createFreezeBlock(freezables, parent, null);
        if (block == null) {
            block = super.createFreezeBlock(freezables, parent);
        }
        return block;
    }

    protected void saveFreezeStates(Project confProject) {
        ArrayList<IFreezable> frozenElements = new ArrayList<IFreezable>();
        for (IDecisionVariable decisionVariable : this.getConfiguration()) {
            if (decisionVariable.getState() != AssignmentState.FROZEN || !(decisionVariable.getDeclaration() instanceof IFreezable)) continue;
            frozenElements.add((IFreezable)decisionVariable.getDeclaration());
        }
        FrozenElementsFinder finder = new FrozenElementsFinder(this.getConfiguration().getProject(), FilterType.ONLY_IMPORTS);
        List alreadyFrozenElements = finder.getFrozenElements();
        frozenElements.removeAll(alreadyFrozenElements);
        if (frozenElements.size() > 0) {
            IFreezable[] freezables = new IFreezable[frozenElements.size()];
            frozenElements.toArray(freezables);
            FreezeBlock freeze = this.createFreezeBlock(freezables, confProject);
            confProject.add((ContainableModelElement)freeze);
        }
    }
}

