/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension;

import eu.qualimaster.monitoring.ObservableMapper;
import eu.qualimaster.monitoring.observations.ObservationFactory;
import eu.qualimaster.monitoring.parts.IPartType;
import eu.qualimaster.monitoring.parts.PartType;
import eu.qualimaster.observables.AnalysisObservables;
import eu.qualimaster.observables.IObservable;
import java.util.HashMap;
import java.util.Map;

public class ObservableMapping {
    private static final Map<String, String> ALGORITHM_OBSERVABLES = new HashMap<String, String>();
    private static final Map<String, String> REVERSE_ALGORITHM_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> GENERAL_OBSERVABLES = new HashMap<String, String>();
    private static final Map<String, String> REVERSE_GENERAL_MAPPING = new HashMap<String, String>();

    static {
        Map reverse = ObservableMapper.getReverseNameMapping();
        PartType[] partTypeArray = PartType.values();
        int n = partTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartType part = partTypeArray[n2];
            for (IObservable obs : ObservationFactory.getObservations((IPartType)part)) {
                String name;
                if (AnalysisObservables.IS_ENACTING == obs || (name = (String)reverse.get(obs)) == null) continue;
                if (PartType.ALGORITHM == part) {
                    ObservableMapping.putAlgorithmMapping(obs, name);
                    continue;
                }
                ObservableMapping.put(obs, name);
            }
            ++n2;
        }
    }

    private static void putAlgorithmMapping(IObservable observable, String variableName) {
        ALGORITHM_OBSERVABLES.put(observable.name(), variableName);
        REVERSE_ALGORITHM_MAPPING.put(variableName, observable.name());
    }

    private static void put(IObservable observable, String variableName) {
        GENERAL_OBSERVABLES.put(observable.name(), variableName);
        REVERSE_GENERAL_MAPPING.put(variableName, observable.name());
    }

    public static String mapAlgorithmObservable(String implementingObservableName) {
        return ALGORITHM_OBSERVABLES.get(implementingObservableName);
    }

    public static String mapReverseAlgorithmObservable(String variableObservableName) {
        return REVERSE_ALGORITHM_MAPPING.get(variableObservableName);
    }

    public static String mapGeneralObservable(String implementingObservableName) {
        return GENERAL_OBSERVABLES.get(implementingObservableName);
    }

    public static String mapReverseGeneralObservable(String variableObservableName) {
        return REVERSE_GENERAL_MAPPING.get(variableObservableName);
    }
}

