/*
 * Decompiled with CFR 0.152.
 */
package eu.qualimaster.easy.extension.internal;

import java.util.Iterator;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.RealValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;

public class VariableHelper {
    public static String getName(IDecisionVariable var) {
        Value nameValue;
        IDecisionVariable nameVar;
        String result = null;
        if (var != null && (nameVar = var.getNestedElement("name")) != null && (nameValue = nameVar.getValue()) instanceof StringValue) {
            result = ((StringValue)nameValue).getValue();
        }
        return result;
    }

    public static boolean hasName(IDecisionVariable var, String name) {
        boolean result = false;
        String varName = VariableHelper.getName(var);
        if (varName != null) {
            result = varName.equals(name);
        }
        return result;
    }

    public static final Boolean getBoolean(IDecisionVariable var, String name) {
        Value value;
        IDecisionVariable nested;
        Boolean result = null;
        if (var != null && (nested = var.getNestedElement(name)) != null && (value = nested.getValue()) instanceof BooleanValue) {
            result = ((BooleanValue)value).getValue();
        }
        return result;
    }

    public static final String getString(IDecisionVariable var, String name) {
        Value value;
        IDecisionVariable nested;
        String result = null;
        if (var != null && (nested = var.getNestedElement(name)) != null && (value = nested.getValue()) instanceof StringValue) {
            result = ((StringValue)value).getValue();
        }
        return result;
    }

    public static final Integer getInteger(IDecisionVariable var, String name) {
        Value value;
        IDecisionVariable nested;
        Integer result = null;
        if (var != null && (nested = var.getNestedElement(name)) != null && (value = nested.getValue()) instanceof IntValue) {
            result = ((IntValue)value).getValue();
        }
        return result;
    }

    public static final Double getDouble(IDecisionVariable var, String name) {
        IDecisionVariable nested;
        Double result = null;
        if (var != null && (nested = var.getNestedElement(name)) != null) {
            Integer tmp;
            Value value = nested.getValue();
            if (value instanceof RealValue) {
                result = ((RealValue)value).getValue();
            } else if (value instanceof IntValue && (tmp = ((IntValue)value).getValue()) != null) {
                result = tmp.doubleValue();
            }
        }
        return result;
    }

    public static final IDecisionVariable findNamedVariable(Configuration config, IDatatype type, String name) {
        IDecisionVariable result = null;
        Iterator iter = config.iterator();
        while (result == null && iter.hasNext()) {
            IDecisionVariable var = Configuration.dereference((IDecisionVariable)((IDecisionVariable)iter.next()));
            if (type != null && !type.isAssignableFrom(var.getDeclaration().getType()) || !VariableHelper.hasName(var, name)) continue;
            result = var;
        }
        return result;
    }

    public static final IDecisionVariable findNamedVariable(IDecisionVariable variable, IDatatype type, String name) {
        IDecisionVariable result = null;
        int n = 0;
        while (result == null && n < variable.getNestedElementsCount()) {
            IDecisionVariable var = Configuration.dereference((IDecisionVariable)variable.getNestedElement(n));
            if ((type == null || type.isAssignableFrom(var.getDeclaration().getType())) && VariableHelper.hasName(var, name)) {
                result = var;
            }
            ++n;
        }
        return result;
    }
}

