/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.standalone.cmd;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.mgmt.IVilExecutionListener;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.VilArgumentProvider;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.standalone.cmd.GenericVilArgumentProvider;
import net.ssehub.easy.standalone.cmd.LowlevelCommands;
import net.ssehub.easy.standalone.cmd.ModelLoadDefinition;
import net.ssehub.easy.standalone.cmd.ProjectNameMapper;
import net.ssehub.easy.standalone.cmd.Utils;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import org.apache.commons.io.FileUtils;

public final class InstantiationCommands {
    private InstantiationCommands() {
    }

    public static void instantiateSelf(File project) throws PersistenceException, VilException {
        InstantiationCommands.instantiateSelf(project, (Map<String, Object>)null);
    }

    public static void instantiateSelf(File project, Map<String, Object> arguments) throws PersistenceException, VilException {
        VilArgumentProvider provider = InstantiationCommands.createArgumentProvider(arguments);
        LowlevelCommands.loadProject(project);
        String projectName = ProjectNameMapper.getInstance().getName(project);
        PLPInfo plp = LowlevelCommands.getProject(projectName);
        if (null != plp) {
            InstantiationListener listener = new InstantiationListener();
            plp.addVilExecutionListener((IVilExecutionListener)listener);
            plp.instantiate(ProgressObserver.NO_OBSERVER, true);
            if (null != listener.exc) {
                throw listener.exc;
            }
        } else {
            throw new PersistenceException("Project \"" + projectName + "\" could not be loaded.");
        }
        VilArgumentProvider.remove((VilArgumentProvider)provider);
    }

    public static void instantiateSelf(File project, File ivmlFile) throws ModelManagementException, VilException, PersistenceException {
        InstantiationCommands.instantiateSelf(project, ivmlFile, (Map<String, Object>)null);
    }

    public static void instantiateSelf(File project, File ivmlFile, Map<String, Object> arguments) throws ModelManagementException, VilException, PersistenceException {
        String projectName = ProjectNameMapper.getInstance().getName(project);
        File configFolder = PersistenceUtils.getLocationFile((File)project, (Configuration.PathKind)Configuration.PathKind.IVML);
        String path = PersistenceUtils.vilFileLocation((String)projectName, (String)"0", (String)configFolder.getAbsolutePath());
        File buildScriptFile = new File(path);
        InstantiationCommands.instantiateSelf(project, ivmlFile, buildScriptFile, arguments);
    }

    public static void instantiateSelf(File project, File ivmlFile, File buildScriptFile) throws ModelManagementException, VilException, PersistenceException {
        InstantiationCommands.instantiateSelf(project, ivmlFile, buildScriptFile, null);
    }

    public static void instantiateSelf(File project, File ivmlFile, File buildScriptFile, Map<String, Object> arguments) throws ModelManagementException, VilException, PersistenceException {
        Project ivmlProject = (Project)PersistenceUtils.loadModel((ModelManagement)VarModel.INSTANCE, (File)ivmlFile);
        Script buildScript = (Script)PersistenceUtils.loadModel((ModelManagement)BuildModel.INSTANCE, (File)buildScriptFile);
        Configuration config = PersistenceUtils.getConfiguration((File)project);
        PersistenceUtils.processLocation((Configuration)config, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        if (null != ivmlProject && null != buildScript) {
            VilArgumentProvider provider = InstantiationCommands.createArgumentProvider(arguments);
            String projectName = ProjectNameMapper.getInstance().getName(project);
            ProjectContainer pCont = new ProjectContainer(ivmlProject, config);
            ScriptContainer sCont = new ScriptContainer(buildScript, config);
            ProductLineProject plp = new ProductLineProject(UUID.randomUUID().toString(), projectName, pCont, project, sCont);
            InstantiationListener listener = new InstantiationListener();
            plp.addVilExecutionListener((IVilExecutionListener)listener);
            plp.instantiate(ProgressObserver.NO_OBSERVER, true);
            VilArgumentProvider.remove((VilArgumentProvider)provider);
            if (null != listener.exc) {
                throw listener.exc;
            }
        } else {
            throw new PersistenceException("The specified IVML/VIL files could not be loaded.");
        }
    }

    private static VilArgumentProvider createArgumentProvider(Map<String, Object> arguments) {
        GenericVilArgumentProvider argProvider = null;
        if (null != arguments) {
            argProvider = new GenericVilArgumentProvider(arguments);
            VilArgumentProvider.add((VilArgumentProvider)argProvider);
        }
        return argProvider;
    }

    public static void instantiate(File projectSource, File projectTarget) throws PersistenceException, VilException, IOException {
        InstantiationCommands.instantiate(projectSource, projectTarget, null);
    }

    public static void instantiate(File projectSource, File projectTarget, Map<String, Object> arguments) throws PersistenceException, VilException, IOException {
        if (projectSource.exists() && projectTarget.exists()) {
            InstantiationCommands.instantiateEASyProjects(projectSource, projectTarget, arguments);
        } else if (!projectTarget.exists()) {
            VilArgumentProvider provider = InstantiationCommands.createArgumentProvider(arguments);
            LowlevelCommands.loadProject(projectSource);
            String projectName = ProjectNameMapper.getInstance().getName(projectSource);
            PLPInfo plpPre = LowlevelCommands.getProject(projectName);
            Configuration configTarget = PersistenceUtils.getConfiguration((File)projectTarget);
            File parentFolder = projectTarget.getParentFile();
            String projectNameTrg = ProjectNameMapper.getInstance().getName(projectTarget);
            PathEnvironment pathEnv = new PathEnvironment(parentFolder);
            File easyConfigFile = PersistenceUtils.getLocationFile((File)projectTarget, (Configuration.PathKind)Configuration.PathKind.IVML);
            Persistencer persistencer = new Persistencer(pathEnv, projectTarget, easyConfigFile.getAbsolutePath(), ProgressObserver.NO_OBSERVER);
            IProjectCreationResult result = persistencer.createProject(projectNameTrg, parentFolder, UUID.randomUUID().toString(), false);
            ScriptContainer sCont = new ScriptContainer(result.getBuildScript(), configTarget);
            ProjectContainer pCont = new ProjectContainer(result.getVarModel(), configTarget);
            ProductLineProject plpSuc = new ProductLineProject(result.getProjectID(), projectNameTrg, pCont, projectTarget, sCont);
            plpSuc.getMemberController().addPredecessor(plpPre);
            PersistenceUtils.addImport((PLPInfo)plpSuc, (PLPInfo)plpPre, (boolean)true);
            plpSuc.pullConfigFromPredecessors();
            PersistenceUtils.refreshModels((PLPInfo)plpSuc);
            PersistenceUtils.createInstantiatePredecessorScript((PLPInfo)plpSuc, (PLPInfo[])new PLPInfo[]{plpPre});
            sCont.setEdited(true);
            plpSuc.save();
            InstantiationListener listener = new InstantiationListener();
            plpSuc.addVilExecutionListener((IVilExecutionListener)listener);
            plpSuc.instantiate(ProgressObserver.NO_OBSERVER, true);
            VilArgumentProvider.remove((VilArgumentProvider)provider);
            if (null != listener.exc) {
                throw listener.exc;
            }
        }
    }

    private static void instantiateEASyProjects(File projectSource, File projectTarget, Map<String, Object> arguments) throws PersistenceException, VilException {
        VilArgumentProvider provider = InstantiationCommands.createArgumentProvider(arguments);
        LowlevelCommands.loadProject(projectSource);
        LowlevelCommands.loadProject(projectTarget);
        String projectName = ProjectNameMapper.getInstance().getName(projectTarget);
        PLPInfo plp = LowlevelCommands.getProject(projectName);
        if (null != plp) {
            InstantiationListener listener = new InstantiationListener();
            plp.addVilExecutionListener((IVilExecutionListener)listener);
            plp.instantiate(ProgressObserver.NO_OBSERVER, true);
            if (null != listener.exc) {
                throw listener.exc;
            }
        } else {
            throw new PersistenceException("Project \"" + projectName + "\" could not be loaded.");
        }
        VilArgumentProvider.remove((VilArgumentProvider)provider);
    }

    public static void instantiate(File projectSource, File projectTarget, File ivmlFile, File scriptFile) throws ModelManagementException, SecurityException, PersistenceException, VilException, IOException {
        InstantiationCommands.instantiate(projectSource, projectTarget, ivmlFile, scriptFile, null);
    }

    public static void instantiate(File projectSource, File projectTarget, File ivmlFile, File scriptFile, Map<String, Object> arguments) throws ModelManagementException, SecurityException, PersistenceException, VilException, IOException {
        boolean vilReleativeToProjects;
        boolean ivmlReleativeToProjects = InstantiationCommands.checkIsNestedFile(projectSource, ivmlFile) || InstantiationCommands.checkIsNestedFile(projectTarget, ivmlFile);
        boolean bl = vilReleativeToProjects = InstantiationCommands.checkIsNestedFile(projectSource, scriptFile) || InstantiationCommands.checkIsNestedFile(projectTarget, scriptFile);
        if (!ivmlReleativeToProjects || !vilReleativeToProjects) {
            throw new PersistenceException("IVML and VIL files must be located either inside the source or the target folder.");
        }
        InstantiationCommands.createTargetFolder(projectSource, projectTarget);
        Configuration configSource = PersistenceUtils.getConfiguration((File)projectSource);
        PersistenceUtils.processLocation((Configuration)configSource, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        Configuration configTarget = PersistenceUtils.getConfiguration((File)projectTarget);
        PersistenceUtils.processLocation((Configuration)configTarget, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        Project ivmlProject = (Project)PersistenceUtils.loadModel((ModelManagement)VarModel.INSTANCE, (File)ivmlFile);
        Script buildScript = (Script)PersistenceUtils.loadModel((ModelManagement)BuildModel.INSTANCE, (File)scriptFile);
        if (null == ivmlProject || null == buildScript) {
            throw new PersistenceException("The specified IVML/VIL files could not be loaded.");
        }
        InstantiationCommands.createPLPsAndInstantiate(projectSource, projectTarget, ivmlProject, buildScript, arguments);
    }

    private static void createPLPsAndInstantiate(File projectSource, File projectTarget, Project ivmlProject, Script buildScript, Map<String, Object> arguments) throws VilException {
        VilArgumentProvider provider = InstantiationCommands.createArgumentProvider(arguments);
        String projectNameSrc = ProjectNameMapper.getInstance().getName(projectSource);
        ProductLineProject plpPre = new ProductLineProject(projectNameSrc, projectSource);
        Configuration config = PersistenceUtils.getConfiguration((File)projectTarget);
        String projectNameTrg = ProjectNameMapper.getInstance().getName(projectTarget);
        ProjectContainer pCont = new ProjectContainer(ivmlProject, config);
        ScriptContainer sCont = new ScriptContainer(buildScript, config);
        ProductLineProject plpSuc = new ProductLineProject(UUID.randomUUID().toString(), projectNameTrg, pCont, projectTarget, sCont);
        plpSuc.getMemberController().addPredecessor((PLPInfo)plpPre);
        InstantiationListener listener = new InstantiationListener();
        plpSuc.addVilExecutionListener((IVilExecutionListener)listener);
        plpSuc.instantiate(ProgressObserver.NO_OBSERVER, true);
        VilArgumentProvider.remove((VilArgumentProvider)provider);
        if (null != listener.exc) {
            throw listener.exc;
        }
    }

    public static void instantiate(File projectSource, File projectTarget, ModelLoadDefinition ivmlDefinition, ModelLoadDefinition vilDefinition) throws PersistenceException, IOException, ModelManagementException, VilException {
        InstantiationCommands.instantiate(projectSource, projectTarget, ivmlDefinition, vilDefinition, null);
    }

    public static void instantiate(File projectSource, File projectTarget, ModelLoadDefinition ivmlDefinition, ModelLoadDefinition vilDefinition, Map<String, Object> arguments) throws PersistenceException, IOException, ModelManagementException, VilException {
        InstantiationCommands.createTargetFolder(projectSource, projectTarget);
        Configuration configSource = PersistenceUtils.getConfiguration((File)projectSource);
        Configuration configTarget = PersistenceUtils.getConfiguration((File)projectTarget);
        PersistenceUtils.processLocation((Configuration)configSource, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        PersistenceUtils.processLocation((Configuration)configTarget, (boolean)true, (boolean)false, (ProgressObserver)ProgressObserver.NO_OBSERVER);
        Project ivmlProject = (Project)Utils.loadPreferredModel(VarModel.INSTANCE, ivmlDefinition, new File[]{projectTarget, projectSource});
        Script script = (Script)Utils.loadPreferredModel(BuildModel.INSTANCE, vilDefinition, new File[]{projectTarget, projectSource});
        if (null == ivmlProject || null == script) {
            throw new PersistenceException("The specified IVML/VIL files could not be loaded.");
        }
        InstantiationCommands.createPLPsAndInstantiate(projectSource, projectTarget, ivmlProject, script, arguments);
    }

    private static boolean checkIsNestedFile(File possibleParent, File maybeChild) {
        boolean isNested = false;
        File parent = null;
        try {
            parent = possibleParent.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String child = null;
        try {
            child = maybeChild.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != parent && null != child) {
            isNested = child.startsWith(parent.getAbsolutePath());
        }
        return isNested;
    }

    private static void createTargetFolder(File projectSource, File projectTarget) throws PersistenceException, IOException {
        if (!projectTarget.exists()) {
            if (!projectTarget.mkdir()) {
                throw new PersistenceException("Folder " + projectTarget.getAbsolutePath() + " does not exist and could not be created.");
            }
            File easySrcFiles = new File(projectSource, "EASy");
            File easyTrgFiles = new File(projectTarget, "EASy");
            FileUtils.copyDirectory((File)easySrcFiles, (File)easyTrgFiles);
        }
    }

    private static class InstantiationListener
    implements IVilExecutionListener {
        private VilException exc = null;

        private InstantiationListener() {
        }

        public void vilExecutionAborted(PLPInfo plp, VilException exc) {
            this.exc = exc;
        }

        public void vilExecutionFinished(PLPInfo plp, boolean instantiationSuccessfull) {
        }
    }
}

