/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.buildLanguageTranslation.ExpressionTranslator;
import de.uni_hildesheim.sse.buildLanguageTranslation.ModelTranslator;
import de.uni_hildesheim.sse.vil.buildlang.VilBuildLanguageRuntimeModule;
import de.uni_hildesheim.sse.vil.buildlang.VilBuildLanguageStandaloneSetup;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.ImplementationUnit;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.LanguageUnit;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

public class BuildLangModelUtility
extends ModelUtility<ImplementationUnit, Script>
implements IModelLoader<Script> {
    public static final BuildLangModelUtility INSTANCE = new BuildLangModelUtility();

    private BuildLangModelUtility() {
    }

    public TranslationResult<Script> createBuildModel(ImplementationUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        return new TranslationResult(translator.createModel(root, uri, registerSuccessful, null), (MessageReceiver)translator);
    }

    protected void initializeAfterResourceInitializer() {
        if (BuildLangModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new VilBuildLanguageRuntimeModule()}));
        } else {
            this.setInjector(new VilBuildLanguageStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    public TranslationResult<Script> parse(URI uri, ImportResolver<Script> resolver) throws IOException {
        ModelTranslator translator = new ModelTranslator();
        ImplementationUnit root = (ImplementationUnit)this.parse(uri, true, (MessageReceiver)translator, ImplementationUnit.class);
        List<Script> result = null;
        if (root != null) {
            try {
                result = translator.createModel(root, BuildLangModelUtility.toNetUri((URI)uri), true, resolver);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return new TranslationResult(result, (MessageReceiver)translator);
    }

    public void print(TranslationResult<Script> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            BuildlangWriter writer = new BuildlangWriter(out);
            int p = 0;
            while (p < result.getResultCount()) {
                try {
                    ((Script)result.getResult(p)).accept((IVisitor)writer);
                }
                catch (VilException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(BuildLangModelUtility.class, "de.uni_hildesheim.sse.vil.buildlang");
                }
                ++p;
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.vil.buildlang.VilBuildLanguage";
    }

    protected ClassLoader getLanguageClassLoader() {
        return BuildLangModelUtility.class.getClassLoader();
    }

    public net.ssehub.easy.instantiation.core.model.expressions.Expression createExpression(String text, Resolver resolver, StringBuilder warnings) throws VilException {
        net.ssehub.easy.instantiation.core.model.expressions.Expression result;
        block11: {
            result = null;
            IParseResult parseResult = this.parseFragment("Expression", text);
            if (parseResult != null) {
                StringBuilder errors = new StringBuilder();
                for (INode error : parseResult.getSyntaxErrors()) {
                    BuildLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
                }
                if (errors.length() == 0 && parseResult.getRootASTElement() == null) {
                    BuildLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty expression");
                }
                if (errors.length() == 0) {
                    ExpressionTranslator translator = new ExpressionTranslator();
                    Expression expr = (Expression)parseResult.getRootASTElement();
                    translator.enactIvmlWarnings();
                    try {
                        result = translator.processExpression(expr, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
                        int i = 0;
                        while (i < translator.getMessageCount()) {
                            Message msg = translator.getMessage(i);
                            if (Status.ERROR == msg.getStatus()) {
                                BuildLangModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                            } else if (warnings != null) {
                                BuildLangModelUtility.appendWithNewLine((StringBuilder)warnings, (String)msg.getDescription());
                            }
                            ++i;
                        }
                        if (translator.getErrorCount() > 0) {
                            throw new VilException(errors.toString(), 70000);
                        }
                        break block11;
                    }
                    catch (TranslatorException e) {
                        throw new VilException((Throwable)e, e.getId());
                    }
                }
                throw new VilException(errors.toString() + " in expression '" + text + "'", 30003);
            }
        }
        return result;
    }

    public net.ssehub.easy.instantiation.core.model.expressions.Expression createExpression(String text, IRuntimeEnvironment environment) throws VilException {
        return this.createExpression(text, new Resolver(environment), null);
    }

    public String getExtension() {
        return "vil";
    }

    public List<ModelInfo<Script>> obtainInfo(URI uri) throws IOException {
        ImplementationUnit root = (ImplementationUnit)this.parse(uri, true, null, ImplementationUnit.class);
        ArrayList<ModelInfo<Script>> result = new ArrayList<ModelInfo<Script>>();
        if (root != null) {
            for (LanguageUnit script : root.getScripts()) {
                Version version = ModelTranslator.convert((VersionStmt)script.getVersion());
                ArrayList<ModelImport> imports = new ArrayList<ModelImport>();
                for (Import imp : script.getImports()) {
                    String name = imp.getName();
                    imports.add(new ModelImport(name, false, null));
                }
                try {
                    result.add((ModelInfo<Script>)new ModelInfo(script.getName(), version, (IModelLoader)this, BuildLangModelUtility.toNetUri((URI)uri), imports));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public ModelInfo<Script> getInfo(java.net.URI uri) {
        return BuildModel.INSTANCE.availableModels().getInfo(uri);
    }
}

