/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.values;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class FloatValueConverter
extends AbstractLexerBasedConverter<Double> {
    protected String toEscapedString(Double value) {
        return value.toString();
    }

    protected void assertValidValue(Double value) {
        super.assertValidValue((Object)value);
        if (value < 0.0) {
            throw new ValueConverterException(this.getRuleName() + "-value may not be negative (value:" + String.valueOf(value) + ").", null, null);
        }
    }

    public Double toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to double.", node, null);
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to double.", node, (Exception)e);
        }
    }
}

