/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.translation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class ExpressionTranslator
extends MessageReceiver {
    private List<Message> messages = new LinkedList<Message>();
    private Map<Message, Message> map = new HashMap<Message, Message>();
    private int errorCount = 0;

    @Override
    public int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    private static URI getURI(EObject object) {
        URI result = null;
        if (object instanceof InternalEObject) {
            result = ((InternalEObject)object).eProxyURI();
            if (result != null) {
                result = result.trimFragment();
            }
        } else if (object != null) {
            if (object.eResource() != null) {
                result = object.eResource().getURI();
            }
            if (result == null) {
                result = ExpressionTranslator.getURI(object.eContainer());
            }
        }
        return result;
    }

    private Message errorImpl(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        Message msg = new Message(message, Status.ERROR, cause, causeFeature, code);
        this.messages.add(msg);
        ++this.errorCount;
        return msg;
    }

    private Message warningImpl(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        Message msg = new Message(message, Status.WARNING, cause, causeFeature, code);
        this.messages.add(msg);
        return msg;
    }

    @Override
    public void error(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        this.errorImpl(message, cause, causeFeature, code);
    }

    @Override
    public void warning(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        this.warningImpl(message, cause, causeFeature, code);
    }

    @Override
    public void collect(IMessage message, EObject cause, EStructuralFeature causeFeature, int code) {
        Message msg = null;
        switch (message.getStatus()) {
            case ERROR: {
                msg = this.errorImpl(message.getDescription(), cause, causeFeature, code);
                break;
            }
            case WARNING: {
                msg = this.warningImpl(message.getDescription(), cause, causeFeature, code);
                break;
            }
            default: {
                msg = null;
            }
        }
        if (msg != null && message instanceof Message) {
            Message orig = (Message)message;
            this.map.put(orig, msg);
        }
    }

    @Override
    public void error(Resource.Diagnostic diagnostic) {
        this.error(diagnostic.getMessage() + " in line " + diagnostic.getLine(), null, null, 20211);
    }

    @Override
    public void addMessage(Message msg) {
        this.messages.add(msg);
        if (msg.getStatus() == Status.ERROR) {
            ++this.errorCount;
        }
    }

    public void clearMessages(ModelInfo<?> info) {
        this.clearMessages(info.getLocation());
    }

    public void clearMessages(java.net.URI uri) {
        if (uri != null) {
            Iterator<Object> iter;
            if (!this.messages.isEmpty()) {
                iter = this.messages.iterator();
                while (iter.hasNext()) {
                    Message msg = iter.next();
                    EObject cause = msg.getCause();
                    if (!ExpressionTranslator.sameURIs(uri, cause)) continue;
                    iter.remove();
                }
            }
            if (!this.map.isEmpty()) {
                iter = this.map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry ent = (Map.Entry)iter.next();
                    Message original = (Message)((Object)ent.getKey());
                    if (!ExpressionTranslator.sameURIs(uri, original.getCause())) continue;
                    this.messages.remove(ent.getValue());
                    iter.remove();
                }
            }
        }
    }

    private static boolean sameURIs(java.net.URI uri, EObject cause) {
        URI cUri;
        boolean same = false;
        if (cause != null && (cUri = ExpressionTranslator.getURI(cause)) != null) {
            String u1 = uri.toString();
            String u2 = cUri.toString();
            same = u1.equals(u2);
        }
        return same;
    }
}

