/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;

public class TopLevelModelAccessor {
    private static final Map<String, IModelAccessor<?>> ACCESSORS = new HashMap();

    private TopLevelModelAccessor() {
    }

    public static void register(String extension, IModelAccessor<?> accessor) {
        if (extension != null && accessor != null) {
            ACCESSORS.put(extension, accessor);
        }
    }

    public static void unregister(String extension) {
        if (extension != null) {
            ACCESSORS.remove(extension);
        }
    }

    public static Iterable<IModelAccessor<?>> registered() {
        return ACCESSORS.values();
    }

    public static int getRegisteredCount() {
        return ACCESSORS.size();
    }

    public static IModelAccessor<?> getAccessor(String extension) {
        return extension == null ? null : ACCESSORS.get(extension);
    }

    public static ModelInfo<?> getTopLevelModel(String extension, String projectName, Object project) {
        IModelAccessor<?> accessor = TopLevelModelAccessor.getAccessor(extension);
        return accessor == null ? null : accessor.getModelInfo(projectName, project);
    }

    public static void registerLoader(ProgressObserver observer, boolean failOnFirst) throws ModelManagementException {
        ModelManagementException ex = null;
        for (IModelAccessor<?> m : TopLevelModelAccessor.registered()) {
            try {
                m.registerLoader(observer);
            }
            catch (ModelManagementException e) {
                if (failOnFirst) {
                    throw e;
                }
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void unregisterLoader(ProgressObserver observer, boolean failOnFirst) throws ModelManagementException {
        ModelManagementException ex = null;
        for (IModelAccessor<?> m : TopLevelModelAccessor.registered()) {
            try {
                m.unregisterLoader(observer);
            }
            catch (ModelManagementException e) {
                if (failOnFirst) {
                    throw e;
                }
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void addLocation(File location, ProgressObserver observer, boolean failOnFirst) throws ModelManagementException {
        ModelManagementException ex = null;
        for (IModelAccessor<?> m : TopLevelModelAccessor.registered()) {
            try {
                m.addLocation(location, observer);
            }
            catch (ModelManagementException e) {
                if (failOnFirst) {
                    throw e;
                }
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void removeLocation(File location, ProgressObserver observer, boolean failOnFirst) throws ModelManagementException {
        ModelManagementException ex = null;
        for (IModelAccessor<?> m : TopLevelModelAccessor.registered()) {
            try {
                m.removeLocation(location, observer);
            }
            catch (ModelManagementException e) {
                if (failOnFirst) {
                    throw e;
                }
                if (ex != null) continue;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static abstract class AbstractDefaultModelAccessor<M extends IModel>
    implements IModelAccessor<M> {
        @Override
        public void registerLoader(ProgressObserver observer) throws ModelManagementException {
        }

        @Override
        public void unregisterLoader(ProgressObserver observer) throws ModelManagementException {
        }

        @Override
        public void addLocation(File location, ProgressObserver observer) throws ModelManagementException {
        }

        @Override
        public void removeLocation(File location, ProgressObserver observer) throws ModelManagementException {
        }
    }

    public static abstract class AbstractModelAccessor<M extends IModel>
    extends AbstractDefaultModelAccessor<M> {
        private IModelLoader<M> loader;

        protected AbstractModelAccessor(IModelLoader<M> loader) {
            this.loader = loader;
        }

        @Override
        public void registerLoader(ProgressObserver observer) throws ModelManagementException {
            this.getModelManagement().loaders().registerLoader(this.loader, observer);
        }

        @Override
        public void unregisterLoader(ProgressObserver observer) throws ModelManagementException {
            this.getModelManagement().loaders().unregisterLoader(this.loader, observer);
        }

        @Override
        public void addLocation(File location, ProgressObserver observer) throws ModelManagementException {
            this.getModelManagement().locations().addLocation(location, observer);
        }

        @Override
        public void removeLocation(File location, ProgressObserver observer) throws ModelManagementException {
            this.getModelManagement().locations().removeLocation(location, observer);
        }
    }

    public static interface IModelAccessor<M extends IModel> {
        public ModelInfo<M> getModelInfo(String var1, Object var2);

        public ModelManagement<M> getModelManagement();

        public void registerLoader(ProgressObserver var1) throws ModelManagementException;

        public void unregisterLoader(ProgressObserver var1) throws ModelManagementException;

        public void addLocation(File var1, ProgressObserver var2) throws ModelManagementException;

        public void removeLocation(File var1, ProgressObserver var2) throws ModelManagementException;

        public String getPathKindHint();
    }
}

