/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore;

import com.google.inject.Injector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.dslCore.IResourceInitializer;
import net.ssehub.easy.dslCore.StandaloneInitializer;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.parser.BaseEPackageAccess;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResourceSet;

public abstract class ModelUtility<E extends EObject, R extends IModel>
implements IModelLoader<R> {
    private static IResourceInitializer resourceInitializer;
    private static List<ModelUtility<?, ?>> instances;
    private static final List<ModelUtility<?, ?>> SCHEDULED;
    private static boolean forceUnloadOnParse;
    private Map<Thread, Set<String>> beingLoaded = Collections.synchronizedMap(new HashMap());
    private XtextResourceSet resourceSet;
    private Injector injector;
    private Grammar grammar;

    static {
        instances = Collections.synchronizedList(new ArrayList());
        SCHEDULED = Collections.synchronizedList(new ArrayList());
        forceUnloadOnParse = false;
        EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(ModelUtility.class, "net.ssehub.easy.dslCore");
        logger.info("Setting up Standalone resource initializer");
        resourceInitializer = new StandaloneInitializer();
    }

    protected ModelUtility() {
        if (resourceInitializer != null) {
            this.initializeAfterResourceInitializer();
        } else {
            SCHEDULED.add(this);
        }
        instances.add(this);
    }

    public static boolean forceUnloadOnParse(boolean force) {
        boolean old = forceUnloadOnParse;
        forceUnloadOnParse = force;
        return old;
    }

    public static Iterable<ModelUtility<?, ?>> instances() {
        return instances;
    }

    public static void setResourceInitializer(IResourceInitializer initializer) {
        resourceInitializer = initializer;
        if (resourceInitializer != null) {
            int i = 0;
            while (i < SCHEDULED.size()) {
                SCHEDULED.get(i).initializeAfterResourceInitializer();
                ++i;
            }
            SCHEDULED.clear();
        }
    }

    protected abstract void initializeAfterResourceInitializer();

    public static IResourceInitializer getResourceInitializer() {
        return resourceInitializer;
    }

    public static final java.net.URI toNetUri(URI uri) throws URISyntaxException {
        java.net.URI result = null;
        if (resourceInitializer != null) {
            result = resourceInitializer.toNetUri(uri);
        }
        return result;
    }

    public XtextResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = ModelUtility.getResourceInitializer().createResourceSet(this.getInjector());
        }
        return this.resourceSet;
    }

    public Injector getInjector() {
        return this.injector;
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    public TranslationResult<R> parse(File file) throws IOException {
        if (file.exists()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            return this.parse(uri);
        }
        throw new FileNotFoundException(file.toString());
    }

    public TranslationResult<R> parse(URI uri) throws IOException {
        return this.parse(uri, null);
    }

    public abstract TranslationResult<R> parse(URI var1, ImportResolver<R> var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Grammar getGrammar() {
        if (this.grammar != null) return this.grammar;
        XtextResourceSet resourceSet = this.getResourceSet();
        XtextPackage.eINSTANCE.getClass();
        Class<ModelUtility> clazz = ModelUtility.class;
        synchronized (ModelUtility.class) {
            resourceSet.setClasspathURIContext((Object)this.getLanguageClassLoader());
            this.grammar = (Grammar)BaseEPackageAccess.loadGrammarFile((String)("classpath:/" + this.getLanguageName().replace('.', '/') + ".xtextbin"), (XtextResourceSet)resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.grammar;
        }
    }

    protected abstract String getLanguageName();

    protected abstract ClassLoader getLanguageClassLoader();

    protected IParseResult parseFragment(String ruleName, String input) {
        AbstractRule rule;
        IParseResult result = null;
        Grammar grammar = this.getGrammar();
        if (grammar != null && (rule = GrammarUtil.findRuleForName((Grammar)grammar, (String)ruleName)) instanceof ParserRule) {
            IParser parser = (IParser)this.getInjector().getInstance(IParser.class);
            result = parser.parse((ParserRule)rule, (Reader)new StringReader(input));
        }
        return result;
    }

    public static StringBuilder append(StringBuilder builder, String text, String separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        builder.append(text);
        return builder;
    }

    public static StringBuilder appendWithNewLine(StringBuilder builder, String text) {
        return ModelUtility.append(builder, text, "\n");
    }

    protected E parse(URI uri, boolean unload, MessageReceiver receiver, Class<E> cls) throws IOException {
        EObject result = null;
        try {
            XtextResourceSet resourceSet = this.getResourceSet();
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null) {
                resource = resourceSet.createResource(uri);
            } else {
                resource.unload();
            }
            resource.load(null);
            if (resource.isLoaded()) {
                boolean hasErrors = false;
                for (Resource.Diagnostic diag : resource.getErrors()) {
                    if (receiver != null) {
                        receiver.error(diag);
                    }
                    hasErrors = true;
                }
                EObject rootObject = null;
                if (!hasErrors) {
                    rootObject = (EObject)resource.getContents().get(0);
                }
                if (cls.isInstance(rootObject)) {
                    result = (EObject)cls.cast(rootObject);
                }
            } else {
                throw new IOException("resource for uri '" + String.valueOf(uri) + "' not loaded");
            }
            if (unload || forceUnloadOnParse) {
                resource.unload();
            }
        }
        catch (Throwable t) {
            EASyLoggerFactory.INSTANCE.getLogger(ModelUtility.class, "net.ssehub.easy.dslCore").warn("While loading resource " + String.valueOf(uri) + ": " + t.getMessage());
            t.printStackTrace();
        }
        return (E)result;
    }

    protected boolean handles(File location) {
        return location.isFile() && location.getName().endsWith("." + this.getExtension());
    }

    public void scan(File location, IModelLoader.IModelInfoHolder<R> holder) {
        if (this.handles(location) && !holder.isKnown(location.toURI(), (IModelLoader)this)) {
            try {
                List<ModelInfo<R>> info = this.obtainInfo(location);
                if (info != null) {
                    int i = 0;
                    while (i < info.size()) {
                        holder.addResult(info.get(i));
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                holder.error(e.getMessage());
            }
        }
    }

    public List<ModelInfo<R>> obtainInfo(File file) throws IOException {
        if (file.exists()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            return this.obtainInfo(uri);
        }
        throw new FileNotFoundException(file.toString());
    }

    public abstract List<ModelInfo<R>> obtainInfo(URI var1) throws IOException;

    public abstract ModelInfo<R> getInfo(java.net.URI var1);

    public ModelInfo<R> getInfo(URI uri) {
        try {
            return this.getInfo(ModelUtility.toNetUri(uri));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public IModelLoader.LoadResult<R> load(ModelInfo<R> info, ImportResolver<R> resolver) {
        List<R> models = null;
        List<Object> messages = null;
        if (info != null) {
            String location = info.getLocation().toString();
            Thread currentThread = Thread.currentThread();
            Set<String> beingLoadedInThread = this.beingLoaded.get(currentThread);
            if (beingLoadedInThread == null) {
                beingLoadedInThread = new HashSet<String>();
                this.beingLoaded.put(currentThread, beingLoadedInThread);
            }
            if (!beingLoadedInThread.contains(location)) {
                block5: {
                    beingLoadedInThread.add(location);
                    try {
                        TranslationResult<R> parseResult = this.parse(URI.createURI((String)location), resolver);
                        models = parseResult.getResultsList();
                        messages = parseResult.getMessageList();
                    }
                    catch (IOException e) {
                        if (messages != null) break block5;
                        messages = new ArrayList<Message>();
                        messages.add(new Message(e.getMessage(), Status.ERROR));
                    }
                }
                beingLoadedInThread.remove(location);
            }
        }
        return new IModelLoader.LoadResult(models, messages);
    }

    public abstract String getExtension();

    public void validate(Resource resource, Consumer<MessageReceiver> messageHandler) {
        try {
            TranslationResult<R> res = this.parse(resource.getURI());
            messageHandler.accept(res.getReceiver());
        }
        catch (IOException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.dslCore").exception((Exception)e);
        }
    }
}

