/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.test.StringWithPosition;
import net.ssehub.easy.dslCore.translation.Message;

public abstract class AbstractTest<R extends IModel> {
    protected static final ProgressObserver OBSERVER = ProgressObserver.NO_OBSERVER;

    protected static void resourceInitialization() {
    }

    public static File determineTestDataDir(String property) {
        File result = null;
        String externalLocation = System.getProperty(property);
        if (externalLocation == null) {
            File f = new File("testdata.dir");
            if (f.exists()) {
                try {
                    result = new File(new String(Files.readAllBytes(f.toPath())).trim());
                }
                catch (IOException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(AbstractTest.class, null).warn("Failed reading testdata.dir: " + e.getMessage());
                }
            }
            if (result == null) {
                result = new File("testdata");
            }
        } else {
            result = new File(externalLocation);
        }
        return result;
    }

    protected String checkErrorCodes(TranslationResult<R> result, List<Message> warnings, int ... expectedErrorCodes) {
        return this.checkErrorCodes(result.getMessageListSpecific(), warnings, expectedErrorCodes);
    }

    protected String checkErrorCodes(List<Message> messages, List<Message> warnings, int ... expectedErrorCodes) {
        HashSet<Integer> expectedErrors = new HashSet<Integer>();
        HashMap<Integer, String> actualErrors = new HashMap<Integer, String>();
        if (expectedErrorCodes != null) {
            int i = 0;
            while (i < expectedErrorCodes.length) {
                expectedErrors.add(expectedErrorCodes[i]);
                ++i;
            }
        }
        int size = 0;
        if (messages != null) {
            size = messages.size();
        }
        int i = 0;
        while (i < size) {
            Message msg = messages.get(i);
            if (!msg.ignore()) {
                if (Status.ERROR == msg.getStatus()) {
                    int code = msg.getCode();
                    actualErrors.put(code, msg.getDescription());
                    expectedErrors.remove(code);
                } else if (Status.WARNING == msg.getStatus() && warnings != null) {
                    warnings.add(msg);
                }
            }
            ++i;
        }
        if (expectedErrorCodes != null) {
            i = 0;
            while (i < expectedErrorCodes.length) {
                actualErrors.remove(expectedErrorCodes[i]);
                ++i;
            }
        }
        Object result = null;
        if (!actualErrors.isEmpty()) {
            result = "unexpected errors: ";
            Iterator iter = actualErrors.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                result = (String)result + (String)entry.getValue() + "(" + String.valueOf(entry.getKey()) + ")";
                if (!iter.hasNext()) continue;
                result = (String)result + ", ";
            }
        }
        if (!expectedErrors.isEmpty()) {
            result = result == null ? "" : (String)result + " ";
            result = (String)result + "expected error codes which did not occur (in the right amount): " + String.valueOf(expectedErrors);
        }
        return result;
    }

    protected String file2String(File file) throws IOException {
        String fileAsString = null;
        try (FileInputStream stream = new FileInputStream(file);){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            fileAsString = Charset.defaultCharset().decode(bb).toString();
            fc.close();
        }
        return fileAsString;
    }

    private static final boolean isLineEnd(Character ch) {
        return ch.charValue() == '\n' || ch.charValue() == '\r';
    }

    private static final boolean isWhitespaceButNotLineEnd(Character ch) {
        return Character.isWhitespace(ch.charValue()) && !AbstractTest.isLineEnd(ch);
    }

    protected int isEqual(String fileAsString, String modelAsString) {
        StringWithPosition file = new StringWithPosition(fileAsString);
        StringWithPosition model = new StringWithPosition(modelAsString);
        boolean ok = true;
        if (file.inRange() ^ model.inRange()) {
            ok = false;
        }
        boolean continueNextLine = false;
        while (ok && file.inRange() && model.inRange()) {
            if (file.at() == '/' && (!file.inRange(-1) || Character.isWhitespace(file.at(-1)))) {
                if (file.inRange(3) && '/' == file.at(1) && '*' == file.at(2)) {
                    file.inc(3);
                    ok = this.handleReplacementComment(file, model);
                } else if (file.inRange(3) && '/' == file.at(1) && '*' != file.at(2)) {
                    file.consumeLine();
                    continueNextLine = true;
                }
            }
            if (!continueNextLine) {
                if (file.at() != model.at()) {
                    ok = this.handleWindowsLinuxLineEnd(file, model);
                }
                file.inc();
                model.inc();
                continue;
            }
            continueNextLine = false;
        }
        int result = ok && (model.inRange() || file.inRange()) ? -1 : (ok ? fileAsString.length() + 1 : file.pos());
        return result;
    }

    private boolean handleWindowsLinuxLineEnd(StringWithPosition s1, StringWithPosition s2) {
        boolean ok = false;
        char cf = s1.at();
        char cm = s2.at();
        if (cf == '\n' && cm == '\r') {
            if (s2.inRange(1) && '\n' == s2.at(1)) {
                ok = true;
                s2.inc();
            }
        } else if (cf == '\r' && cm == '\n' && s1.inRange(1) && '\n' == s1.at(1)) {
            ok = true;
            s1.inc();
        }
        return ok;
    }

    private boolean handleReplacementComment(StringWithPosition expected, StringWithPosition actual) {
        boolean ok = true;
        while (expected.inRange()) {
            if (!AbstractTest.isWhitespaceButNotLineEnd(Character.valueOf(expected.at()))) break;
            expected.inc();
        }
        while (ok && expected.inRange() && actual.inRange()) {
            char mc;
            char fc = expected.at();
            if (fc == (mc = actual.at())) {
                if (AbstractTest.isLineEnd(Character.valueOf(fc))) break;
                expected.inc();
                actual.inc();
                continue;
            }
            if (fc == '\n' && mc == '\r' && actual.inRange(1) && actual.at(1) == '\n') {
                actual.inc();
                break;
            }
            if (fc == '\r' && mc == '\n' && expected.inRange(1) && expected.at(1) == '\n') {
                expected.inc();
                break;
            }
            ok = false;
        }
        expected.consumeLineEnd();
        actual.consumeLineEnd();
        while (expected.inRange() && !AbstractTest.isLineEnd(Character.valueOf(expected.at()))) {
            expected.inc();
        }
        expected.consumeLineEnd();
        return ok;
    }

    protected boolean checkEqualsAndPrint(String fileAsString, String modelAsString) {
        return this.checkEqualsAndPrint(fileAsString, modelAsString, new PrintWriter(System.out));
    }

    protected boolean checkEqualsAndPrint(String fileAsString, String modelAsString, PrintWriter writer) {
        boolean equals = true;
        int pos = this.isEqual(fileAsString, modelAsString);
        if (pos < 0 || pos <= fileAsString.length() || fileAsString.length() == 0 && modelAsString.length() > 0) {
            if (pos > 0) {
                writer.println(fileAsString.substring(0, pos));
            }
            writer.println();
            writer.println("FILE: ");
            writer.println(fileAsString.replace("\n", "\n[LF]").replace("\r", "[CR]").replace("\t", "[TAB]"));
            writer.println("MODEL: ");
            writer.println(modelAsString.replace("\n", "\n[LF]").replace("\r", "[CR]").replace("\t", "[TAB]"));
            writer.println();
            if (pos < 0) {
                writer.println("Error: Model contains more data than the file.");
            } else if (fileAsString.length() == 0 && modelAsString.length() > 0) {
                writer.println("Error: File is empty, but model contains data.");
            } else if (pos <= fileAsString.length()) {
                writer.println("Error in file at index (1 - " + (fileAsString.length() + 1) + "): " + (pos + 1));
                int start = Math.max(0, pos - 5);
                int end = Math.min(pos + 5, fileAsString.length());
                String excerpt = fileAsString.substring(start, end).replace("\n", "[LF]").replace("\r", "[CR]");
                excerpt = excerpt.replace("\t", "[TAB]");
                writer.println("Excerpt (+/- 5 chars): " + excerpt);
            }
            writer.println("--");
            equals = false;
        }
        return equals;
    }

    protected String checkEqualsAndPrepareMessage(String fileAsString, Writer model) throws IOException {
        return this.checkEqualsAndPrepareMessage(fileAsString, model, true);
    }

    protected String checkEqualsAndPrepareMessage(String fileAsString, Writer model, boolean trimModel) throws IOException {
        String modelAsString = model.toString();
        if (trimModel) {
            fileAsString = fileAsString.trim();
            modelAsString = modelAsString.trim();
        } else {
            StringBuilder tmp = new StringBuilder(modelAsString);
            while (tmp.length() > 0 && Character.isWhitespace(tmp.charAt(tmp.length() - 1))) {
                tmp.deleteCharAt(tmp.length() - 1);
            }
            modelAsString = tmp.toString();
        }
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        boolean equal = this.checkEqualsAndPrint(fileAsString, modelAsString, pWriter);
        pWriter.flush();
        sWriter.flush();
        String errorMsg = equal ? null : "comparison failed:\n" + sWriter.toString();
        pWriter.close();
        sWriter.close();
        return errorMsg;
    }

    protected static String checkWarnings(List<Message> warnings, int ... expectedWarnings) {
        String result = null;
        if (warnings != null && expectedWarnings.length > 0) {
            StringBuilder tmp = new StringBuilder();
            ArrayList<Message> tmpWarning = new ArrayList<Message>();
            tmpWarning.addAll(warnings);
            int e = 0;
            while (e < expectedWarnings.length) {
                boolean found = false;
                int w = 0;
                while (!found && w < tmpWarning.size()) {
                    found = ((Message)((Object)tmpWarning.get(w))).getCode() == expectedWarnings[e];
                    ++w;
                }
                if (!found) {
                    if (tmp.length() > 0) {
                        tmp.append(", ");
                    }
                    tmp.append(expectedWarnings[e]);
                }
                ++e;
            }
            if (tmp.length() > 0) {
                result = "missing warning codes: " + String.valueOf(tmp);
            }
        }
        return result;
    }

    protected String assertNamingAndVersion(EqualitySetup<R> data, TranslationResult<R> result) {
        String message = null;
        if (data.expectedName != null) {
            boolean found = false;
            int r = 0;
            while (!found && r < result.getResultCount()) {
                IModel script = (IModel)result.getResult(r);
                if (script.getName().equals(data.expectedName)) {
                    found = data.expectedVersion != null ? Version.toString((Version)script.getVersion()).equals(data.expectedVersion) : true;
                }
                ++r;
            }
            if (!found) {
                message = "does not contain " + data.expectedName + (String)(data.expectedVersion == null ? "" : " " + data.expectedVersion);
            }
        }
        return message;
    }

    public static String toString(List<Message> messages) {
        StringBuilder result = new StringBuilder();
        if (messages != null && !messages.isEmpty()) {
            int m = 0;
            while (m < messages.size()) {
                if (m > 0) {
                    result.append(", ");
                }
                result.append(messages.get(m).getDescription());
                ++m;
            }
        }
        return result.toString();
    }

    protected static class EqualitySetup<R extends IModel> {
        private File file;
        private String expectedName;
        private String expectedVersion;
        private String startElement = "main";
        private File expectedTrace;
        private Map<String, Object> parameter;
        private File expectedOutputFile;
        private boolean enableEquals = true;
        private Integer expectedFailCode;
        private String expectedFailReason;
        private R model;

        public EqualitySetup(File file, String expectedName, String expectedVersion) {
            this(file, expectedName, expectedVersion, null, new HashMap<String, Object>());
        }

        public EqualitySetup(File file, String expectedName, String expectedVersion, File expectedTrace) {
            this(file, expectedName, expectedVersion, expectedTrace, new HashMap<String, Object>());
        }

        public EqualitySetup(File file, String expectedName, String expectedVersion, File expectedTrace, Map<String, Object> parameter) {
            this.file = file;
            this.expectedName = expectedName;
            this.expectedVersion = expectedVersion;
            this.expectedTrace = expectedTrace;
            this.parameter = parameter;
        }

        public void setModel(R model) {
            this.model = model;
        }

        public R getModel() {
            return this.model;
        }

        public File getFile() {
            return this.file;
        }

        public String getExpectedName() {
            return this.expectedName;
        }

        public String getExpectedVersion() {
            return this.expectedVersion;
        }

        public File getExpectedTrace() {
            return this.expectedTrace;
        }

        public Map<String, Object> getParameter() {
            return this.parameter;
        }

        public String getStartElement() {
            return this.startElement;
        }

        public void setStartElement(String startElement) {
            this.startElement = startElement;
        }

        public File getExpectedOutputFile() {
            return this.expectedOutputFile;
        }

        public void setExpectedOutputFile(File expectedOutputFile) {
            this.expectedOutputFile = expectedOutputFile;
        }

        public boolean enableEquals() {
            return this.enableEquals;
        }

        public void setEnableEquals(boolean enableEquals) {
            this.enableEquals = enableEquals;
        }

        public void setExpectedFailReason(String failReason) {
            this.expectedFailReason = failReason;
        }

        public String getExpectedFailReason() {
            return this.expectedFailReason;
        }

        public void setExpectedFailCode(Integer failCode) {
            this.expectedFailCode = failCode;
        }

        public Integer getExpectedFailCode() {
            return this.expectedFailCode;
        }
    }
}

