/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.dslCore.translation;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class LogMessageReceiver
extends MessageReceiver {
    private EASyLoggerFactory.EASyLogger logger;
    private URI locationHint;

    public LogMessageReceiver(Class<?> origin, String bundleName) {
        this.logger = EASyLoggerFactory.INSTANCE.getLogger(origin, bundleName);
    }

    @Override
    public void error(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        this.logger.error(message + " in " + this.getLocation(null));
    }

    @Override
    public void warning(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        this.logger.warn(message + " in " + this.getLocation(null));
    }

    @Override
    public void collect(IMessage message, EObject cause, EStructuralFeature causeFeature, int code) {
    }

    @Override
    public int getMessageCount() {
        return 0;
    }

    @Override
    public int getErrorCount() {
        return 0;
    }

    @Override
    public Message getMessage(int index) {
        return null;
    }

    @Override
    public void error(Resource.Diagnostic diagnostic) {
        this.logger.error(diagnostic.getMessage() + " in " + this.getLocation(diagnostic) + " line " + diagnostic.getLine() + " col " + diagnostic.getColumn());
    }

    private String getLocation(Resource.Diagnostic diagnostic) {
        String location;
        String string = location = diagnostic == null ? null : diagnostic.getLocation();
        if (location == null && this.locationHint != null) {
            location = this.locationHint.toString();
        }
        return location;
    }

    public void setLocationHint(URI locationHint) {
        this.locationHint = locationHint;
    }

    @Override
    public void addMessage(Message msg) {
    }
}

