/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.integration.common.eclipse;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.integration.common.IModelInfo;
import net.ssehub.easy.integration.common.ModelException;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.PersistenceUtils;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public abstract class IModelAccess
extends net.ssehub.easy.integration.common.IModelAccess {
    public static IPath absoluteToWorkspaceRoot(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(path);
    }

    public IModelInfo getMostRecentTopLevelModel(IProject project) {
        return IModelAccess.getMostRecentModel(this.getAvailableModels(project));
    }

    public List<IModelInfo> getTopLevelModels(IProject project) {
        String projectName = project.getName();
        List<IModelInfo> result = this.getAvailableModels(project);
        int r = result.size() - 1;
        while (r > 0) {
            IModelInfo info = result.get(r);
            if (!info.getName().equals(projectName)) {
                result.remove(r);
            }
            --r;
        }
        return result;
    }

    public List<IModelInfo> getAvailableModels(IProject project) {
        ArrayList<IModelInfo> result = new ArrayList<IModelInfo>();
        if (project.exists()) {
            IFolder folder = PersistenceUtils.getLocationFolder((IProject)project, (Configuration.PathKind)Configuration.PathKind.IVML);
            IPath folderPath = !folder.exists() ? project.getFullPath() : folder.getFullPath();
            URI uri = IModelAccess.absoluteToWorkspaceRoot(folderPath).toFile().toURI();
            List pResult = VarModel.INSTANCE.availableModels().getVisibleModelInfo(uri);
            int count = pResult.size();
            int p = 0;
            while (p < count) {
                result.add(this.createInfo((ModelInfo)pResult.get(p), this));
                ++p;
            }
        }
        return result;
    }

    protected Project obtainProject(IModelInfo info) throws ModelException {
        this.checkInfo(info);
        try {
            return (Project)VarModel.INSTANCE.load(this.getInfo(info));
        }
        catch (ModelManagementException e) {
            throw new ModelException(e.getMessage());
        }
    }

    public void updateModelInfo(IProject project) throws ModelException {
        File file = IModelAccess.absoluteToWorkspaceRoot(project.getFullPath()).toFile();
        try {
            VarModel.INSTANCE.updateModelInformation(file, ProgressObserver.NO_OBSERVER);
        }
        catch (ModelManagementException e) {
            throw new ModelException((Throwable)e);
        }
    }
}

