/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class NatureUtils {
    private static Predicate<String> natureFilter = n -> true;

    private NatureUtils() {
    }

    public static boolean hasNature(IProject project, String ... natures) throws CoreException {
        boolean found = false;
        IProjectDescription description = project.getDescription();
        String[] pNatures = description.getNatureIds();
        int i = 0;
        while (!found && i < pNatures.length) {
            int j = 0;
            while (!found && j < natures.length) {
                found = natureFilter.test(natures[j]) ? pNatures[i].equals(natures[j]) : true;
                ++j;
            }
            ++i;
        }
        return found;
    }

    public static void ensureBuilder(IProject project, String includeBuilder, String excludeBuilder, IProgressMonitor monitor) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] buildSpec = projectDescription.getBuildSpec();
        ArrayList<ICommand> list = new ArrayList<ICommand>(Arrays.asList(buildSpec));
        boolean found = false;
        int b = list.size() - 1;
        while (b >= 0) {
            ICommand c = (ICommand)list.get(b);
            if (c.getBuilderName().equals(excludeBuilder)) {
                list.remove(b);
            } else if (c.getBuilderName().equals(includeBuilder)) {
                found = true;
            }
            --b;
        }
        if (!found && includeBuilder != null) {
            ICommand command = projectDescription.newCommand();
            command.setBuilderName(includeBuilder);
            list.add(command);
        }
        projectDescription.setBuildSpec(list.toArray(new ICommand[list.size()]));
        project.setDescription(projectDescription, monitor);
    }

    public static void addNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (natureFilter.test(nature)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = nature;
            description.setNatureIds(newNatures);
            if (project == null || !project.isOpen()) {
                throw new RuntimeException("Project not running");
            }
            project.setDescription(description, monitor);
        }
    }

    public static void removeNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (natureFilter.test(nature)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (nature.equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, monitor);
                    return;
                }
                ++i;
            }
        }
    }

    public static void setNatureFilter(Predicate<String> filter) {
        if (filter != null) {
            natureFilter = filter;
        }
    }
}

