/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class PathEnvironmentFactory {
    private static List<IProjectHandler> handlers = new ArrayList<IProjectHandler>();

    private PathEnvironmentFactory() {
    }

    public static void registerHandler(IProjectHandler handler) {
        if (handler != null && !handlers.contains(handler)) {
            handlers.add(handler);
        }
    }

    public static void unregisterHandler(IProjectHandler handler) {
        if (handler != null) {
            handlers.remove(handler);
        }
    }

    public static PathEnvironment createPathEnvironment(IProject project) {
        IPath projectLocation = project != null ? project.getLocation() : null;
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        PathEnvironment pathEnv = null;
        pathEnv = projectLocation != null && !workspaceLocation.isPrefixOf(projectLocation) ? new PathEnvironment(projectLocation.removeLastSegments(1).toFile()) : new PathEnvironment(EclipsePersistencer.WORKSPACE_FOLDER);
        PathEnvironmentFactory.updatePathEnvironment(pathEnv, project);
        return pathEnv;
    }

    public static void updatePathEnvironment(PathEnvironment pathEnv, IProject project) {
        pathEnv.clear();
        if (project != null) {
            int h = 0;
            while (h < handlers.size()) {
                handlers.get(h).addPaths(project, pathEnv);
                ++h;
            }
        }
    }

    public static interface IProjectHandler {
        public void addPaths(IProject var1, PathEnvironment var2);
    }
}

