/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.project_creation;

import java.util.UUID;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.IEclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

abstract class AbstractProjectCreator {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(AbstractProjectCreator.class, "net.ssehub.easy.producer.eclipse");
    private ProductLineProject newPLP;
    private String projectName;
    private EclipsePersistencer persistencer;
    private IProject project;
    private boolean lazy;
    private IEASyProjectConfigurator[] configurators;

    protected AbstractProjectCreator(String projectName, boolean lazy, IEASyProjectConfigurator ... configurators) {
        this.projectName = projectName;
        this.lazy = lazy;
        this.configurators = configurators;
        this.persistencer = new EclipsePersistencer(projectName, null, null);
        this.project = null;
    }

    protected final ProductLineProject getCreatedProject() {
        return this.newPLP;
    }

    protected final boolean isLazyCreation() {
        return this.lazy;
    }

    protected final void createProject() {
        this.createNewEASyProject();
        if (!this.lazy) {
            this.configureProject();
        }
    }

    private void configureProject() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask("Create Java Project", 10);
        if (this.project != null) {
            block14: {
                try {
                    try {
                        if (!this.project.exists()) {
                            IProjectDescription desc = this.project.getWorkspace().newProjectDescription(this.project.getName());
                            desc.setLocationURI(null);
                            this.project.create(desc, (IProgressMonitor)monitor);
                            monitor = null;
                        }
                        if (!this.project.isOpen()) {
                            this.project.open((IProgressMonitor)monitor);
                            monitor = null;
                        }
                    }
                    catch (CoreException e) {
                        LOGGER.exception((Exception)((Object)e));
                        if (monitor != null) {
                            monitor.done();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw throwable;
                }
                if (monitor != null) {
                    monitor.done();
                }
            }
            if (this.configurators != null) {
                IEASyProjectConfigurator[] iEASyProjectConfiguratorArray = this.configurators;
                int n = this.configurators.length;
                int n2 = 0;
                while (n2 < n) {
                    IEASyProjectConfigurator configurator = iEASyProjectConfiguratorArray[n2];
                    if (configurator != null) {
                        this.configureProject(this.project, configurator);
                    }
                    ++n2;
                }
            }
        }
    }

    protected abstract void configureProject(IProject var1, IEASyProjectConfigurator var2);

    private void createNewEASyProject() {
        String projectID = UUID.randomUUID().toString();
        IEclipseProjectCreationResult result = null;
        try {
            result = this.persistencer.createEASyProject(projectID, this.lazy, new String[0]);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (result != null) {
            this.project = result.getIProject();
            if (result.getProjectID() != null) {
                this.newPLP = (ProductLineProject)SPLsManager.INSTANCE.getPLP(projectID);
            }
            if (this.newPLP == null && result.getVarModel() != null) {
                this.newPLP = new EASyPersistencer(result.getProjectFolder()).populateEasyProject(projectID, this.projectName, result.getProjectFolder(), result.getVarModel());
            }
        }
    }

    protected final void setPersistenceProperties() {
        if (this.project != null) {
            QualifiedName qname = new QualifiedName("de.uni-hildesheim.sse.easy_producer.projectuuid", "projectid");
            try {
                this.project.setPersistentProperty(qname, this.newPLP.getProjectID());
                EASyPersistencer.refreshModels((PLPInfo)this.newPLP);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    abstract ProductLineProject createEASyProject();
}

