/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.observer;

import net.ssehub.easy.basics.progress.BasicProgressObserver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class EclipseProgressObserver
extends BasicProgressObserver {
    private MyProgressMonitor monitor;

    public void register(IProgressMonitor monitor) {
        this.monitor = new MyProgressMonitor(monitor);
        super.register((BasicProgressObserver.IProgressMonitor)this.monitor);
    }

    public void unregister(IProgressMonitor monitor) {
        if (this.monitor != null && this.monitor.getMonitor() == monitor) {
            super.unregister((BasicProgressObserver.IProgressMonitor)this.monitor);
            this.monitor = null;
        }
    }

    public IProgressMonitor getMonitor() {
        IProgressMonitor result = null;
        if (this.monitor != null) {
            result = this.monitor.getMonitor();
        }
        if (result == null) {
            result = new NullProgressMonitor();
        }
        return result;
    }

    private static class MyProgressMonitor
    implements BasicProgressObserver.IProgressMonitor {
        private IProgressMonitor monitor;

        private MyProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        private IProgressMonitor getMonitor() {
            return this.monitor;
        }

        public void setTaskName(String name) {
            this.monitor.setTaskName(name);
        }

        public void beginTask(String name, int max) {
            this.monitor.beginTask(name, max);
        }

        public void worked(int step) {
            this.monitor.worked(step);
        }

        public void subTask(String name) {
            this.monitor.subTask(name);
        }
    }
}

