/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.scenario_tests.AbstractEasyScenarioTest;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.sseReasoner.Reasoner;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConceptsTests
extends AbstractEasyScenarioTest {
    protected File getTestFolder() {
        return new File(this.getTestDataDir(), "concepts");
    }

    @Before
    public void startup() throws ModelManagementException {
        VarModel.INSTANCE.locations().addLocation(this.getIvmlFolder(), ProgressObserver.NO_OBSERVER);
    }

    @After
    public void end() throws ModelManagementException {
        VarModel.INSTANCE.locations().removeLocation(this.getIvmlFolder(), ProgressObserver.NO_OBSERVER);
    }

    private File getIvmlFolder() {
        return ConceptsTests.getIvmlFolderIn(this.getTestFolder());
    }

    @Test
    public void testMandatory1() {
        this.doConceptTest("Mandatory1", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory2() {
        this.doConceptTest("Mandatory2", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory2t() {
        this.doConceptTest("Mandatory2t", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory3() {
        this.doConceptTest("Mandatory3", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory3t() {
        this.doConceptTest("Mandatory3t", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory3s() {
        this.doConceptTest("Mandatory3s", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory3st() {
        this.doConceptTest("Mandatory3st", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory4() {
        this.doConceptTest("Mandatory4", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory4s() {
        this.doConceptTest("Mandatory4s", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory5() {
        this.doConceptTest("Mandatory5", this.createDefaultMandatoryExpected());
    }

    @Test
    public void testMandatory6() {
        this.doConceptTest("Mandatory6", this.createDefaultMandatoryExpected());
    }

    private Map<String, Object> createDefaultMandatoryExpected() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("var", Boolean.TRUE);
        return result;
    }

    @Test
    public void testMultiSelect1() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        HashSet<Integer> value = new HashSet<Integer>();
        value.add(1);
        value.add(2);
        value.add(3);
        expected.put("var", value);
        this.doConceptTest("MultiSelect1", expected);
    }

    @Test
    public void testMultiSelect1fail() {
        this.doConceptTest("MultiSelect1fail", false, null);
    }

    @Test
    public void testRelevancy1() throws ModelQueryException {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("c.gears.number", 4);
        expected.put("c.engine", NullValue.INSTANCE);
        Configuration config = this.doConceptTest("Relevancy1", expected);
        IDatatype engineType = ModelQuery.findType((IResolutionScope)config.getProject(), (String)"Engine", null);
        Assert.assertNotNull((String)"Engine type does not exist", (Object)engineType);
        Value inst = config.getAllInstances(engineType);
        if (inst instanceof ContainerValue) {
            Assert.assertEquals((String)"There shall be no Engine instances", (long)0L, (long)((ContainerValue)inst).getElementSize());
        }
    }

    @Test
    public void testRelevancy2() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("c.gears.number", 7);
        expected.put("c.engine", null);
        this.doConceptTest("Relevancy2", expected);
    }

    protected Configuration doConceptTest(String modelName, Map<String, Object> expected) {
        return this.doConceptTest(modelName, true, expected);
    }

    protected Configuration doConceptTest(String modelName, boolean success, Map<String, Object> expected) {
        ReasonerConfiguration rCfg = new ReasonerConfiguration();
        Project ivmlModel = ConceptsTests.obtainIvmlModel(modelName, null, this.getIvmlFolder());
        Configuration config = new Configuration(ivmlModel);
        ReasonerFrontend rf = ReasonerFrontend.getInstance();
        if (rf.getReasonersCount() == 0) {
            rf.getRegistry().register((IReasoner)new Reasoner());
        }
        ReasoningResult res = rf.propagate(config, rCfg, ProgressObserver.NO_OBSERVER);
        res.logInformation(ivmlModel, rCfg, debug);
        if (success) {
            Assert.assertFalse((String)("The configuration for " + modelName + " shall be free of conflicts"), (boolean)res.hasConflict());
        } else {
            Assert.assertTrue((String)("The configuration for " + modelName + " shall have conflicts"), (boolean)res.hasConflict());
        }
        if (success && expected != null) {
            try {
                for (Map.Entry<String, Object> ex : expected.entrySet()) {
                    String varName = ex.getKey();
                    IDecisionVariable var = config.getDecision(varName, true);
                    Assert.assertNotNull((String)("Expected variable " + varName + " is does not exist in configuaration"), (Object)var);
                    Value value = var.getValue();
                    if (ex.getValue() == null) {
                        Assert.assertEquals((String)("Variable " + varName + " is configured rather than unconfigured"), (Object)AssignmentState.UNDEFINED, (Object)var.getState());
                        continue;
                    }
                    Assert.assertNotNull((String)("Expected variable " + varName + " is not configured"), (Object)value);
                    AbstractCollection valueExpected = ex.getValue();
                    AbstractCollection valueActual = value.getValue();
                    if (net.ssehub.easy.varModel.model.datatypes.Set.TYPE.isAssignableFrom(value.getType())) {
                        tmpActual = new HashSet<Object>();
                        ConceptsTests.addAll(tmpActual, value, true);
                        tmpExpected = new HashSet<Object>();
                        ConceptsTests.addAll(tmpExpected, ex.getValue(), true);
                        valueExpected = tmpExpected;
                        valueActual = tmpActual;
                    } else if (Sequence.TYPE.isAssignableFrom(value.getType())) {
                        tmpActual = new ArrayList();
                        ConceptsTests.addAll(tmpActual, value, true);
                        tmpExpected = new ArrayList();
                        ConceptsTests.addAll(tmpExpected, ex.getValue(), true);
                        valueExpected = tmpExpected;
                        valueActual = tmpActual;
                    }
                    Assert.assertEquals((String)("Expected value for variable " + varName + " does not match"), (Object)valueExpected, (Object)valueActual);
                }
            }
            catch (ModelQueryException e) {
                Assert.fail((String)("unexpected exception " + e.getMessage()));
            }
        }
        return config;
    }

    private static void addAll(Collection<Object> result, Object value, boolean top) {
        AbstractCollection r = result;
        if (value instanceof ContainerValue) {
            ContainerValue cValue = (ContainerValue)value;
            if (!top) {
                r = net.ssehub.easy.varModel.model.datatypes.Set.TYPE.isAssignableFrom(cValue.getType()) ? new HashSet<Object>() : new ArrayList<Object>();
                result.add(r);
            }
            int e = 0;
            while (e < cValue.getElementSize()) {
                ConceptsTests.addAll(r, cValue.getElement(e), false);
                ++e;
            }
        } else if (value instanceof Collection) {
            if (!top) {
                r = value instanceof Set ? new HashSet<Object>() : new ArrayList<Object>();
                result.add(r);
            }
            for (Object v : (Collection)value) {
                ConceptsTests.addAll(r, v, false);
            }
        } else if (value != null && value.getClass().isArray()) {
            Object[] aValue = (Object[])value;
            if (!top) {
                r = new ArrayList<Object>();
                result.add(r);
            }
            Object[] objectArray = aValue;
            int n = aValue.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                ConceptsTests.addAll(r, v, false);
                ++n2;
            }
        } else if (value instanceof Value) {
            r.add((Object)((Value)value).getValue());
        } else {
            r.add((Object)value);
        }
    }
}

