/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractTracerBase;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.producer.scenario_tests.AbstractScenarioTest;
import net.ssehub.easy.producer.scenario_tests.ExperimentsTests;
import net.ssehub.easy.varModel.varModel.testSupport.TextTestUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalExperimentsTests
extends ExperimentsTests {
    @BeforeClass
    public static void startUp() {
        ExperimentsTests.startUp();
    }

    @AfterClass
    public static void shutDown() {
        ExperimentsTests.shutDown();
    }

    @Test
    public void testXml() throws IOException {
        TimeTracerFactory factory = new TimeTracerFactory();
        TracerFactory.setInstance((TracerFactory)factory);
        File tmp = this.executeCase("xmlExperiments", null, "", null, AbstractScenarioTest.Mode.INSTANTIATE);
        if (tmp != null) {
            File expected = new File(tmp, "GenTopoHardwareCorrelationFinancialPom.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "hwAlg.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "hwAlg1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "hwAlg2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "hwAlg3.xml"), (File)expected);
            expected = new File(tmp, "InterfacesPom.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "ifPom.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "ifPom1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "ifPom2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "ifPom3.xml"), (File)expected);
            expected = new File(tmp, "pipelinePom.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "pip.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pip1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pip2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pip3.xml"), (File)expected);
            expected = new File(tmp, "pipelines.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "pips.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pips1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pips2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "pips3.xml"), (File)expected);
            expected = new File(tmp, "ModelGenPom.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "modelGenPom.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "modelGenPom1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "modelGenPom2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "modelGenPom3.xml"), (File)expected);
            expected = new File(tmp, "pipSettings.xml");
            TextTestUtils.assertFileEquality((File)new File(tmp, "set.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "set1.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "set2.xml"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "set3.xml"), (File)expected);
            factory.printResults();
        }
    }

    @Test
    public void testJava() throws IOException {
        File tmp = this.executeCase("javaExperiments", null, "", null, AbstractScenarioTest.Mode.INSTANTIATE);
        if (tmp != null) {
            File expected = new File(tmp, "FCorrelationFinancial.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFam.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFam0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFam1.java"), (File)expected);
            expected = new File(tmp, "IFCorrelationFinancial.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFamI.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFamI0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "fcFamI1.java"), (File)expected);
            expected = new File(tmp, "IPriorityDataSink.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnk.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnk0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnk1.java"), (File)expected);
            expected = new File(tmp, "PriorityDataSink.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkI.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkI0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkI1.java"), (File)expected);
            expected = new File(tmp, "PriorityDataSinkProfiling.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkIP.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkIP0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "psSnkIP1.java"), (File)expected);
            expected = new File(tmp, "ISpringFinancialData.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrc.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrc0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrc1.java"), (File)expected);
            expected = new File(tmp, "SpringFinancialData.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcI.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcI0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcI1.java"), (File)expected);
            expected = new File(tmp, "SpringFinancialDataProfiling.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcIP.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcIP0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spSrcIP1.java"), (File)expected);
            expected = new File(tmp, "SpringFinancialDataProfilingImpl.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "spProfSrcI.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spProfSrcI0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "spProfSrcI1.java"), (File)expected);
            expected = new File(tmp, "SerializationRegistry.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "serReg.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "serReg0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "serReg1.java"), (File)expected);
            expected = new File(tmp, "FCorrelationFinancialSerializers.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "tSerFCor.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "tSerFCor0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "tSerFCor1.java"), (File)expected);
            expected = new File(tmp, "GenTopoHardwareFinancialCorrReceiver.cpp");
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorReceiver.cpp"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorReceiver0.cpp"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorReceiver1.cpp"), (File)expected);
            expected = new File(tmp, "GenTopoHardwareFinancialCorrSender.cpp");
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorSender.cpp"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorSender0.cpp"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "FCorSender1.cpp"), (File)expected);
        }
    }

    @Test
    public void testJavaDebug() throws IOException {
        TracerFactory.setInstance((TracerFactory)new ConsoleTracerFactory(true));
        String[] names = new String[]{"javaExperiments", "javaExperiments", "javaExperimentsDebug"};
        File tmp = this.executeCase(names, null, "", null, AbstractScenarioTest.Mode.INSTANTIATE);
        if (tmp != null) {
            File expected = new File(tmp, "PriorityPip_DataManagementElement0DataManagementElement.java");
            TextTestUtils.assertFileEquality((File)new File(tmp, "PrioPip_DME.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "PrioPip_DME0.java"), (File)expected);
            TextTestUtils.assertFileEquality((File)new File(tmp, "PrioPip_DME1.java"), (File)expected);
        }
    }

    private static class TimeTracerFactory
    extends TracerFactory {
        private VtlExecutionTimeTracer tracer = new VtlExecutionTimeTracer();

        private TimeTracerFactory() {
        }

        public ITracer createTemplateLanguageTracerImpl() {
            return this.tracer;
        }

        public net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer createBuildLanguageTracerImpl() {
            return this.tracer;
        }

        public IInstantiatorTracer createInstantiatorTracerImpl() {
            return this.tracer;
        }

        private Set<String> scriptNames() {
            return this.tracer.scriptNames();
        }

        private Long getExecutionTime(String scriptName) {
            return this.tracer.getExecutionTime(scriptName);
        }

        private void printResults() {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.scriptNames());
            Collections.sort(names, Collator.getInstance());
            for (String name : names) {
                Long time = this.getExecutionTime(name);
                if (time == null) continue;
                System.out.println(name + "\t\t" + String.valueOf(time));
            }
        }
    }

    private static class VtlExecutionTimeTracer
    extends AbstractTracerBase
    implements net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer,
    ITracer,
    IInstantiatorTracer {
        private HashMap<String, Long> start = new HashMap();
        private HashMap<String, Long> results = new HashMap();
        private int vtlNestingLevel = 0;

        private VtlExecutionTimeTracer() {
        }

        private Set<String> scriptNames() {
            return this.results.keySet();
        }

        private Long getExecutionTime(String scriptName) {
            return scriptName == null ? null : this.results.get(scriptName);
        }

        public void visitDef(Def def, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitedDef(Def def, RuntimeEnvironment<?, ?> environment, Object result) {
        }

        public void trace(String text) {
        }

        public void traceWarning(String text) {
        }

        public void valueDefined(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var, FieldDescriptor field, Object value) {
        }

        public void traceExecutionException(VilException exception) {
        }

        public void enable(boolean enable) {
        }

        public void visitingCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args) {
        }

        public void visitedCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args, Object result) {
        }

        public void failedAt(Expression expression) {
        }

        public void traceMessage(String message) {
        }

        public void traceError(String message) {
        }

        public void visitTemplate(Template template) {
            if (this.vtlNestingLevel == 0) {
                this.start.put(template.getName(), System.currentTimeMillis());
            }
            ++this.vtlNestingLevel;
        }

        public void visitedTemplate(Template template) {
            --this.vtlNestingLevel;
            if (this.vtlNestingLevel == 0) {
                long endTime = System.currentTimeMillis();
                Long startTime = this.start.remove(template.getName());
                if (startTime != null) {
                    this.results.put(template.getName(), endTime - startTime);
                }
            }
        }

        public void visitedSwitch(Object select, int alternative, Object value) {
        }

        public void visitLoop(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var) {
        }

        public void visitedLoop(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var) {
        }

        public void failedAt(ITemplateLangElement element) {
        }

        public void visitFlush() {
        }

        public void visitedFlush() {
        }

        public void visitScript(Script script, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitScriptBody(Script script, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitedScript(Script script) {
        }

        public void visitRule(Rule rule, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitedRule(Rule rule, RuntimeEnvironment<?, ?> environment, Object result) {
        }

        public void visitLoop(IEnumeratingLoop loop, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitIteratorAssignment(IEnumeratingLoop loop, VariableDeclaration var, Object value) {
        }

        public void visitedLoop(IEnumeratingLoop loop, RuntimeEnvironment<?, ?> environment) {
        }

        public Collection<?> adjustSequenceForMap(Collection<?> collection) {
            return null;
        }

        public Collection<Object> adjustSequenceForJoin(Collection<Object> collection) {
            return null;
        }

        public void visitSystemCall(String[] args) {
        }

        public void visitingInstantiator(String name) {
        }

        public void visitedInstantiator(String name, Object result) {
        }

        public void visitAlternative(boolean takeIf) {
        }

        public void failedAt(IBuildlangElement element) {
        }

        public void reset() {
        }

        public void visitWhileBody() {
        }

        public void visitedWhileBody() {
        }

        public void setTraceFilter(ITraceFilter filter) {
        }

        public ITraceFilter getTraceFilter() {
            return null;
        }

        public void visitBuilderBlock(BuilderBlockExpression ex, RuntimeEnvironment<?, ?> environment) {
        }

        public void visitedBuilderBlock(BuilderBlockExpression ex, RuntimeEnvironment<?, ?> environment, Object result) {
        }
    }
}

