/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.scenario_tests.AbstractEasyScenarioTest;
import net.ssehub.easy.producer.scenario_tests.AbstractScenarioTest;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.IMeasurementKey;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.varModel.testSupport.MeasurementCollector;
import org.junit.Assert;
import test.net.ssehub.easy.reasoning.core.reasoner.AbstractTest;
import test.net.ssehub.easy.reasoning.core.reasoner.AbstractTestDescriptor;

public abstract class AbstractRealTests
extends AbstractEasyScenarioTest {
    protected boolean enableRealTimeAsserts;

    @Override
    protected net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration assertConfiguration(Project prj, AbstractScenarioTest.Mode mode) {
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration result = super.assertConfiguration(prj, mode);
        if (this.enableRealTimeAsserts && "QM".equals(prj.getName())) {
            Configuration cfg = result.getConfiguration();
            try {
                AbstractVariable ppfe2 = ModelQuery.findVariable((IResolutionScope)prj, (String)"PriorityPip_FamilyElement2", null);
                if (ppfe2 != null) {
                    IDecisionVariable cVar = cfg.getDecision(ppfe2);
                    IDecisionVariable eVar = cVar.getNestedElement("capacity");
                    eVar.setValue(ValueFactory.createValue((IDatatype)eVar.getDeclaration().getType(), (Object[])new Object[]{1.0}), (IAssignmentState)AssignmentState.ASSIGNED);
                    System.out.println("Performing runtime reasoning/propagation...");
                    ReasonerConfiguration rCfg = new ReasonerConfiguration();
                    rCfg.setRuntimeMode(true);
                    int r = 1;
                    while (r <= AbstractTest.NUM_INCREMENTAL_REASONING) {
                        String id = mode.doMeasure() ? MeasurementCollector.start((Configuration)cfg, (String)"SCENARIO-INC", (int)r) : null;
                        ReasoningResult res = ReasonerFrontend.getInstance().propagate(cfg, rCfg, ProgressObserver.NO_OBSERVER);
                        if (id != null) {
                            MeasurementCollector.endAuto((String)id);
                            AbstractTest.transferReasoningMeasures((MeasurementCollector)MeasurementCollector.getInstance(), (String)id, (IMeasurementKey[])this.getMeasurements(), (ReasoningResult)res);
                            MeasurementCollector.end((String)id);
                        }
                        res.logInformation(prj, rCfg, debug);
                        Assert.assertTrue((String)"Runtime configuration must have conflict", (boolean)res.hasConflict());
                        AbstractRealTests.assertFailureMessage(res, ppfe2);
                        ++r;
                    }
                    if (AbstractTest.NUM_INSTANCE_REASONING > 0) {
                        System.out.println("Performing runtime reasoning/propagation with instance ...");
                        long instanceCreation = System.currentTimeMillis();
                        IReasonerInstance inst = ReasonerFrontend.getInstance().createInstance(cfg, rCfg);
                        instanceCreation = System.currentTimeMillis() - instanceCreation;
                        int r2 = 1;
                        while (r2 <= AbstractTest.NUM_INSTANCE_REASONING) {
                            String id = mode.doMeasure() ? MeasurementCollector.start((Configuration)cfg, (String)"SCENARIO-INST ", (int)r2) : null;
                            ReasoningResult res = inst.propagate(ProgressObserver.NO_OBSERVER);
                            if (id != null) {
                                MeasurementCollector.endAuto((String)id);
                                AbstractTest.transferReasoningMeasures((MeasurementCollector)MeasurementCollector.getInstance(), (String)id, (IMeasurementKey[])this.getMeasurements(), (ReasoningResult)res);
                                MeasurementCollector.set((String)id, (Object)AbstractTestDescriptor.MeasurementIdentifier.REASONER_INSTANCE_CREATION_TIME, (double)instanceCreation);
                                MeasurementCollector.end((String)id);
                            }
                            res.logInformation(prj, rCfg, debug);
                            Assert.assertTrue((String)"Runtime configuration must have conflict", (boolean)res.hasConflict());
                            AbstractRealTests.assertFailureMessage(res, ppfe2);
                            ++r2;
                        }
                    }
                }
            }
            catch (ModelQueryException e) {
                e.printStackTrace();
            }
            catch (ValueDoesNotMatchTypeException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static void assertFailureMessage(ReasoningResult res, AbstractVariable ... vars) {
        HashSet<AbstractVariable> check = new HashSet<AbstractVariable>();
        AbstractVariable[] abstractVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractVariable v = abstractVariableArray[n2];
            check.add(v);
            ++n2;
        }
        int m = 0;
        while (m < res.getMessageCount()) {
            Message msg = res.getMessage(m);
            for (Set s : msg.getConstraintVariables()) {
                for (AbstractVariable v : s) {
                    check.remove(v);
                }
            }
            ++m;
        }
        Assert.assertTrue((String)("No runtime failure found for " + String.valueOf(check)), (boolean)check.isEmpty());
    }
}

