/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.scenario_tests.AbstractScenarioTest;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.persistency.IVMLWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import test.de.uni_hildesheim.sse.AbstractTest;

public class ExperimentsControlTests
extends AbstractTest {
    public static final boolean PRINT_REASONER_MESSAGES = false;

    private static final File createFile(String name) {
        return new File(ExperimentsControlTests.getTestDataDir(), "experiments/control/" + name + ".ivml");
    }

    @BeforeClass
    public static void startUp() {
        ExperimentsControlTests.setTestDataDir((String)"easy_producer.scenarios.testdata.home");
        AbstractTest.startUp();
        AbstractScenarioTest.initializeReasoner();
        IVMLWriter.setUseIvmlWhitespace((boolean)true);
    }

    @AfterClass
    public static void shutDown() {
        AbstractTest.shutDown();
        ExperimentsControlTests.setTestDataDir((String)"ivml.testdata.home");
    }

    private Configuration createAndAssertEqual(String name) throws IOException {
        List prj = this.assertEqual(ExperimentsControlTests.createFile(name), null, null, new int[0]);
        Assert.assertTrue((prj != null && 1 == prj.size() ? 1 : 0) != 0);
        Project project = (Project)prj.get(0);
        Assert.assertNotNull((Object)project);
        return new Configuration(project);
    }

    private IDecisionVariable assertDecisionVariable(Configuration config, String name) throws ModelQueryException {
        AbstractVariable decl = ModelQuery.findVariable((IResolutionScope)config.getProject(), (String)name, null);
        Assert.assertNotNull((Object)decl);
        IDecisionVariable var = config.getDecision(decl);
        Assert.assertNotNull((Object)var);
        return var;
    }

    private static void assertEnumValue(IResolutionScope scope, String expected, Value value) throws ModelQueryException, IvmlException {
        if (expected == null) {
            Assert.assertTrue((value == null || NullValue.INSTANCE == value ? 1 : 0) != 0);
        } else {
            Value enumVal = ModelQuery.enumLiteralAsValue((IResolutionScope)scope, (String)expected);
            Assert.assertEquals((Object)enumVal, (Object)value);
        }
    }

    private static void assertEnumValue(Configuration config, String expected, CompoundValue value, String slot) throws ModelQueryException, IvmlException {
        ExperimentsControlTests.assertEnumValue((IResolutionScope)config.getProject(), expected, value.getNestedValue(slot));
    }

    private static void assertIntValue(Configuration config, Integer expected, CompoundValue value, String slot) {
        Value val = value.getNestedValue(slot);
        if (expected == null) {
            Assert.assertNull((Object)val);
        } else {
            Assert.assertTrue((boolean)(val instanceof IntValue));
            Assert.assertEquals((Object)expected, (Object)((IntValue)val).getValue());
        }
    }

    private void testDefaults(String name) throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual(name);
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertFalse((String)"there should not be reasoning conflicts", (boolean)res.hasConflict());
        IDecisionVariable da1 = this.assertDecisionVariable(config, "a1");
        IDecisionVariable da2 = this.assertDecisionVariable(config, "a2");
        CompoundValue v1 = (CompoundValue)da1.getValue();
        CompoundValue v2 = (CompoundValue)da2.getValue();
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind1", v1, "produces");
        ExperimentsControlTests.assertEnumValue(config, null, v1, "consumes");
        ExperimentsControlTests.assertIntValue(config, null, v1, "count");
        ExperimentsControlTests.assertEnumValue(config, null, v2, "produces");
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind2", v2, "consumes");
        ExperimentsControlTests.assertIntValue(config, null, v2, "count");
        IDecisionVariable dr1 = this.assertDecisionVariable(config, "r1");
        IDecisionVariable dw1 = this.assertDecisionVariable(config, "w1");
        CompoundValue w1 = (CompoundValue)dw1.getValue();
        CompoundValue r1 = (CompoundValue)dr1.getValue();
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind1", r1, "produces");
        ExperimentsControlTests.assertEnumValue(config, null, r1, "consumes");
        ExperimentsControlTests.assertIntValue(config, 5, r1, "count");
        ExperimentsControlTests.assertEnumValue(config, null, w1, "produces");
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind2", w1, "consumes");
        ExperimentsControlTests.assertIntValue(config, 10, w1, "count");
        IDecisionVariable dseq = this.assertDecisionVariable(config, "seq");
        ContainerValue seq = (ContainerValue)dseq.getValue();
        Assert.assertEquals((long)2L, (long)seq.getElementSize());
        CompoundValue s1 = (CompoundValue)seq.getElement(0);
        CompoundValue s2 = (CompoundValue)seq.getElement(1);
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind1", s1, "produces");
        ExperimentsControlTests.assertEnumValue(config, null, s1, "consumes");
        ExperimentsControlTests.assertIntValue(config, 6, s1, "count");
        ExperimentsControlTests.assertEnumValue(config, null, s2, "produces");
        ExperimentsControlTests.assertEnumValue(config, "Kind.kind2", s2, "consumes");
        ExperimentsControlTests.assertIntValue(config, 7, s2, "count");
    }

    @Test
    public void testControlDefaults1() throws IOException, ModelQueryException, IvmlException {
        this.testDefaults("defaults1");
    }

    @Test
    public void testControlDefaults2() throws IOException, ModelQueryException, IvmlException {
        this.testDefaults("defaults2");
    }

    @Ignore
    @Test
    public void testControlDefaults3() throws IOException, ModelQueryException, IvmlException {
        this.testDefaults("defaults3");
    }

    @Test
    public void testControlDefaults4() throws IOException, ModelQueryException, IvmlException {
        this.testDefaults("defaults4");
    }

    @Test
    public void testSub() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("configSub");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertFalse((String)"there should not be reasoning conflicts", (boolean)res.hasConflict());
    }

    @Test
    public void simpleTest() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("simple/Einfache_Steuerdatei_0");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertFalse((String)"there should not be reasoning conflicts", (boolean)res.hasConflict());
    }

    @Test
    public void existsTest() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("exists/BaseSD_0");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertFalse((String)"there should not be reasoning conflicts", (boolean)res.hasConflict());
    }

    @Test
    public void asymmetricTest() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("assymetric/ActivityGraph2Configuration_0");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertTrue((String)"there should be reasoning conflicts", (boolean)res.hasConflict());
        Assert.assertEquals((long)1L, (long)res.getMessageCount());
        Message msg = res.getMessage(0);
        boolean found = false;
        for (IDecisionVariable v : msg.getNamedConstraintVariables()) {
            found |= v.getDeclaration().getName().equals("dependenciesAntisymmetry");
        }
        Assert.assertTrue((String)"Constraint dependenciesAntisymmetry shall fail", (boolean)found);
    }

    @Test
    public void activityTestFail() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("activity/ActivityGraphConfiguration_0");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        int m = 0;
        while (m < res.getMessageCount()) {
            System.out.println(res.getMessage(m));
            ++m;
        }
        Assert.assertTrue((String)"there should be reasoning conflicts", (boolean)res.hasConflict());
    }

    @Test
    public void activityTest() throws IOException, ModelQueryException, IvmlException {
        Configuration config = this.createAndAssertEqual("activity/ActivityGraphConfiguration_1");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        rConfig.setAdditionalInformationLogger(ReasonerConfiguration.ADDITIONAL_INFO_LOG_NONE);
        ReasoningResult res = this.doReasoning(config, rConfig);
        int m = 0;
        while (m < res.getMessageCount()) {
            System.out.println(res.getMessage(m));
            ++m;
        }
        Assert.assertFalse((String)"there should not be reasoning conflicts", (boolean)res.hasConflict());
    }

    private ReasoningResult doReasoning(Configuration cfg, ReasonerConfiguration rConfig) {
        ReasoningResult res = ReasonerFrontend.getInstance().propagate(cfg, rConfig, ProgressObserver.NO_OBSERVER);
        res.logInformation(cfg.getProject(), rConfig, false);
        return res;
    }

    protected boolean checkWriteback(File file) {
        return false;
    }

    @Test
    public void typeTest() throws IOException {
        Configuration config = this.createAndAssertEqual("types/Testprodukt_0");
        ReasonerConfiguration rConfig = new ReasonerConfiguration();
        ReasoningResult res = this.doReasoning(config, rConfig);
        Assert.assertTrue((String)"there should be reasoning conflicts", (boolean)res.hasConflict());
    }
}

