/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.ssehub.easy.dslCore.test.AbstractTest;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.json.Registration;
import net.ssehub.easy.instantiation.velocity.VelocityInstantiator;
import net.ssehub.easy.producer.scenario_tests.AbstractRealTests;
import net.ssehub.easy.producer.scenario_tests.AbstractScenarioTest;
import net.ssehub.easy.producer.scenario_tests.mocks.DockerMock;
import net.ssehub.easy.producer.scenario_tests.mocks.LxcMock;
import net.ssehub.easy.producer.scenario_tests.mocks.MavenMock;
import net.ssehub.easy.varModel.varModel.testSupport.TextTestUtils;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class RealTests
extends AbstractRealTests {
    protected static final String[] RELATIVE_CURL_EXECUTABLES = new String[]{"curl/curl.bat", "curl/curl.sh"};
    private static RealTests tests;

    protected void addTestDataLocations() {
    }

    @BeforeClass
    public static void startUp() {
        tests = new RealTests();
        if (!debug) {
            tests.cleanTemp();
        }
        MavenMock.register();
        net.ssehub.easy.instantiation.java.Registration.register();
        net.ssehub.easy.instantiation.python.Registration.register();
        Registration.register();
        net.ssehub.easy.instantiation.yaml.Registration.register();
        VelocityInstantiator.register();
        DockerMock.register();
        LxcMock.register();
    }

    @AfterClass
    public static void shutDown() {
        if (!debug && tests != null) {
            tests.cleanTemp();
            tests = null;
        }
    }

    protected File getTestFolder() {
        return new File(this.getTestDataDir(), "real");
    }

    protected void cleanTempFolder(File baseFolder) {
        if (!debug) {
            try {
                FileUtils.deleteDirectory((File)baseFolder);
            }
            catch (IOException e) {
                System.out.println("Cannot delete " + String.valueOf(baseFolder) + ": " + e.getMessage());
            }
        }
    }

    protected void assertEqual(String file, String expectedName, int ... expectedErrorCodes) throws IOException {
        AbstractTest.EqualitySetup data = new AbstractTest.EqualitySetup(this.createFile(file), expectedName, null);
        this.assertEqual(data, expectedErrorCodes);
    }

    protected void assertEqual(String file, String expectedName, String expectedVersion, int ... expectedErrorCodes) throws IOException {
        AbstractTest.EqualitySetup data = new AbstractTest.EqualitySetup(this.createFile(file), expectedName, expectedVersion, null);
        this.assertEqual(data, expectedErrorCodes);
    }

    protected void assertEqual(String file, int ... expectedErrorCodes) throws IOException {
        AbstractTest.EqualitySetup data = new AbstractTest.EqualitySetup(this.createFile(file), file, null, null);
        this.assertEqual(data, expectedErrorCodes);
    }

    protected void assertCurlOut(File base) throws IOException {
        File producedFile = new File(base, "curl/curl.out");
        File expectedFile = new File(base, "curl/expected.out");
        TextTestUtils.assertFileEquality((File)producedFile, (File)expectedFile);
    }

    protected File executeIndenicaCase(String projectName, String ivmlVersion, String vilVersion, String ... makeExecutable) throws IOException {
        String[] versions = new String[]{ivmlVersion, vilVersion};
        return this.executeCase(projectName, versions, "INDENICA/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE, (AbstractScenarioTest.ITestModifier)new AbstractScenarioTest.MakeExecutableTestModifier(makeExecutable));
    }

    @Test
    public void testIndenicaPlRmsPlatform2() throws IOException {
        File base = this.executeIndenicaCase("PL_RMS_Platform2", "0", "0", RELATIVE_CURL_EXECUTABLES);
        if (base != null) {
            this.assertCurlOut(base);
            FileUtils.deleteQuietly((File)base);
        }
        if ((base = this.executeIndenicaCase("PL_RMS_Platform2", "0", "1", RELATIVE_CURL_EXECUTABLES)) != null) {
            this.assertCurlOut(base);
            this.cleanTempFolder(base);
        }
    }

    @Test
    public void testIndenicaPlYmsPlatform() throws IOException {
        String projectName = "PL_YMS_Platform";
        File base = this.executeIndenicaCase(projectName, "0", "0", RELATIVE_CURL_EXECUTABLES);
        if (base != null) {
            File resources = new File(base, "src/main/resources/");
            this.assertCurlOut(base);
            Object fileName = projectName + ".var";
            TextTestUtils.assertFileEquality((File)new File(base, "curl/" + (String)fileName), (File)new File(resources, (String)fileName));
            fileName = "resolution.res";
            TextTestUtils.assertFileEquality((File)new File(base, "curl/" + (String)fileName), (File)new File(resources, (String)fileName));
            this.cleanTempFolder(base);
        }
    }

    @Test
    public void testEP1() throws IOException {
        this.assertEqual("ep1", new int[0]);
    }

    @Test
    public void testYMS1() throws IOException {
        this.assertEqual("yms1", new int[0]);
    }

    @Test
    public void testElevator() throws IOException {
        String[] versions = new String[]{"0", "0"};
        File base = this.executeCase("New_Product", versions, "elevator/", "PL_SimElevator", AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            Assert.assertNotNull((String)"No JDK compiler, are you running JRE?", (Object)compiler);
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            ArrayList<File> files = new ArrayList<File>();
            this.enumerateJavaFiles(new File(base, "src"), files);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-d");
            options.add(new File(base, "bin").getAbsolutePath());
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
            StringWriter writer = new StringWriter();
            boolean success = compiler.getTask(writer, fileManager, null, options, null, compilationUnits).call();
            try {
                fileManager.close();
            }
            catch (IOException e) {
                Assert.fail((String)("unexpected exception: " + e.getMessage()));
            }
            Assert.assertTrue((String)("compile problems: " + writer.toString()), (boolean)success);
            this.cleanTempFolder(base);
        }
    }

    protected void enumerateJavaFiles(File location, List<File> files) {
        if (location.isDirectory()) {
            File[] dir = location.listFiles();
            if (dir != null) {
                File[] fileArray = dir;
                int n = dir.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.enumerateJavaFiles(f, files);
                    ++n2;
                }
            }
        } else if (location.getName().endsWith(".java")) {
            files.add(location);
        }
    }

    @Test
    public void testInstantiateNumericCSVInstantiation() throws IOException {
        File base = this.executeCase("NumericCSVInstantiationTest", new String[]{"0", "0"}, "", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            File expectedFile = new File(base, "NumericCSVInstantiationTest.csv");
            File producedFile = new File(base, "expected/NumericCSVInstantiationTest.csv");
            RealTests.assertExists(expectedFile);
            RealTests.assertExists(producedFile);
            String expectedContent = this.file2String(expectedFile).replace("\r", "");
            String actualContent = this.file2String(producedFile).replace("\r", "");
            Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        }
    }

    @Test
    public void testSvncontrol() throws IOException {
        String msg = net.ssehub.easy.instantiation.aspectj.Registration.checkEnvironment();
        if (msg != null) {
            System.out.println("Warning: " + msg);
        } else {
            String[] versions = new String[]{"0", "0"};
            this.testSvncontrol(versions);
            versions[1] = "0.1";
            this.testSvncontrol(versions);
        }
    }

    private void testSvncontrol(String[] versions) throws IOException {
        File base = this.executeCase("svncontrol", versions, "", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            RealTests.assertExists(base, "variability/StaticConfiguration", ".java");
            RealTests.assertExists(base, "variability/StartupConfiguration", ".java");
            RealTests.assertExists(base, "variability/RuntimeConfiguration", ".java");
            RealTests.assertExists(base, "gui/HooksTabAspect", ".aj");
            RealTests.assertExists(base, "gui/ScheduleTabAspect", ".aj");
            RealTests.assertExists(new File(base, "bin/client.jar"));
        }
    }

    protected static void assertExists(File base, String name, String extension) {
        RealTests.assertExists(new File(base, name + extension));
        RealTests.assertExists(new File(base, name + ".class"));
    }

    protected static void assertExists(File file) {
        Assert.assertTrue((String)("file " + file.getPath() + " does not exist"), (boolean)file.exists());
    }

    @Test
    public void testQualiMasterApril14() throws IOException {
        String[] versions = new String[]{"0", "0"};
        File base = this.executeCase("april14", versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Test
    public void testQualiMasterMay14() throws IOException {
        String[] versions = new String[]{"0", "0"};
        File base = this.executeCase("may14", versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Test
    public void testQualiMasterFeb15() throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"feb15", "QM"};
        File base = this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Test
    public void testQualiMasterFeb16() throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"feb16", "QM"};
        this.enableRealTimeAsserts = true;
        File base = this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        this.enableRealTimeAsserts = false;
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Test
    public void testQualiMasterMar15() throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"mar15", "QM"};
        File base = this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Test
    public void testQualiMasterJun15() throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"jun15", "QM"};
        File base = this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    protected void testQualiMasterFeb17Impl(AbstractScenarioTest.Mode mode) throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"feb17", "QM"};
        this.enableRealTimeAsserts = true;
        File base = this.executeCase(names, versions, "QualiMaster/", null, mode);
        this.enableRealTimeAsserts = false;
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Ignore
    @Test
    public void testQualiMasterFeb17() throws IOException {
        this.testQualiMasterFeb17Impl(AbstractScenarioTest.Mode.REASON_INSTANTIATE);
    }

    protected void testQualiMasterSep17Impl(AbstractScenarioTest.Mode mode) throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"sep17", "QM"};
        this.enableRealTimeAsserts = true;
        File base = this.executeCase(names, versions, "QualiMaster/", null, mode);
        this.enableRealTimeAsserts = false;
        if (base != null) {
            TextTestUtils.assertFileEqualityRec((File)new File(base, "expected"), (File)base);
        }
    }

    @Ignore
    @Test
    public void testQualiMasterSep17() throws IOException {
        this.testQualiMasterFeb17Impl(AbstractScenarioTest.Mode.REASON_INSTANTIATE);
    }

    @Ignore(value="Unresolved constant assignments")
    @Test
    public void testQualiMasterMay21() throws IOException {
        String[] versions = new String[]{"0", "0"};
        String[] names = new String[]{"may21", "QM"};
        this.executeCase(names, versions, "QualiMaster/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE);
    }

    @Test
    public void testIipEcosphereOct21() throws IOException {
        String folder = "oct21";
        this.executeIipCase("oct21", "SerializerConfig1", "main", new String[0]);
        this.executeIipCase("oct21", "SimpleMesh", "main", new String[0]);
        this.executeIipCase("oct21", "SimpleMesh3", "main", new String[0]);
    }

    @Test
    public void testIipEcosphereNov21() throws IOException {
        String folder = "nov21";
        this.executeIipCase("nov21", "SerializerConfig1", "main", new String[0]);
        this.executeIipCase("nov21", "SimpleMesh", "main", new String[0]);
        this.executeIipCase("nov21", "SimpleMesh3", "main", new String[0]);
    }

    @Test
    public void testIipEcosphereSep22() throws IOException {
        String folder = "sep22";
        this.executeIipCase("sep22", "SimpleMesh", "generateApps", new String[0]);
        this.executeIipCase("sep22", "SimpleMesh3", "generateApps", new String[0]);
        this.executeIipCase("sep22", "SerializerConfig1", "main", new String[0]);
        this.executeIipCase("sep22", "SerializerConfig1Old", "generateApps", new String[0]);
        this.executeIipCase("sep22", "RoutingTest", "generateApps", new String[0]);
        this.executeIipCase("sep22", "KodexMesh", "generateApps", new String[0]);
    }

    @Ignore(value="debugging model")
    @Test
    public void testIipEcosphereTest() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Windows"));
        String folder = "mar23";
        this.executeIipCase("mar23", "PlatformConfiguration", "generateApps", new String[0]);
    }

    @Test
    public void testOktoflowJun24() throws IOException {
        String folder = "jun24";
        this.executeIipCase("jun24", "PlatformConfiguration", "generateApps", "tests/simpleMesh3", "tests/common");
        this.executeIipCase("jun24", "SerializerConfig1", "main", "tests/single", "tests/common");
        this.executeIipCase("jun24", "SerializerConfig1Old", "generateApps", "tests/single", "tests/common");
        this.executeIipCase("jun24", "KodexMesh", "generateApps", "tests/single", "tests/common");
        this.executeIipCase("jun24", "Modbus", "generateApps", "tests/modbus");
    }

    protected void executeIipCase(String folder, String modelName, String vilStartRuleName, String ... cfgFolder) throws IOException {
        String vilFolderName = modelName;
        String[] versions = null;
        String[] names = new String[]{folder, modelName, "IIPEcosphere"};
        File base = this.executeCase(names, versions, "IIP-Ecosphere/", null, AbstractScenarioTest.Mode.REASON_INSTANTIATE, (AbstractScenarioTest.ITestModifier)new IipTestModifier(vilFolderName, vilStartRuleName, cfgFolder));
        String expectedFolder = vilFolderName;
        if (expectedFolder.equals("PlatformConfiguration") && cfgFolder.length > 0) {
            String[] stringArray = cfgFolder;
            int n = cfgFolder.length;
            int n2 = 0;
            while (n2 < n) {
                String cfg = stringArray[n2];
                File tmp = new File(cfg);
                if ((tmp = new File(new File(base, "expected"), PseudoString.firstToUpperCase((String)tmp.getName()) + expectedFolder)).exists() && tmp.isDirectory()) {
                    expectedFolder = tmp.getName();
                    break;
                }
                ++n2;
            }
        }
        TextTestUtils.assertFileEqualityRec((File)new File(new File(base, "expected"), expectedFolder), (File)new File(base, vilFolderName), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.toString().endsWith("__pycache__");
            }
        });
    }

    @Override
    protected TracerFactory getTracerFactory() {
        return super.getTracerFactory();
    }

    private static class IipTestModifier
    implements AbstractScenarioTest.ITestModifier {
        private String vilFolderName;
        private String vilStartRuleName;
        private String[] cfgFolder;

        private IipTestModifier(String vilFolderName) {
            this(vilFolderName, "main");
        }

        private IipTestModifier(String vilFolderName, String vilStartRuleName) {
            this(vilFolderName, vilStartRuleName, null);
        }

        private IipTestModifier(String vilFolderName, String vilStartRuleName, String[] cfgFolder) {
            this.vilFolderName = vilFolderName;
            this.vilStartRuleName = vilStartRuleName;
            this.cfgFolder = cfgFolder;
        }

        @Override
        public void postCopy(File target) {
        }

        @Override
        public String[] getConfigurationFolder() {
            return this.cfgFolder;
        }

        @Override
        public String getTempFolderName(String projectName) {
            return projectName;
        }

        @Override
        public File getVilOutputFolder(File temp) {
            File result = new File(temp, this.vilFolderName);
            if (!result.exists()) {
                result.mkdirs();
            }
            return result;
        }

        @Override
        public String getVilStartRuleName() {
            return this.vilStartRuleName;
        }
    }
}

