/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.scenario_tests;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.NoTracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.instantiation.java.Registration;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.GeneralMeasures;
import net.ssehub.easy.reasoning.core.reasoner.IMeasurementKey;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.sseReasoner.Measures;
import net.ssehub.easy.reasoning.sseReasoner.Reasoner;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.varModel.testSupport.MeasurementCollector;
import net.ssehub.easy.varModel.varModel.testSupport.TSVMeasurementCollector;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import test.de.uni_hildesheim.sse.vil.buildlang.AbstractTest;
import test.de.uni_hildesheim.sse.vil.buildlang.BuildLangTestConfigurer;
import test.de.uni_hildesheim.sse.vil.buildlang.ITestConfigurer;
import test.net.ssehub.easy.reasoning.core.reasoner.AbstractTestDescriptor;
import test.net.ssehub.easy.reasoning.sseReasoner.TestDescriptor;

public abstract class AbstractScenarioTest
extends AbstractTest<Script> {
    protected static boolean debug = false;
    protected static boolean instantiate = Boolean.valueOf(System.getProperty("easy.scenario.instantiate", "true"));
    protected static final String[] DEFAULT_MODEL_PATHS = new String[]{"EASy", "EASy", "EASy"};
    protected static String[] modelPaths = DEFAULT_MODEL_PATHS;
    protected static final IMeasurementKey[] MEASUREMENTS = AbstractTestDescriptor.concat((IMeasurementKey[])Measures.values(), (IMeasurementKey[])GeneralMeasures.values());

    static void initializeReasoner() {
        Reasoner reasoner = new Reasoner();
        ReasonerFrontend.getInstance().getRegistry().register((IReasoner)reasoner);
        ReasonerFrontend.getInstance().setReasonerHint(reasoner.getDescriptor());
        AbstractTestDescriptor.registerMeasurementMappings();
        TestDescriptor.registerMeasurementMappings();
    }

    protected IReasoner createReasoner() {
        return new Reasoner();
    }

    protected void furtherInitialization() {
        AbstractScenarioTest.initializeReasoner();
        Registration.register();
        net.ssehub.easy.instantiation.ant.Registration.register();
        net.ssehub.easy.instantiation.aspectj.Registration.register();
        PersistenceUtils.loadDefaultModels((ProgressObserver)ProgressObserver.NO_OBSERVER);
    }

    protected ITestConfigurer<Script> createTestConfigurer() {
        return new BuildLangTestConfigurer("easy_producer.scenarios.testdata.home");
    }

    protected void configureExecution(String projectName, Map<String, Object> args) {
    }

    private static String project(String[] versions, int index) {
        return versions == null ? null : versions[index];
    }

    protected File executeCase(String projectName, String[] versions, String caseFolder, String sourceProjectName, Mode mode) throws IOException {
        return this.executeCase(projectName, versions, caseFolder, sourceProjectName, mode, null);
    }

    protected File executeCase(String projectName, String[] versions, String caseFolder, String sourceProjectName, Mode mode, ITestModifier modifier) throws IOException {
        String[] names = new String[]{projectName};
        return this.executeCase(names, versions, caseFolder, sourceProjectName, mode, modifier);
    }

    protected File executeCase(String[] names, String[] versions, String caseFolder, String sourceProjectName, Mode mode) throws IOException {
        return this.executeCase(names, versions, caseFolder, sourceProjectName, mode, null);
    }

    protected File executeCase(String[] names, String[] versions, String caseFolder, String sourceProjectName, Mode mode, ITestModifier modifier) throws IOException {
        ArtifactFactory.clear();
        String projectName = names[0];
        String iModelName = names.length > 1 ? names[1] : projectName;
        String vModelName = names.length > 2 ? names[2] : iModelName;
        File temp = this.createTempDir(modifier != null ? modifier.getTempFolderName(projectName) : projectName);
        File base = new File(this.getTestFolder(), caseFolder + projectName);
        System.out.println("Copying " + String.valueOf(base) + " to " + String.valueOf(temp));
        FileUtils.copyDirectory((File)base, (File)temp);
        File sourceProjectFolder = null;
        if (sourceProjectName != null) {
            sourceProjectFolder = this.createTempDir(sourceProjectName);
            File sBase = new File(this.getTestFolder(), caseFolder + sourceProjectName);
            System.out.println("Copying " + String.valueOf(sBase) + " to " + String.valueOf(sourceProjectFolder));
            FileUtils.copyDirectory((File)sBase, (File)sourceProjectFolder);
        }
        File ivmlFolder = AbstractScenarioTest.getIvmlFolderIn(temp);
        File vilFolder = AbstractScenarioTest.getVilFolderIn(temp);
        File vtlFolder = AbstractScenarioTest.getVtlFolderIn(temp);
        File modelFolder = ivmlFolder;
        File[] cfgFolder = null;
        if (modifier != null) {
            modifier.postCopy(temp);
            String[] cfg = modifier.getConfigurationFolder();
            if (cfg != null && cfg.length > 0) {
                cfgFolder = (File[])Arrays.stream(cfg).map(f -> new File(temp, (String)f)).toArray(File[]::new);
                modelFolder = cfgFolder[0];
            }
        }
        AbstractScenarioTest.activateBuildProperties(vilFolder);
        this.doLocations(ivmlFolder, vilFolder, vtlFolder, cfgFolder, true);
        Project iModel = AbstractScenarioTest.obtainIvmlModel(iModelName, AbstractScenarioTest.project(versions, 0), modelFolder);
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration config = this.assertConfiguration(iModel, mode);
        File targetFile = null;
        if (instantiate && mode.doInstantiate()) {
            File sourceFile = temp.getAbsoluteFile();
            net.ssehub.easy.instantiation.core.model.vilTypes.Project source = AbstractScenarioTest.createProjectInstance(sourceFile);
            targetFile = sourceFile;
            net.ssehub.easy.instantiation.core.model.vilTypes.Project target = source;
            if (sourceProjectFolder != null) {
                source = AbstractScenarioTest.createProjectInstance(sourceProjectFolder.getAbsoluteFile());
            }
            if (modifier != null && modifier.getVilOutputFolder(temp) != null) {
                target = AbstractScenarioTest.createProjectInstance(modifier.getVilOutputFolder(temp));
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            net.ssehub.easy.instantiation.core.model.vilTypes.Project[] tmp = new net.ssehub.easy.instantiation.core.model.vilTypes.Project[]{source};
            param.put("source", tmp);
            param.put("target", target);
            param.put("config", config);
            this.configureExecution(projectName, param);
            System.out.println("Executing VIL...");
            net.ssehub.easy.instantiation.core.model.vilTypes.Project[] projectArray = tmp;
            int n = tmp.length;
            int n2 = 0;
            while (n2 < n) {
                net.ssehub.easy.instantiation.core.model.vilTypes.Project p = projectArray[n2];
                System.out.println(" Source: " + String.valueOf(p.getPath()));
                ++n2;
            }
            System.out.println(" Target: " + String.valueOf(target.getPath()));
            TracerFactory current = TracerFactory.getInstance();
            TracerFactory tFactory = this.getTracerFactory();
            TracerFactory.setDefaultInstance((TracerFactory)tFactory);
            Script script = AbstractScenarioTest.obtainVilModel(vModelName, AbstractScenarioTest.project(versions, 1), vilFolder);
            Executor executor = new Executor(script, param);
            executor.addBase(targetFile);
            this.execute(executor, modifier, tFactory);
            TracerFactory.setDefaultInstance((TracerFactory)current);
        }
        this.doLocations(ivmlFolder, vilFolder, vtlFolder, cfgFolder, false);
        return targetFile;
    }

    private void execute(Executor executor, ITestModifier modifier, TracerFactory tFactory) {
        if (modifier != null) {
            executor.addStartRuleName(modifier.getVilStartRuleName());
        }
        try {
            executor.execute();
        }
        catch (VilException e) {
            System.out.println(tFactory);
            e.printStackTrace(System.out);
            Assert.fail((String)("VIL execution issue " + String.valueOf((Object)e)));
        }
        AbstractScenarioTest.println(tFactory, debug);
    }

    private void doLocations(File ivmlFolder, File vilFolder, File vtlFolder, File[] cfgFolder, boolean add) {
        System.out.println("Registering model location...");
        try {
            if (add) {
                System.out.println(" Adding IVML location " + String.valueOf(ivmlFolder));
                ModelLocations.Location loc = VarModel.INSTANCE.locations().addLocation(ivmlFolder, ProgressObserver.NO_OBSERVER);
                if (cfgFolder != null) {
                    File[] fileArray = cfgFolder;
                    int n = cfgFolder.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File c = fileArray[n2];
                        System.out.println(" Adding IVML config location " + String.valueOf(c));
                        ModelLocations.Location l = VarModel.INSTANCE.locations().addLocation(c, ProgressObserver.NO_OBSERVER);
                        loc.addDependentLocation(l);
                        ++n2;
                    }
                }
                System.out.println(" Adding VIL location " + String.valueOf(vilFolder));
                BuildModel.INSTANCE.locations().addLocation(vilFolder, ProgressObserver.NO_OBSERVER);
                System.out.println(" Adding VTL location " + String.valueOf(vtlFolder));
                TemplateModel.INSTANCE.locations().addLocation(vtlFolder, ProgressObserver.NO_OBSERVER);
            } else {
                System.out.println(" Removing IVML location " + String.valueOf(ivmlFolder));
                VarModel.INSTANCE.locations().removeLocation(ivmlFolder, ProgressObserver.NO_OBSERVER);
                if (cfgFolder != null) {
                    File[] fileArray = cfgFolder;
                    int n = cfgFolder.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File c = fileArray[n3];
                        System.out.println(" Adding IVML config location " + String.valueOf(c));
                        VarModel.INSTANCE.locations().removeLocation(c, ProgressObserver.NO_OBSERVER);
                        ++n3;
                    }
                }
                System.out.println(" Removing VIL location " + String.valueOf(vilFolder));
                BuildModel.INSTANCE.locations().removeLocation(vilFolder, ProgressObserver.NO_OBSERVER);
                System.out.println(" Removing VTL location " + String.valueOf(vtlFolder));
                TemplateModel.INSTANCE.locations().removeLocation(vtlFolder, ProgressObserver.NO_OBSERVER);
                VarModel.INSTANCE.clear();
                BuildModel.INSTANCE.clear();
                TemplateModel.INSTANCE.clear();
            }
        }
        catch (ModelManagementException e) {
            Assert.fail((String)("unexpected exception (VIL/VTL): " + e.getMessage()));
        }
    }

    protected net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration assertConfiguration(Project prj, Mode mode) {
        System.out.println("Creating VIL configuration...");
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration config = new net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration(new Configuration(prj));
        Assert.assertNotNull((String)"VIL configuration must not be null", (Object)config);
        if (mode.doReason()) {
            System.out.println("Performing reasoning/propagation...");
            ReasonerConfiguration rCfg = new ReasonerConfiguration();
            test.net.ssehub.easy.reasoning.core.reasoner.AbstractTest.setReasoningTimeout((ReasonerConfiguration)rCfg);
            TSVMeasurementCollector.ensureCollector((File)new File(this.getTestDataDir(), "temp/" + this.getMeasurementFileName()), (Object[])new Object[0]);
            ReasoningResult result = null;
            Configuration cfg = config.getConfiguration();
            int r = 1;
            int n = mode.runCount(test.net.ssehub.easy.reasoning.core.reasoner.AbstractTest.NUM_FULL_REASONING);
            while (r <= n) {
                String id = mode.doMeasure() ? MeasurementCollector.start((Configuration)cfg, (String)"SCENARIO", (int)r) : null;
                ReasoningResult res = ReasonerFrontend.getInstance().propagate(cfg.getConfiguration(), rCfg, ProgressObserver.NO_OBSERVER);
                if (id != null) {
                    MeasurementCollector.endAuto((String)id);
                    test.net.ssehub.easy.reasoning.core.reasoner.AbstractTest.transferReasoningMeasures((MeasurementCollector)MeasurementCollector.getInstance(), (String)id, (IMeasurementKey[])this.getMeasurements(), (ReasoningResult)res);
                    MeasurementCollector.end((String)id);
                }
                if (n > 1) {
                    cfg = new Configuration(prj);
                }
                result = result == null ? res : result;
                ++r;
            }
            result.logInformation(prj, rCfg, debug);
            Assert.assertFalse((String)"Reasoning must not have a conflict", (boolean)result.hasConflict());
            Assert.assertFalse((String)"Reasoning must not have a timeout", (boolean)result.hasTimeout());
        }
        return config;
    }

    protected abstract String getMeasurementFileName();

    protected IMeasurementKey[] getMeasurements() {
        return MEASUREMENTS;
    }

    private static void println(Object object, boolean print) {
        if (print) {
            System.out.println(object);
        }
    }

    protected TracerFactory getTracerFactory() {
        if (debug) {
            return ConsoleTracerFactory.INSTANCE;
        }
        return new MyTracerFactory();
    }

    private static Script obtainVilModel(String projectName, String vilVersion, File vilFolder) {
        Object versionPostfix = "";
        if (vilVersion != null) {
            versionPostfix = "_" + vilVersion;
        }
        URI scriptURI = new File(vilFolder, projectName + (String)versionPostfix + ".vil").toURI();
        Script script = null;
        try {
            ModelInfo info = BuildModel.INSTANCE.availableModels().getModelInfo(projectName, vilVersion, scriptURI);
            Assert.assertNotNull((String)("VIL model " + projectName + " " + vilVersion + " cannot be found"), (Object)info);
            script = (Script)BuildModel.INSTANCE.load(info);
        }
        catch (VersionFormatException e) {
            Assert.fail((String)"version information invalid");
        }
        catch (ModelManagementException e) {
            Assert.fail((String)("unexpected exception: " + String.valueOf((Object)e)));
        }
        Assert.assertNotNull((String)("cannot load VIL build script " + projectName + " (syntax?)"), script);
        return script;
    }

    protected static Project obtainIvmlModel(String projectName, String ivmlVersion, File ivmlFolder) {
        System.out.println("Loading IVML...");
        Object versionSuffix = "";
        if (ivmlVersion != null) {
            versionSuffix = "_" + ivmlVersion;
        }
        URI modelURI = new File(ivmlFolder, projectName + (String)versionSuffix + ".ivml").toURI();
        Project ivmlModel = null;
        try {
            ModelInfo info = VarModel.INSTANCE.availableModels().getModelInfo(projectName, ivmlVersion, modelURI);
            Assert.assertNotNull((String)("IVML model " + projectName + " cannot be found"), (Object)info);
            ivmlModel = (Project)VarModel.INSTANCE.load(info);
            if (debug) {
                Utils.printResolution((IModel)ivmlModel, (ModelManagement)VarModel.INSTANCE);
            }
        }
        catch (VersionFormatException e) {
            Assert.fail((String)"version information invalid (IVML)");
        }
        catch (ModelManagementException e) {
            Assert.fail((String)("unexpected exception (IVML): " + String.valueOf((Object)e)));
        }
        Assert.assertNotNull((String)("cannot load IVML model " + projectName + " (syntax?)"), ivmlModel);
        return ivmlModel;
    }

    protected static File getIvmlFolderIn(File base) {
        return new File(base, modelPaths[0]);
    }

    protected static File getVilFolderIn(File base) {
        return new File(base, modelPaths[1]);
    }

    protected static File getVtlFolderIn(File base) {
        return new File(base, modelPaths[2]);
    }

    private static void activateBuildProperties(File dir) {
        String os = System.getProperty("os.name").toLowerCase();
        String suffix = os.indexOf("win") >= 0 ? "win" : "unix";
        File file = new File(dir, "build.properties_" + suffix);
        if (file.exists()) {
            file.renameTo(new File(dir, "build.properties"));
        }
    }

    private static net.ssehub.easy.instantiation.core.model.vilTypes.Project createProjectInstance(File folder) {
        net.ssehub.easy.instantiation.core.model.vilTypes.Project result = null;
        try {
            result = new net.ssehub.easy.instantiation.core.model.vilTypes.Project(folder, ProgressObserver.NO_OBSERVER);
        }
        catch (VilException e) {
            Assert.fail((String)("unexpected exeption: " + String.valueOf((Object)e)));
        }
        return result;
    }

    protected static interface ITestModifier {
        public void postCopy(File var1);

        public String getTempFolderName(String var1);

        default public String[] getConfigurationFolder() {
            return null;
        }

        public File getVilOutputFolder(File var1);

        public String getVilStartRuleName();
    }

    public static class MakeExecutableTestModifier
    implements ITestModifier {
        private String[] makeExecutable;

        public MakeExecutableTestModifier(String ... makeExecutable) {
            this.makeExecutable = makeExecutable;
        }

        @Override
        public void postCopy(File target) {
            if (this.makeExecutable != null) {
                String[] stringArray = this.makeExecutable;
                int n = this.makeExecutable.length;
                int n2 = 0;
                while (n2 < n) {
                    String fName = stringArray[n2];
                    File file = new File(target, fName);
                    if (file.exists()) {
                        file.setExecutable(true);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public String getTempFolderName(String projectName) {
            return projectName;
        }

        @Override
        public File getVilOutputFolder(File temp) {
            return null;
        }

        @Override
        public String getVilStartRuleName() {
            return "main";
        }
    }

    protected static enum Mode {
        LOAD(false, false, true),
        REASON(true, false, true),
        REASON_NO_MEASURE(true, false, false),
        INSTANTIATE(false, true, true),
        REASON_INSTANTIATE(true, true, true);

        private boolean doReason;
        private boolean doInstantiate;
        private boolean doMeasure;

        private Mode(boolean doReason, boolean doInstantiate, boolean doMeasure) {
            this.doReason = doReason;
            this.doInstantiate = doInstantiate;
            this.doMeasure = doMeasure;
        }

        protected boolean doReason() {
            return this.doReason;
        }

        protected boolean doInstantiate() {
            return this.doInstantiate;
        }

        protected boolean doMeasure() {
            return this.doMeasure;
        }

        protected int runCount(int runCount) {
            return this.doMeasure ? runCount : 1;
        }
    }

    private static class MyTracerFactory
    extends TracerFactory {
        private StringWriter writer = new StringWriter();

        private MyTracerFactory() {
        }

        public String toString() {
            return this.writer.toString();
        }

        public ITracer createTemplateLanguageTracerImpl() {
            return net.ssehub.easy.instantiation.core.model.templateModel.NoTracer.INSTANCE;
        }

        public net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer createBuildLanguageTracerImpl() {
            return NoTracer.INSTANCE;
        }

        public IInstantiatorTracer createInstantiatorTracerImpl() {
            return EMPTY_INSTANTIATOR_TRACER;
        }
    }
}

