/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.filter.AbstractStateVariablesInConstraintFinder;

public class VariablesInConstraintFinder
extends AbstractStateVariablesInConstraintFinder {
    private int variablesCount;
    private int frozenVariablesCount;
    private int localVariablesCount;

    public VariablesInConstraintFinder() {
    }

    public VariablesInConstraintFinder(ConstraintSyntaxTree cst, Configuration config) {
        super(cst, config);
    }

    public void clear() {
        super.clear();
        this.variablesCount = 0;
        this.localVariablesCount = 0;
        this.frozenVariablesCount = 0;
    }

    public int getFrozenVariablesCount() {
        return this.frozenVariablesCount;
    }

    public int getLocalVariablesCount() {
        return this.localVariablesCount;
    }

    public int getVariablesCount() {
        return this.variablesCount;
    }

    public boolean isConstraintFrozen() {
        return this.getVariablesCount() == this.getLocalVariablesCount() + this.getFrozenVariablesCount();
    }

    protected void addVariable(IDecisionVariable var) {
        if (var != null) {
            AssignmentState state;
            ++this.variablesCount;
            Object object = state = var.getState() != null ? var.getState() : AssignmentState.UNDEFINED;
            if (var.isLocal()) {
                ++this.localVariablesCount;
            } else if (AssignmentState.FROZEN == state) {
                ++this.frozenVariablesCount;
            }
        }
    }
}

