/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesMap;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;

public class VariablesInNotSimpleAssignmentConstraintsFinder
implements IConstraintTreeVisitor {
    private Configuration config;
    private VariablesMap constraintMap;
    private Constraint constraint;
    private boolean add = true;
    private EvaluationVisitor evaluator;

    public VariablesInNotSimpleAssignmentConstraintsFinder(VariablesMap constraintMap) {
        this.constraintMap = constraintMap;
        this.evaluator = new EvaluationVisitor();
    }

    public void accept(Constraint constraint, Configuration config) {
        this.config = config;
        this.constraint = constraint;
        this.evaluator.init((IConfiguration)config, null, false, null);
        constraint.getConsSyntax().accept((IConstraintTreeVisitor)this);
    }

    public void acceptAndClear(Constraint constraint, Configuration config) {
        this.acceptAndClear(constraint, config, true);
    }

    public void acceptAndClear(Constraint constraint, Configuration config, boolean add) {
        this.add = add;
        this.accept(constraint, config);
        this.clear();
    }

    public void acceptAndClear(List<Constraint> constraints, Configuration config, boolean add) {
        this.add = add;
        this.config = config;
        this.evaluator.init((IConfiguration)config, null, false, null);
        int c = 0;
        while (c < constraints.size()) {
            this.constraint = constraints.get(c);
            this.constraint.getConsSyntax().accept((IConstraintTreeVisitor)this);
            ++c;
        }
        this.clear();
    }

    public void clear() {
        this.config = null;
        this.constraint = null;
        this.add = true;
        this.evaluator.clear();
    }

    public VariablesInNotSimpleAssignmentConstraintsFinder forRemove() {
        this.add = false;
        return this;
    }

    public void visitConstantValue(ConstantValue value) {
        Value constValue = value.getConstantValue();
        if (constValue != null && constValue instanceof ReferenceValue) {
            ReferenceValue rValue = (ReferenceValue)constValue;
            this.modifyRelation(rValue.getValue(), this.constraint);
        }
    }

    public void visitVariable(Variable variable) {
        this.modifyRelation(variable.getVariable(), this.constraint);
    }

    private void modifyRelation(AbstractVariable variable, Constraint constraint) {
        if (variable != null) {
            IDecisionVariable var = this.config.getDecision(variable);
            if (var != null) {
                if (this.add) {
                    this.constraintMap.registerConstraint(var, constraint);
                } else {
                    this.constraintMap.unregisterConstraint(var, constraint);
                }
            }
            if (this.add) {
                this.constraintMap.add(variable, constraint);
            } else {
                this.constraintMap.remove(variable, constraint);
            }
        }
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        ConstraintSyntaxTree qu = variable.getQualifier();
        if (qu != null) {
            qu.accept((IConstraintTreeVisitor)this);
        }
        this.visitVariable((Variable)variable);
    }

    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
    }

    public void visitComment(Comment comment) {
        comment.getExpr().accept((IConstraintTreeVisitor)this);
    }

    private boolean isConstraint(ConstraintSyntaxTree cst) {
        boolean result;
        try {
            result = TypeQueries.isConstraint((IDatatype)cst.inferDatatype());
        }
        catch (CSTSemanticException e) {
            result = false;
        }
        return result;
    }

    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (call.getOperand() != null) {
            ConstraintSyntaxTree operand;
            boolean analyze = true;
            if (call.getParameterCount() == 1 && call.getOperation().equals("=") && ((operand = call.getOperand()) instanceof Variable || operand instanceof CompoundAccess)) {
                ConstraintSyntaxTree param0 = call.getParameter(0);
                if (param0 instanceof ConstantValue || param0 instanceof ContainerInitializer || param0 instanceof CompoundInitializer) {
                    analyze = false;
                } else if (this.isConstraint(operand)) {
                    analyze = false;
                }
            }
            if (analyze) {
                call.getOperand().accept((IConstraintTreeVisitor)this);
                int i = 0;
                while (i < call.getParameterCount()) {
                    call.getParameter(i).accept((IConstraintTreeVisitor)this);
                    ++i;
                }
            }
        }
    }

    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
    }

    public void visitLet(Let let) {
        let.getInExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
        ifThen.getThenExpr().accept((IConstraintTreeVisitor)this);
        ifThen.getElseExpr().accept((IConstraintTreeVisitor)this);
    }

    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept((IConstraintTreeVisitor)this);
        call.getExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept((IConstraintTreeVisitor)this);
        try {
            access.inferDatatype();
        }
        catch (CSTSemanticException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.reasoning.sseReasoner").exception((Exception)((Object)e));
        }
        access.accept((IConstraintTreeVisitor)this.evaluator);
        IDecisionVariable var = this.evaluator.getResultVariable();
        if (var != null) {
            this.modifyRelation(var.getDeclaration(), this.constraint);
        } else {
            try {
                IDatatype cType = Reference.dereference((IDatatype)access.getCompoundExpression().inferDatatype());
                if (cType instanceof Compound) {
                    this.modifyRelation((AbstractVariable)((Compound)cType).getElement(access.getSlotName()), this.constraint);
                }
            }
            catch (CSTSemanticException cSTSemanticException) {
                // empty catch block
            }
        }
        this.evaluator.clearResult();
    }

    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        ConstraintSyntaxTree nestedConstraint = expression.getActualExpression();
        if (nestedConstraint != null) {
            nestedConstraint.accept((IConstraintTreeVisitor)this);
        }
    }

    public void visitCompoundInitializer(CompoundInitializer initializer) {
        int i = 0;
        while (i < initializer.getExpressionCount()) {
            initializer.getExpression(i).accept((IConstraintTreeVisitor)this);
            ++i;
        }
    }

    public void visitContainerInitializer(ContainerInitializer initializer) {
        int i = 0;
        while (i < initializer.getExpressionCount()) {
            initializer.getExpression(i).accept((IConstraintTreeVisitor)this);
            ++i;
        }
    }

    public void visitSelf(Self self) {
    }

    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
    }
}

