/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import java.util.HashSet;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.filter.ConstraintFinder;

public class ConstraintFunctions {
    public static void allCompoundConstraints(Compound cmpType, AbstractConstraintProcessor processor, boolean includeConstraintVariables, boolean includeDefaults, IModelElement parent) {
        if (!processor.getContextStack().isTypeExcluded((IDatatype)cmpType)) {
            int c = 0;
            while (c < cmpType.getConstraintsCount()) {
                processor.process(cmpType.getConstraint(c), AbstractConstraintProcessor.ExpressionType.CONSTRAINT);
                ++c;
            }
            if (includeConstraintVariables || includeDefaults) {
                int i = 0;
                while (i < cmpType.getElementCount()) {
                    DecisionVariableDeclaration decl = cmpType.getElement(i);
                    ConstraintSyntaxTree defaultValue = decl.getDefaultValue();
                    if (defaultValue != null) {
                        if (includeConstraintVariables && TypeQueries.isConstraint((IDatatype)decl.getType())) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.CONSTRAINT_VALUE, decl.getName(), parent);
                        } else if (includeDefaults) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.DEFAULT, decl.getName(), parent);
                        }
                    }
                    int a = 0;
                    int n = decl.getAttributesCount();
                    while (includeDefaults && a < n) {
                        Attribute attr = decl.getAttribute(a);
                        defaultValue = attr.getDefaultValue();
                        if (defaultValue != null) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.ANNOTATION_DEFAULT, attr.getName(), parent);
                        }
                        ++a;
                    }
                    ++i;
                }
            }
            int r = 0;
            while (r < cmpType.getRefinesCount()) {
                ConstraintFunctions.allCompoundConstraints(cmpType.getRefines(r), processor, includeConstraintVariables, includeDefaults, parent);
                ++r;
            }
            int a = 0;
            while (a < cmpType.getAssignmentCount()) {
                ConstraintFunctions.allAssignmentConstraints(cmpType.getAssignment(a), processor);
                ++a;
            }
        }
    }

    public static void allAssignmentConstraints(AttributeAssignment assng, AbstractConstraintProcessor processor) {
        int c = 0;
        while (c < assng.getConstraintsCount()) {
            processor.process(assng.getConstraint(c), AbstractConstraintProcessor.ExpressionType.ASSIGNMENT_CONSTRAINT);
            ++c;
        }
        int a = 0;
        while (a < assng.getAssignmentCount()) {
            ConstraintFunctions.allAssignmentConstraints(assng.getAssignment(a), processor);
            ++a;
        }
    }

    public static void addConstraintsToProject(AbstractVariable var, Project scope, Project target) {
        new TransitiveConstraintFinder(scope, target).visit(var);
    }

    private static class TransitiveConstraintFinder
    extends ConstraintFinder
    implements IConstraintTreeVisitor,
    IDatatypeVisitor {
        private boolean add;
        private java.util.Set<AbstractVariable> variables = new HashSet<AbstractVariable>();
        private java.util.Set<AbstractVariable> scheduled = new HashSet<AbstractVariable>();
        private java.util.Set<AbstractVariable> candidates = new HashSet<AbstractVariable>();
        private java.util.Set<Object> done = new HashSet<Object>();
        private Project scope;
        private Project target;
        private IModelVisitor mVisitor;

        public TransitiveConstraintFinder(Project scope, Project target) {
            super(scope);
            this.scope = scope;
            this.target = target;
            this.mVisitor = this;
        }

        protected void startAccept(Project project) {
        }

        public void visit(AbstractVariable var) {
            this.addToVariables(var);
            this.scope.accept((IModelVisitor)this);
            while (!this.scheduled.isEmpty()) {
                boolean visitAgain = false;
                for (AbstractVariable v : this.scheduled) {
                    if (this.variables.contains(v)) continue;
                    this.addToVariables(var);
                    this.target.add((ContainableModelElement)v);
                    visitAgain = true;
                }
                this.scheduled.clear();
                if (!visitAgain) continue;
                this.scope.accept((IModelVisitor)this);
            }
        }

        private void visit(IDatatype type) {
            if (type != null && !this.done.contains(type)) {
                this.done.add(type);
                type.accept((IDatatypeVisitor)this);
            }
        }

        private void addToVariables(AbstractVariable var) {
            this.variables.add(var);
            var.accept(this.mVisitor);
        }

        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            this.visit(decl.getType());
            if (decl.getDefaultValue() != null) {
                int size = this.candidates.size();
                decl.getDefaultValue().accept((IConstraintTreeVisitor)this);
                if (this.candidates.size() > size) {
                    this.scheduled.addAll(this.candidates);
                    this.candidates.clear();
                }
            }
        }

        public void visitConstraint(Constraint constraint) {
            this.add = false;
            constraint.getConsSyntax().accept((IConstraintTreeVisitor)this);
            if (this.add) {
                this.target.addConstraint(constraint);
                this.scheduled.addAll(this.candidates);
                this.candidates.clear();
            }
        }

        public void visitProject(Project project) {
            Project old = this.target;
            String pName = project.getName();
            int i = 0;
            while (old == this.target && i < old.getImportsCount()) {
                ProjectImport imp = old.getImport(i);
                if (imp.getName().equals(pName) && imp.getResolved() != null) {
                    this.target = (Project)imp.getResolved();
                }
                ++i;
            }
            if (old == this.target) {
                this.target = new Project(pName);
                ProjectImport imp = new ProjectImport(pName);
                try {
                    imp.setResolved(this.target);
                    old.addImport(imp);
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(((Object)((Object)this)).getClass(), "net.ssehub.easy.reasoning.sseReasoner");
                }
            }
            super.visitProject(project);
        }

        public void visitConstantValue(ConstantValue value) {
        }

        private void handle(AbstractVariable variable) {
            boolean found = this.variables.contains(variable);
            if (!found) {
                this.candidates.add(variable);
            }
            this.add |= found;
        }

        public void visitVariable(Variable variable) {
            this.handle(variable.getVariable());
        }

        public void visitAnnotationVariable(AttributeVariable variable) {
            this.handle(variable.getVariable());
        }

        public void visitParenthesis(Parenthesis parenthesis) {
            parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
        }

        public void visitComment(Comment comment) {
        }

        public void visitOclFeatureCall(OCLFeatureCall call) {
            if (call.getOperand() != null) {
                call.getOperand().accept((IConstraintTreeVisitor)this);
            }
            int p = 0;
            while (p < call.getParameterCount()) {
                call.getParameter(p).accept((IConstraintTreeVisitor)this);
                ++p;
            }
        }

        public void visitLet(Let let) {
            let.getInExpression().accept((IConstraintTreeVisitor)this);
        }

        public void visitIfThen(IfThen ifThen) {
            ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
            if (ifThen.getElseExpr() != null) {
                ifThen.getElseExpr().accept((IConstraintTreeVisitor)this);
            }
        }

        public void visitContainerOperationCall(ContainerOperationCall call) {
            call.getExpression().accept((IConstraintTreeVisitor)this);
        }

        public void visitCompoundAccess(CompoundAccess access) {
            if (access.getResolvedSlot() != null) {
                access.getResolvedSlot().accept(this.mVisitor);
            }
        }

        public void visitUnresolvedExpression(UnresolvedExpression expression) {
        }

        public void visitCompoundInitializer(CompoundInitializer initializer) {
            int e = 0;
            while (e < initializer.getExpressionCount()) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
        }

        public void visitContainerInitializer(ContainerInitializer initializer) {
            int e = 0;
            while (e < initializer.getExpressionCount()) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
        }

        public void visitSelf(Self self) {
        }

        public void visitBlockExpression(BlockExpression block) {
            int e = 0;
            while (e < block.getExpressionCount()) {
                block.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
        }

        public void visitDeferInitExpression(DeferInitExpression expression) {
            expression.getExpression().accept((IConstraintTreeVisitor)this);
        }

        public void visitMultiAndExpression(MultiAndExpression expression) {
            int e = 0;
            while (e < expression.getExpressionCount()) {
                expression.getExpression(e).accept((IConstraintTreeVisitor)this);
                ++e;
            }
        }

        public void visitDatatype(IDatatype datatype) {
        }

        public void visitAnyType(AnyType datatype) {
        }

        public void visitMetaType(MetaType datatype) {
        }

        public void visitDerivedType(DerivedDatatype datatype) {
            datatype.getBasisType().accept((IDatatypeVisitor)this);
        }

        public void visitBooleanType(BooleanType type) {
        }

        public void visitStringType(StringType type) {
        }

        public void visitConstraintType(ConstraintType type) {
        }

        public void visitIntegerType(IntegerType type) {
        }

        public void visitVersionType(VersionType type) {
        }

        public void visitRealType(RealType type) {
        }

        public void visitCompoundType(Compound compound) {
            int e = 0;
            while (e < compound.getElementCount()) {
                compound.getElement(e).accept(this.mVisitor);
                ++e;
            }
            int a = 0;
            while (a < compound.getAssignmentCount()) {
                compound.getAssignment(a).accept(this.mVisitor);
                ++a;
            }
        }

        public void visitAttributeAssignment(AttributeAssignment assignment) {
            int e = 0;
            while (e < assignment.getElementCount()) {
                assignment.getElement(e).accept(this.mVisitor);
                ++e;
            }
            super.visitAttributeAssignment(assignment);
        }

        public void visitSet(Set set) {
            int g = 0;
            while (g < set.getGenericTypeCount()) {
                set.getGenericType(g).accept((IDatatypeVisitor)this);
                ++g;
            }
        }

        public void visitSequence(Sequence sequence) {
            int g = 0;
            while (g < sequence.getGenericTypeCount()) {
                sequence.getGenericType(g).accept((IDatatypeVisitor)this);
                ++g;
            }
        }

        public void visitEnumType(Enum enumType) {
        }

        public void visitOrderedEnumType(OrderedEnum enumType) {
        }
    }
}

