/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.impl.ReasonerHelper;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerInterceptor;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.reasoning.sseReasoner.Descriptor;
import net.ssehub.easy.reasoning.sseReasoner.Engine;
import net.ssehub.easy.reasoning.sseReasoner.EvalVisitor;
import net.ssehub.easy.reasoning.sseReasoner.functions.ConstraintFunctions;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import org.osgi.service.component.ComponentContext;

public class Reasoner
implements IReasoner {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Reasoner.class, "net.ssehub.easy.reasoning.sseReasoner");
    private static final Descriptor DESCRIPTOR = new Descriptor();
    private IReasonerInterceptor interceptor;

    public ReasonerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public ReasoningResult upgrade(URI url, ProgressObserver observer) {
        return null;
    }

    public ReasoningResult isConsistent(Project project, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = reasonerConfig == null ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(this.createConfiguration(project, null, reasonerConfig, true), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult check(Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = reasonerConfig == null ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(this.createConfiguration(null, cfg, reasonerConfig, true), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult propagate(Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = reasonerConfig == null ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(this.createConfiguration(null, cfg, reasonerConfig, false), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult initialize(Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = reasonerConfig == null ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(this.createConfiguration(null, cfg, reasonerConfig, false), reasonerConfig, observer, this.interceptor);
        ReasoningResult res = engine.reason();
        return res;
    }

    public EvaluationResult evaluate(Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        final EvaluationResult result = new EvaluationResult(DESCRIPTOR.getName());
        EvalVisitor evaluator = new EvalVisitor((IConfiguration)cfg, null, false, new IValueChangeListener(){

            public void notifyUnresolved(IDecisionVariable variable) {
            }

            public void notifyChanged(IDecisionVariable variable, Value oldValue, IAssignmentState oldState, IValueChangeListener.ChangeKind kind) {
                result.addAffected(variable);
            }
        });
        evaluator.setDispatchScope(cfg.getProject());
        int c = 0;
        while (c < constraints.size()) {
            EvaluationResult.ConstraintEvaluationResult eRes;
            Constraint constraint = constraints.get(c);
            evaluator.visit(constraint.getConsSyntax());
            Value eVal = null;
            if (evaluator.constraintFailed()) {
                eRes = EvaluationResult.ConstraintEvaluationResult.FALSE;
            } else if (evaluator.constraintFulfilled()) {
                eRes = EvaluationResult.ConstraintEvaluationResult.TRUE;
                eVal = evaluator.getResult();
            } else {
                eRes = EvaluationResult.ConstraintEvaluationResult.UNKNOWN;
            }
            result.addEvaluationPair(new EvaluationResult.EvaluationPair(constraint, eRes, eVal));
            int m = 0;
            while (m < evaluator.getMessageCount()) {
                EvaluationVisitor.Message eMsg = evaluator.getMessage(m);
                ArrayList<AbstractVariable> conflicts = new ArrayList<AbstractVariable>();
                conflicts.add(eMsg.getVariable());
                Message msg = new Message(eMsg.getDescription(), conflicts, eMsg.getStatus());
                ArrayList<Project> conflictProjects = new ArrayList<Project>();
                conflictProjects.add(cfg.getProject());
                msg.addConflictingElementProjects(conflictProjects);
                ArrayList problemVariables = new ArrayList();
                HashSet<IDecisionVariable> tmp = new HashSet<IDecisionVariable>();
                tmp.add(eMsg.getDecision());
                problemVariables.add(tmp);
                msg.addProblemVariables(problemVariables);
                ArrayList<Constraint> problemConstraints = new ArrayList<Constraint>();
                problemConstraints.add(constraint);
                result.addMessage(msg);
                ++m;
            }
            evaluator.clearIntermediary();
            ++c;
        }
        evaluator.clear();
        return result;
    }

    protected void activate(ComponentContext context) {
        ReasonerFrontend.getInstance().getRegistry().register((IReasoner)this);
        LOGGER.info("EASy-Producer IVML Reasoner activated");
    }

    protected void deactivate(ComponentContext context) {
        ReasonerFrontend.getInstance().getRegistry().unregister((IReasoner)this);
        LOGGER.info("EASy-Producer IVML Reasoner deactivated");
    }

    public void notify(IReasonerMessage message) {
    }

    private Configuration createConfiguration(Project project, Configuration cfg, ReasonerConfiguration rConfig, boolean freshConfig) {
        Object result = rConfig.isRuntimeMode() || !freshConfig ? cfg : null;
        if (result == null) {
            result = new Configuration(project == null ? cfg.getProject() : project, true);
        }
        return result;
    }

    public IReasonerInstance createInstance(Configuration cfg, ReasonerConfiguration reasonerConfiguration) {
        return new ReasonerInstance(cfg, reasonerConfiguration, this.interceptor);
    }

    public void setInterceptor(IReasonerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public ValueCreationResult createValue(Configuration cfg, AbstractVariable var, IDatatype type, ReasonerConfiguration reasonerConfiguration, ProgressObserver observer) {
        IDatatype t;
        ValueCreationResult result = null;
        IDatatype iDatatype = t = var != null ? var.getType() : type;
        if (t != null) {
            try {
                IDecisionVariable resVar;
                Value dflt = ValueFactory.createValue((IDatatype)t, (Object[])new Object[0]);
                Project p = new Project("*");
                AbstractVariable pVar = null;
                if (var != null) {
                    p.add((ContainableModelElement)var);
                    pVar = var;
                    if (var.getDefaultValue() == null) {
                        p.addConstraint(new Constraint((ConstraintSyntaxTree)new OCLFeatureCall((ConstraintSyntaxTree)new Variable(var), "=", new ConstraintSyntaxTree[]{new ConstantValue(dflt)}), (IModelElement)p));
                    }
                    ConstraintFunctions.addConstraintsToProject(var, cfg.getProject(), p);
                } else {
                    DecisionVariableDeclaration v = new DecisionVariableDeclaration("*", t, (IModelElement)p);
                    v.setValue((ConstraintSyntaxTree)new ConstantValue(dflt));
                    p.add((ContainableModelElement)v);
                    pVar = v;
                }
                Configuration c = new Configuration(p);
                for (IDecisionVariable tVar : c) {
                    if (tVar.getDeclaration() == pVar) continue;
                    IDecisionVariable oVar = cfg.getDecision(tVar.getDeclaration());
                    try {
                        tVar.setValue(oVar.getValue(), oVar.getState());
                    }
                    catch (ConfigurationException e) {
                        LOGGER.warn("createValue: " + e.getMessage());
                    }
                }
                ReasoningResult res = this.propagate(c, reasonerConfiguration, observer);
                if (!res.hasConflict() && (resVar = c.getDecision(pVar)) != null && resVar.getValue() != null) {
                    result = new ValueCreationResult(resVar);
                }
            }
            catch (CSTSemanticException e) {
                LOGGER.warn("createValue: " + e.getMessage());
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.warn("createValue: " + e.getMessage());
            }
        }
        if (result == null) {
            result = ReasonerHelper.createValue((Configuration)cfg, (AbstractVariable)var, (IDatatype)type, (ReasonerConfiguration)reasonerConfiguration, (ProgressObserver)observer);
        }
        return result;
    }

    private class ReasonerInstance
    implements IReasonerInstance {
        private Engine engine;
        private Configuration cfg;
        private ReasonerConfiguration reasonerConfiguration;
        private IReasonerInterceptor interceptor;

        private ReasonerInstance(Configuration cfg, ReasonerConfiguration reasonerConfiguration, IReasonerInterceptor interceptor) {
            this.cfg = cfg;
            this.interceptor = interceptor;
            this.reasonerConfiguration = reasonerConfiguration == null ? new ReasonerConfiguration() : reasonerConfiguration;
        }

        public ReasonerDescriptor getDescriptor() {
            return DESCRIPTOR;
        }

        public ReasoningResult isConsistent(ProgressObserver observer) {
            return Reasoner.this.isConsistent(this.cfg.getProject(), this.reasonerConfiguration, observer);
        }

        public ReasoningResult check(ProgressObserver observer) {
            return Reasoner.this.check(this.cfg, this.reasonerConfiguration, observer);
        }

        public ReasoningResult propagate(ProgressObserver observer) {
            if (this.engine == null) {
                this.engine = new Engine(Reasoner.this.createConfiguration(null, this.cfg, this.reasonerConfiguration, false), this.reasonerConfiguration, observer, this.interceptor);
                this.engine.markForReuse();
            } else {
                this.engine.reInit();
            }
            ReasoningResult res = this.engine.reason();
            this.engine.clear();
            return res;
        }

        public EvaluationResult evaluate(List<Constraint> constraints, ProgressObserver observer) {
            return Reasoner.this.evaluate(this.cfg, constraints, this.reasonerConfiguration, observer);
        }

        public ValueCreationResult createValue(AbstractVariable var, IDatatype type, ProgressObserver observer) {
            return Reasoner.this.createValue(this.cfg, var, type, this.reasonerConfiguration, observer);
        }

        public void notify(IReasonerMessage message) {
            Reasoner.this.notify(message);
        }

        public boolean isRunning() {
            return this.engine.isRunning();
        }

        public boolean stop() {
            return this.engine.stop();
        }

        public Project getProject() {
            return this.cfg.getProject();
        }

        public ReasonerConfiguration getReasonerConfiguration() {
            return this.reasonerConfiguration;
        }
    }
}

