/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.reasoning.core.reasoner.AnnotationAssignmentConstraint;
import net.ssehub.easy.reasoning.core.reasoner.AttachedConstraint;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintBase;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintVariableConstraint;
import net.ssehub.easy.reasoning.core.reasoner.DefaultConstraint;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.sseReasoner.CheckInitializerVisitor;
import net.ssehub.easy.reasoning.sseReasoner.EvalVisitor;
import net.ssehub.easy.reasoning.sseReasoner.RescheduleValueChangeVisitor;
import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.reasoning.sseReasoner.functions.ConstraintFunctions;
import net.ssehub.easy.reasoning.sseReasoner.functions.DefaultValueTranslator;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.reasoning.sseReasoner.functions.ScopeAssignments;
import net.ssehub.easy.reasoning.sseReasoner.model.ContextStack;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.reasoning.sseReasoner.model.SubstitutionVisitor;
import net.ssehub.easy.reasoning.sseReasoner.model.TypeCache;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInConstraintFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInNotSimpleAssignmentConstraintsFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesMap;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IResolutionListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AnnotationVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelVisitorAdapter;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

final class Resolver
implements IResolutionListener,
TypeCache.IConstraintTarget {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Resolver.class, "net.ssehub.easy.reasoning.sseReasoner");
    private static final int MODE_COMPOUND_REGISTER = 1;
    private static final int MODE_COMPOUND_TRANSLATE = 2;
    private static final int MODE_COMPOUND_NONE = -1;
    private ReasonerConfiguration reasonerConfig;
    private Configuration config;
    private boolean incremental = false;
    private boolean reuseInstance = false;
    private IAssignmentState assignmentState = AssignmentState.DERIVED;
    private boolean inRescheduling = false;
    private EvalVisitor evaluator = new EvalVisitor();
    private FailedElements failedElements = new FailedElements();
    private ScopeAssignments scopeAssignments = new ScopeAssignments();
    private VariablesMap variablesMap = new VariablesMap();
    private ReasonerState copiedState;
    private Stack<ConstraintBase> tmpBase = new Stack();
    private ConstraintBase constraintBase = new ConstraintBase();
    private DefaultConstraints defaultConstraints = new DefaultConstraints().initialize();
    private ConstraintList topLevelConstraints = new ConstraintList();
    private ConstraintList otherConstraints = new ConstraintList();
    private List<Project> projects;
    private int constraintCounter = 0;
    private int variablesInConstraintsCounter = 0;
    private int reevaluationCounter = 0;
    private int variablesCounter = 0;
    private boolean hasTimeout = false;
    private boolean isRunning = false;
    private boolean wasStopped = false;
    private long translationTime = 0L;
    private long evaluationTime = 0L;
    private Project project;
    private transient Set<Project> doneProjects = new HashSet<Project>(20);
    private transient Set<IDecisionVariable> usedVariables = new HashSet<IDecisionVariable>(100);
    private transient SubstitutionVisitor substVisitor = new SubstitutionVisitor();
    private transient ContextStack contexts = new ContextStack();
    private transient VariablesInNotSimpleAssignmentConstraintsFinder simpleAssignmentFinder = new VariablesInNotSimpleAssignmentConstraintsFinder(this.variablesMap);
    private transient ConstraintTranslationVisitor projectVisitor = new ConstraintTranslationVisitor();
    private transient VariablesInConstraintFinder variablesFinder = new VariablesInConstraintFinder();
    private transient OtherConstraintsProcessor otherConstraintsProc = new OtherConstraintsProcessor();
    private transient CompoundAnnotationMapper annotationMapper = new CompoundAnnotationMapper();
    private transient RescheduleValueChangeVisitor rescheduler = new RescheduleValueChangeVisitor(this);
    private transient CheckInitializerVisitor initChecker = new CheckInitializerVisitor(this);
    private transient long endTimestamp;
    private transient boolean inTopLevelEvals = false;

    public Resolver(Configuration config, ReasonerConfiguration reasonerConfig) {
        this.reasonerConfig = reasonerConfig;
        this.config = config;
    }

    public void localVariableCreated(LocalDecisionVariable var) {
        this.contexts.registerMapping(var.getDeclaration(), null);
    }

    public void localVariableDisposed(LocalDecisionVariable var) {
        this.contexts.unregisterMapping(var.getDeclaration());
    }

    void translateValueTypeChange(IDecisionVariable variable, Value newValue, Value oldValue) {
        IDatatype newType = newValue.getType();
        IDatatype oldType = oldValue.getType();
        if (NullValue.INSTANCE == newValue) {
            this.cleanupConstraints(variable, true, null);
        } else if (NullValue.INSTANCE == oldValue) {
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
        } else if (oldType.isAssignableFrom(newType)) {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.contexts.setTypeExcludes(types);
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
            this.contexts.setTypeExcludes(null);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        } else {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.cleanupConstraints(variable, true, types);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        }
    }

    List<Constraint> cleanupConstraints(IDecisionVariable variable, boolean clear, Set<Compound> deleteFilter) {
        List<Constraint> constraints;
        IDecisionVariable iter = variable;
        do {
            constraints = iter instanceof IDecisionVariable ? this.variablesMap.getConstraintsForVariable((IConfigurationElement)iter) : null;
            iter = iter.getParent();
        } while (constraints == null && iter != null);
        if (clear && constraints != null) {
            if (deleteFilter != null) {
                ArrayList<Constraint> toRemove = new ArrayList<Constraint>();
                int i = constraints.size() - 1;
                while (i >= 0) {
                    Constraint cst = constraints.get(i);
                    Object attachedTo = cst.getAttachedTo();
                    if (attachedTo != null && deleteFilter.contains(attachedTo)) {
                        constraints.remove(i);
                        toRemove.add(cst);
                    }
                    --i;
                }
                constraints = toRemove;
            }
            this.constraintBase.removeAll(constraints);
            int i = 0;
            while (i < this.tmpBase.size()) {
                ((ConstraintBase)this.tmpBase.get(i)).removeAll(constraints);
                ++i;
            }
            this.failedElements.removeProblemConstraints(constraints);
            this.simpleAssignmentFinder.acceptAndClear(constraints, this.config, false);
            this.variablesMap.removeAll(variable, constraints);
            constraints.clear();
        }
        return constraints;
    }

    void moveOtherConstraintsToConstraintBase(IDecisionVariable variable) {
        this.variablesMap.addAll(variable, this.otherConstraints);
        this.constraintBase.addAll(this.otherConstraints, true);
    }

    void reschedule(AbstractVariable declaration) {
        this.reschedule(this.variablesMap.getRelevantConstraints(declaration));
    }

    void reschedule(IDecisionVariable var) {
        this.reschedule(this.variablesMap.getConstraintsForVariable((IConfigurationElement)var));
    }

    private void reschedule(Collection<Constraint> constraints) {
        if (constraints != null) {
            for (Constraint varConstraint : constraints) {
                if (this.constraintBase.contains(varConstraint)) continue;
                this.constraintBase.addLast(varConstraint);
            }
        }
    }

    public void notifyResolved(IDecisionVariable compound, String slotName, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    public void notifyResolved(AbstractVariable declaration, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    public void resolve() {
        this.isRunning = true;
        this.evaluator.init((IConfiguration)this.config, null, false, this.rescheduler);
        this.evaluator.setResolutionListener(this);
        this.evaluator.setScopeAssignments(this.scopeAssignments);
        this.endTimestamp = this.reasonerConfig.getTimeout() <= 0 ? -1L : System.currentTimeMillis() + (long)this.reasonerConfig.getTimeout();
        Predicate projectFilter = this.reasonerConfig.getProjectFilter();
        if (this.copiedState == null) {
            if (this.reuseInstance) {
                this.copiedState = new ReasonerState();
            }
            this.projects = Utils.discoverImports((IModel)this.config.getProject());
            int p = 0;
            while (!this.hasTimeout && !this.wasStopped && p < this.projects.size()) {
                this.project = this.projects.get(p);
                if (projectFilter.test(this.project)) {
                    long start = System.currentTimeMillis();
                    this.translateConstraints(this.project);
                    this.evaluateConstraintBase(start, this.project);
                }
                ++p;
            }
        } else {
            this.variablesMap.clear();
            this.variablesMap.copyFrom(this.copiedState.variablesMap);
            int p = 0;
            while (!this.hasTimeout && !this.wasStopped && p < this.copiedState.constraintBase.size()) {
                this.project = this.projects.get(p);
                if (projectFilter.test(this.project)) {
                    long start = System.currentTimeMillis();
                    this.constraintBase.addAll(this.copiedState.constraintBase.get(p));
                    this.evaluateConstraintBase(start, this.project);
                }
                ++p;
            }
        }
        this.evaluator.clear();
        this.isRunning = false;
    }

    private void evaluateConstraintBase(long start, Project project) {
        long mid = System.currentTimeMillis();
        this.translationTime += mid - start;
        this.evaluateConstraints(project);
        long end = System.currentTimeMillis();
        this.evaluationTime += end - mid;
        this.config.freezeValues(project, FilterType.NO_IMPORTS);
        this.doneProjects.add(project);
    }

    private void evaluateConstraints(Project project) {
        this.scopeAssignments.clearScopeAssignments(project);
        this.evaluator.setDispatchScope(project);
        while (!this.constraintBase.isEmpty() && !this.wasStopped) {
            this.evaluateConstraint(this.constraintBase.removeFirst(), true);
            if (this.endTimestamp <= 0L || System.currentTimeMillis() <= this.endTimestamp) continue;
            this.hasTimeout = true;
            break;
        }
    }

    private void evaluateConstraint(Constraint constraint, boolean top) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        if (cst != null) {
            DefaultConstraint dCst;
            boolean evaluated = false;
            Constraint.IConstraintType type = constraint.getType();
            if ((type == Constraint.Type.DEFAULT || type == Constraint.Type.ANNOTATION_ASSIGNMENT) && this.doneProjects.contains(constraint.getProject())) {
                evaluated = true;
            }
            if (!evaluated && constraint instanceof DefaultConstraint && (dCst = (DefaultConstraint)constraint).getAttachedConstraintsSize() > 0) {
                ConstraintBase dflt = new ConstraintBase();
                dflt.addAll(dCst.getDefaultConstraints(), true);
                dflt.addAll(dCst.getDeferredDefaultConstraints(), true);
                this.tmpBase.push(this.constraintBase);
                this.constraintBase = dflt;
                while (!dflt.isEmpty() && !this.wasStopped) {
                    this.evaluateConstraint(dflt.removeFirst(), false);
                    if (this.endTimestamp <= 0L || System.currentTimeMillis() <= this.endTimestamp) continue;
                    this.hasTimeout = true;
                    break;
                }
                this.constraintBase = this.tmpBase.pop();
                this.evaluateConstraint(constraint, cst);
                evaluated = true;
            }
            if (!evaluated) {
                this.evaluateConstraint(constraint, cst);
            }
        }
    }

    private void evaluateConstraint(Constraint constraint, ConstraintSyntaxTree cst) {
        this.usedVariables.clear();
        this.scopeAssignments.setCurrentScope(constraint);
        this.evaluator.setAssignmentState((IAssignmentState)(Constraint.Type.DEFAULT == constraint.getType() || Constraint.Type.ANNOTATION_ASSIGNMENT == constraint.getType() ? AssignmentState.DEFAULT : this.assignmentState));
        ++this.reevaluationCounter;
        this.evaluator.visit(cst);
        this.analyzeEvaluationResult(constraint);
        this.evaluator.clearIntermediary();
    }

    private void translateDerivedDatatypeConstraints(AbstractVariable decl, IDatatype type, DecisionVariableDeclaration localDecl, IModelElement parent, int refCounter, ConstraintSyntaxTree cAcc) {
        if (type instanceof DerivedDatatype) {
            AbstractVariable declaration;
            DerivedDatatype dType = (DerivedDatatype)type;
            int count = dType.getConstraintCount();
            DecisionVariableDeclaration dVar = dType.getTypeDeclaration();
            Object object = declaration = localDecl == null ? decl : localDecl;
            if (count > 0 && dVar != declaration) {
                this.substVisitor.setMappings(this.contexts);
                if (cAcc != null) {
                    this.substVisitor.addVariableMapping((AbstractVariable)dVar, cAcc);
                } else {
                    this.substVisitor.addVariableMapping((AbstractVariable)dVar, declaration, refCounter);
                }
                int i = 0;
                while (i < count) {
                    ConstraintSyntaxTree cst = dType.getConstraint(i).getConsSyntax();
                    if (localDecl != null) {
                        cst = ReasoningUtils.createContainerCall((ConstraintSyntaxTree)new Variable(decl), Container.FORALL, cst, localDecl);
                    }
                    cst = this.substVisitor.accept(cst);
                    try {
                        cst.inferDatatype();
                        this.addConstraint(this.topLevelConstraints, new Constraint(cst, parent), true, null, null);
                    }
                    catch (CSTSemanticException e) {
                        LOGGER.exception((Exception)((Object)e));
                    }
                    ++i;
                }
                this.substVisitor.clear();
            }
            this.translateDerivedDatatypeConstraints(decl, dType.getBasisType(), localDecl, parent, refCounter, null);
        } else if (type instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, ((Reference)type).getType(), localDecl, parent, refCounter + 1, null);
        }
    }

    private void translateAnnotationDeclarations(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc) {
        boolean isNested;
        ConstraintSyntaxTree acc = cAcc == null ? new Variable(decl) : cAcc;
        boolean bl = isNested = this.contexts.size() > 1 || TypeQueries.isCompound((IDatatype)DerivedDatatype.resolveToBasis((IDatatype)variable.getDeclaration().getType()));
        if (variable != null) {
            int i = 0;
            while (i < variable.getAttributesCount()) {
                IDecisionVariable att = variable.getAttribute(i);
                if (!this.contexts.isKnownAnnotationAssignment(att.getDeclaration().getName())) {
                    this.translateAnnotationDeclaration((Attribute)att.getDeclaration(), att, acc, isNested);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < decl.getAttributesCount()) {
                this.translateAnnotationDeclaration(decl.getAttribute(i), null, acc, isNested);
                ++i;
            }
        }
    }

    private void translateAnnotationDeclaration(Attribute decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc, boolean qualifyAttribute) {
        ConstraintSyntaxTree attAcc = cAcc;
        if (cAcc != null && (qualifyAttribute || TypeQueries.isCompound((IDatatype)DerivedDatatype.resolveToBasis((IDatatype)decl.getType())))) {
            attAcc = new AttributeVariable(cAcc, decl);
        }
        this.translateDeclaration((AbstractVariable)decl, variable, attAcc);
    }

    private void translateDeclaration(AbstractVariable decl, IDecisionVariable var, ConstraintSyntaxTree cAcc) {
        IDatatype declType;
        ++this.variablesCounter;
        IDatatype actType = declType = decl.getType();
        ConstraintSyntaxTree defaultValue = this.incremental ? null : decl.getDefaultValue();
        AbstractVariable self = null;
        ConstraintSyntaxTree selfEx = null;
        DefaultConstraints tmpDflt = null;
        if (var != null && var.getValue() != null) {
            actType = var.getValue().getType();
        } else if (defaultValue != null) {
            actType = ReasoningUtils.inferTypeSafe(defaultValue, actType);
        }
        actType = DerivedDatatype.resolveToBasis((IDatatype)actType);
        int compoundMode = -1;
        boolean isCompound = TypeQueries.isCompound((IDatatype)actType);
        ConstraintSyntaxTree tCAcc = null;
        TypeCache.Entry tcEntry = null;
        if (isCompound) {
            self = decl;
            tCAcc = Resolver.checkTypeCast(declType, actType, decl, cAcc);
            compoundMode = this.translateCompoundDeclaration(decl, var, tCAcc, (Compound)actType, 1);
            tcEntry = this.contexts.getInConstruction(true);
        }
        if (!(defaultValue == null || decl.isAttribute() && decl.getParent() instanceof AttributeAssignment)) {
            if (cAcc instanceof CompoundAccess) {
                selfEx = ((CompoundAccess)cAcc).getCompoundExpression();
            }
            if (TypeQueries.isConstraint((IDatatype)declType)) {
                --this.variablesCounter;
                this.createConstraintVariableConstraint(defaultValue, selfEx, self, (IModelElement)decl, var);
            }
            if (!this.contexts.constraintVarOnly(false)) {
                Object acc;
                if (decl instanceof Attribute) {
                    Attribute attribute = (Attribute)decl;
                    acc = cAcc == null ? new Variable((AbstractVariable)attribute) : (cAcc instanceof AttributeVariable ? cAcc : new AttributeVariable(cAcc, attribute));
                } else {
                    acc = selfEx != null ? cAcc : new Variable(decl);
                }
                defaultValue = new OCLFeatureCall(acc, "=", new ConstraintSyntaxTree[]{DefaultValueTranslator.translateDefaultValueSafe(defaultValue)});
                ReasoningUtils.inferTypeSafe(defaultValue, null);
                defaultValue = this.substituteVariables(defaultValue, selfEx, self, (ConstraintSyntaxTree)acc);
                tmpDflt = new DefaultConstraints();
                this.addDefaultConstraint(decl, defaultValue, tmpDflt, isCompound, var);
            }
            this.substVisitor.clear();
        }
        if (!this.incremental) {
            this.translateAnnotationDeclarations(decl, var, cAcc);
        }
        this.translateDerivedDatatypeConstraints(decl, declType, null, decl.getTopLevelParent(), 0, cAcc);
        if (isCompound) {
            this.contexts.setInConstruction(tcEntry);
            this.translateCompoundDeclaration(decl, var, tCAcc, (Compound)actType, compoundMode);
        } else if (TypeQueries.isContainer((IDatatype)actType)) {
            this.translateContainerDeclaration(decl, var, actType, cAcc);
        }
        this.transfer(null, tmpDflt, isCompound);
    }

    private void addDefaultConstraint(AbstractVariable decl, ConstraintSyntaxTree defaultValue, DefaultConstraints tmp, boolean enable, IDecisionVariable var) {
        try {
            ConstraintList targetCons = this.defaultConstraints.defaultConstraints;
            if (this.substVisitor.containsSelf() || ReasoningUtils.isOverriddenSlot(decl)) {
                targetCons = this.defaultConstraints.deferredDefaultConstraints;
            }
            DefaultConstraint c = this.transfer(new DefaultConstraint(defaultValue, (IModelElement)this.project), tmp, enable);
            this.addConstraint(targetCons, (Constraint)c, true, var, null);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception((Exception)((Object)e));
        }
    }

    private DefaultConstraint transfer(DefaultConstraint constraint, DefaultConstraints tmp, boolean enable) {
        if (enable) {
            if (constraint != null) {
                tmp.defaultConstraints = this.defaultConstraints.defaultConstraints;
                tmp.deferredDefaultConstraints = this.defaultConstraints.deferredDefaultConstraints;
                this.defaultConstraints.initialize();
                constraint.setDefaultConstraints(this.defaultConstraints.defaultConstraints);
                constraint.setDeferredDefaultConstraints(this.defaultConstraints.deferredDefaultConstraints);
            } else if (tmp != null && tmp.defaultConstraints != null) {
                this.defaultConstraints.defaultConstraints = tmp.defaultConstraints;
                this.defaultConstraints.deferredDefaultConstraints = tmp.deferredDefaultConstraints;
            }
        }
        return constraint;
    }

    private static ConstraintSyntaxTree checkTypeCast(IDatatype declType, IDatatype actType, AbstractVariable decl, ConstraintSyntaxTree cAcc) {
        if (!TypeQueries.sameTypes((IDatatype)declType, (IDatatype)actType)) {
            if (cAcc == null) {
                cAcc = new Variable(decl);
            }
            cAcc = ReasoningUtils.createAsTypeCast(cAcc, declType, actType);
        }
        return cAcc;
    }

    private void translateContainerDeclaration(AbstractVariable decl, IDecisionVariable var, IDatatype type, ConstraintSyntaxTree cAcc) {
        this.contexts.pushContext(decl, false);
        Container declType = (Container)type;
        IDatatype dContainedType = ReasoningUtils.getDeepestContainedType(declType);
        IDatatype dContainedBasisType = DerivedDatatype.resolveToBasis((IDatatype)dContainedType);
        ContainerValue val = ReasoningUtils.getRelevantValue(decl, var, this.incremental, ContainerValue.class);
        if (TypeQueries.isConstraint((IDatatype)dContainedBasisType)) {
            if (val != null) {
                this.createContainerConstraintValueConstraints(val, cAcc, null, (IModelElement)decl, var);
            }
        } else if (TypeQueries.isCompound((IDatatype)dContainedBasisType)) {
            Set used = (Set)ReasoningUtils.SET_COMPOUND_POOL.getInstance();
            if (val != null) {
                ReasoningUtils.getUsedCompoundTypes((Value)val, used);
                Set tmp = (Set)ReasoningUtils.SET_COMPOUND_POOL.getInstance();
                ReasoningUtils.purgeRefines(used, (Set<Compound>)tmp);
                ReasoningUtils.SET_COMPOUND_POOL.releaseInstance((Object)used);
                used = tmp;
            } else if (dContainedBasisType instanceof Compound) {
                used.add((Compound)dContainedBasisType);
            }
            for (Compound uType : used) {
                this.translateCompoundContainer(decl, uType, dContainedType, cAcc);
            }
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance((Object)used);
        }
        if (dContainedType instanceof DerivedDatatype || dContainedType instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, dContainedType, new DecisionVariableDeclaration("derivedType", dContainedType, null), (IModelElement)this.project, 0, null);
        }
        this.contexts.popContext();
    }

    private void translateCompoundContainer(AbstractVariable decl, Compound type, IDatatype declaredContainedType, ConstraintSyntaxTree cAcc) {
        if (!this.contexts.alreadyProcessed((IDatatype)type)) {
            this.contexts.recordProcessed((IDatatype)type);
            DecisionVariableDeclaration localDecl = new DecisionVariableDeclaration("cmp" + this.contexts.size(), (IDatatype)type, null);
            Variable localVar = new Variable((AbstractVariable)localDecl);
            Variable declVar = new Variable(decl);
            Variable containerOp = cAcc == null ? declVar : cAcc;
            try {
                if (TypeQueries.isSequence((IDatatype)decl.getType())) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "asSet", new ConstraintSyntaxTree[0]);
                }
                if (ReasoningUtils.isNestedContainer(decl.getType())) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "flatten", new ConstraintSyntaxTree[0]);
                }
                if (!TypeQueries.sameTypes((IDatatype)type, (IDatatype)declaredContainedType)) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "selectByKind", new ConstraintSyntaxTree[]{ReasoningUtils.createTypeValueConstant((IDatatype)type)});
                }
            }
            catch (IvmlException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            this.contexts.pushContext(null, (ConstraintSyntaxTree)containerOp, localDecl, true);
            this.registerCompoundMapping(type, (ConstraintSyntaxTree)localVar, declVar);
            this.translateCompoundContent((AbstractVariable)localDecl, null, type, (ConstraintSyntaxTree)localVar);
            this.contexts.popContext();
        }
    }

    private int translateCompoundDeclaration(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc, Compound type, int mode) {
        int nextMode = -1;
        if (!this.contexts.alreadyProcessed((IDatatype)type) && 1 == mode) {
            ContextStack.TranslateMode tMode = this.contexts.getMappingMode((IDatatype)type);
            this.contexts.pushContext(decl, variable == null);
            this.contexts.recordAnnotationAssignments(type);
            if (tMode != ContextStack.TranslateMode.NOTHING) {
                if (!decl.isAttribute() && tMode != ContextStack.TranslateMode.TRANSFER) {
                    this.contexts.registerForTypeCache((IDatatype)type, decl);
                }
                this.contexts.transferTypeExcludes((IDatatype)type);
                if (tMode == ContextStack.TranslateMode.TRANSFER) {
                    this.contexts.transferToContext((IDatatype)type, decl);
                } else {
                    this.registerCompoundMapping(type, cAcc, new Variable(decl));
                }
            }
            nextMode = 2;
        }
        if (2 == mode) {
            if (!this.contexts.transferConstraints((IDatatype)type, this, variable, decl)) {
                this.translateCompoundContent(decl, variable, type, cAcc);
            }
            this.contexts.popContext((IDatatype)type);
            this.contexts.recordProcessed((IDatatype)type);
            nextMode = -1;
        }
        return nextMode;
    }

    private void registerCompoundMapping(Compound type, ConstraintSyntaxTree cAcc, Variable declVar) {
        this.registerCompoundSlotMapping(type, cAcc, declVar);
        this.annotationMapper.initialize(cAcc, declVar);
        try {
            this.annotationMapper.visitAnnotations((IAttributeAccess)declVar.getVariable());
        }
        catch (IvmlException ivmlException) {
            // empty catch block
        }
        this.annotationMapper.clear();
    }

    private void registerCompoundSlotMapping(Compound type, ConstraintSyntaxTree cAcc, Variable declVar) {
        int i = 0;
        int n = type.getDeclarationCount();
        while (i < n) {
            DecisionVariableDeclaration nestedDecl = type.getDeclaration(i);
            ConstraintSyntaxTree acc = this.contexts.getLocalMapping(nestedDecl.getName());
            if (acc == null) {
                acc = cAcc == null ? new CompoundAccess((ConstraintSyntaxTree)declVar, nestedDecl.getName()) : new CompoundAccess(cAcc, nestedDecl.getName());
            }
            this.contexts.registerMapping((AbstractVariable)nestedDecl, acc);
            int a = 0;
            int m = nestedDecl.getAttributesCount();
            while (a < m) {
                Attribute attr = nestedDecl.getAttribute(a);
                AttributeVariable aAcc = new AttributeVariable(acc, attr);
                this.contexts.registerMapping((AbstractVariable)attr, (ConstraintSyntaxTree)aAcc);
                ++a;
            }
            ++i;
        }
        int r = 0;
        n = type.getRefinesCount();
        while (r < n) {
            this.registerCompoundSlotMapping(type.getRefines(r), cAcc, declVar);
            ++r;
        }
    }

    private void translateCompoundContent(AbstractVariable decl, IDecisionVariable variable, Compound type, ConstraintSyntaxTree cAcc) {
        if (variable != null) {
            if (variable.getValue() != null) {
                type = (Compound)variable.getValue().getType();
                cAcc = Resolver.checkTypeCast(decl.getType(), variable.getValue().getType(), decl, cAcc);
            }
            i = 0;
            n = variable.getNestedElementsCount();
            while (i < n) {
                IDecisionVariable nestedVar = variable.getNestedElement(i);
                AbstractVariable nestedDecl = nestedVar.getDeclaration();
                if (!this.contexts.isElementTypeExcluded(nestedDecl.getParent())) {
                    this.translateDeclaration(nestedDecl, nestedVar, this.getNestedAccessor(nestedDecl, cAcc));
                }
                ++i;
            }
        } else {
            i = 0;
            n = type.getInheritedElementCount();
            while (i < n) {
                DecisionVariableDeclaration nestedDecl = type.getInheritedElement(i);
                if (!this.contexts.isElementTypeExcluded(nestedDecl.getParent())) {
                    this.translateDeclaration((AbstractVariable)nestedDecl, null, this.getNestedAccessor((AbstractVariable)nestedDecl, cAcc));
                }
                ++i;
            }
        }
        if (!this.incremental) {
            int a = 0;
            while (a < type.getAssignmentCount()) {
                this.translateAnnotationAssignments(type.getAssignment(a), variable, null, cAcc);
                ++a;
            }
        }
        AbstractVariable self = cAcc == null ? decl : null;
        this.processCompoundEvals(type, cAcc, self, variable);
        this.otherConstraintsProc.setParameter(cAcc, self, variable);
        ConstraintFunctions.allCompoundConstraints(type, this.otherConstraintsProc, false, false, (IModelElement)decl);
        this.otherConstraintsProc.clear();
    }

    private ConstraintSyntaxTree getNestedAccessor(AbstractVariable nestedDecl, ConstraintSyntaxTree cAcc) {
        return cAcc == null ? this.contexts.getMapping(nestedDecl) : new CompoundAccess(cAcc, nestedDecl.getName());
    }

    private void processCompoundEvals(Compound cmpType, ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
        if (!this.contexts.isTypeExcluded((IDatatype)cmpType)) {
            int r = 0;
            while (r < cmpType.getRefinesCount()) {
                this.processCompoundEvals(cmpType.getRefines(r), selfEx, self, variable);
                ++r;
            }
            int i = 0;
            while (i < cmpType.getModelElementCount()) {
                if (cmpType.getModelElement(i) instanceof PartialEvaluationBlock) {
                    PartialEvaluationBlock evalBlock = (PartialEvaluationBlock)cmpType.getModelElement(i);
                    this.processEvalConstraints(evalBlock, selfEx, self, variable);
                }
                ++i;
            }
        }
    }

    private void processEvalConstraints(PartialEvaluationBlock evalBlock, ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
        int i = 0;
        while (i < evalBlock.getNestedCount()) {
            this.processEvalConstraints(evalBlock.getNested(i), selfEx, self, variable);
            ++i;
        }
        i = 0;
        while (i < evalBlock.getEvaluableCount()) {
            if (evalBlock.getEvaluable(i) instanceof Constraint) {
                Constraint evalConstraint = (Constraint)evalBlock.getEvaluable(i);
                ConstraintSyntaxTree evalCst = evalConstraint.getConsSyntax();
                ConstraintSyntaxTree cst = this.substituteVariables(evalCst, selfEx, self, null);
                try {
                    Constraint constraint = new Constraint(cst, (IModelElement)this.project);
                    this.addConstraint(this.otherConstraints, constraint, true, null, variable);
                }
                catch (CSTSemanticException e) {
                    LOGGER.exception((Exception)((Object)e));
                }
            }
            ++i;
        }
    }

    void createContainerConstraintValueConstraints(ContainerValue val, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable nestedVariable) {
        int n = 0;
        while (n < val.getElementSize()) {
            Value cVal = val.getElement(n);
            ConstraintSyntaxTree cst = ReasoningUtils.getConstraintValueExpression(cVal);
            if (cst != null) {
                this.createConstraintVariableConstraint(cst, selfEx, self, parent, nestedVariable);
            } else if (cVal instanceof ContainerValue) {
                this.createContainerConstraintValueConstraints((ContainerValue)cVal, selfEx, self, parent, nestedVariable);
            }
            ++n;
        }
    }

    private void translateAnnotationAssignments(AttributeAssignment assignment, IDecisionVariable var, List<AttributeAssignment.Assignment> effectiveAssignments, ConstraintSyntaxTree compound) {
        ArrayList<AttributeAssignment.Assignment> assng = effectiveAssignments == null ? new ArrayList<AttributeAssignment.Assignment>() : effectiveAssignments;
        int d = 0;
        while (d < assignment.getAssignmentDataCount()) {
            assng.add(assignment.getAssignmentData(d));
            ++d;
        }
        HashSet<String> done = new HashSet<String>();
        int d2 = assng.size() - 1;
        while (d2 >= 0) {
            AttributeAssignment.Assignment effectiveAssignment = (AttributeAssignment.Assignment)assng.get(d2);
            String name = effectiveAssignment.getName();
            if (!done.contains(name)) {
                done.add(name);
                int e = 0;
                while (e < assignment.getElementCount()) {
                    DecisionVariableDeclaration aElt = assignment.getElement(e);
                    String aEltName = aElt.getName();
                    this.translateAnnotationAssignment(effectiveAssignment, aElt, compound);
                    IDatatype aEltType = aElt.getType();
                    if (TypeQueries.isCompound((IDatatype)aEltType)) {
                        IDecisionVariable v;
                        Compound cmp = (Compound)aEltType;
                        if (var != null && (v = var.getNestedElement(aEltName)) != null && v.getValue() != null) {
                            aEltType = v.getValue().getType();
                        }
                        Object acc = compound != null ? new CompoundAccess(compound, aEltName) : (var != null ? new CompoundAccess((ConstraintSyntaxTree)new Variable(var.getDeclaration()), aEltName) : new Variable((AbstractVariable)aElt));
                        int s = 0;
                        while (s < cmp.getDeclarationCount()) {
                            DecisionVariableDeclaration slot = cmp.getDeclaration(s);
                            if (!(slot.getParent() instanceof AttributeAssignment)) {
                                this.translateAnnotationAssignment(effectiveAssignment, slot, (ConstraintSyntaxTree)new CompoundAccess((ConstraintSyntaxTree)acc, slot.getName()));
                            }
                            ++s;
                        }
                    }
                    ++e;
                }
            }
            --d2;
        }
        int a = 0;
        while (a < assignment.getAssignmentCount()) {
            this.translateAnnotationAssignments(assignment.getAssignment(a), var, assng, compound);
            ++a;
        }
    }

    private void translateAnnotationAssignment(AttributeAssignment.Assignment assignment, DecisionVariableDeclaration element, ConstraintSyntaxTree compound) {
        Attribute attrib = ModelQuery.findAttribute((IModelElement)element, (String)assignment.getName());
        if (attrib != null) {
            ConstraintSyntaxTree origCompound = compound;
            if (compound == null) {
                compound = this.contexts.getMapping((AbstractVariable)element);
            }
            AttributeVariable cst = compound == null ? new AttributeVariable((ConstraintSyntaxTree)new Variable((AbstractVariable)element), attrib) : (origCompound != null ? new AttributeVariable((ConstraintSyntaxTree)new CompoundAccess(compound, element.getName()), attrib) : new AttributeVariable(compound, attrib));
            cst = new OCLFeatureCall((ConstraintSyntaxTree)cst, "=", new ConstraintSyntaxTree[]{assignment.getExpression()});
            cst = this.substituteVariables((ConstraintSyntaxTree)cst, compound, null, null);
            try {
                this.addConstraint(this.otherConstraints, (Constraint)new AnnotationAssignmentConstraint((ConstraintSyntaxTree)cst, (IModelElement)this.project), false, null, null);
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
    }

    private void translateConstraints(Project project) {
        project.accept((IModelVisitor)this.projectVisitor);
        this.defaultConstraints.transfer((ConstraintList)this.constraintBase, true);
        this.constraintBase.addAll(this.topLevelConstraints, true);
        this.constraintBase.addAll(this.otherConstraints, true);
        this.constraintCounter += this.constraintBase.size();
        this.variablesInConstraintsCounter += this.variablesMap.getDeclarationSize();
        if (this.copiedState != null) {
            ConstraintList copy = new ConstraintList();
            copy.addAll((ConstraintList)this.constraintBase);
            this.copiedState.constraintBase.add(copy);
        }
        this.contexts.clear();
    }

    private void addConstraint(ConstraintList target, Constraint constraint, boolean checkForInitializers, IDecisionVariable variable, IDecisionVariable register) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        try {
            cst = this.contexts.composeExpression(cst);
            constraint.setConsSyntax(cst);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        if (checkForInitializers) {
            try {
                constraint.setConsSyntax(this.initChecker.accept(cst, constraint.getParent(), variable));
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        boolean add = true;
        if (this.incremental) {
            boolean bl = add = !CSTUtils.isAssignment((ConstraintSyntaxTree)cst);
            if (add) {
                this.variablesFinder.setConfiguration(this.config);
                cst.accept((IConstraintTreeVisitor)this.variablesFinder);
                add = !this.variablesFinder.isConstraintFrozen();
                this.variablesFinder.clear();
            }
        }
        if (add) {
            boolean first = this.inTopLevelEvals && (target == this.otherConstraints || target == this.topLevelConstraints);
            this.addConstraint(target, first, constraint, register);
        }
    }

    @Override
    public final void addConstraint(ConstraintList target, boolean first, Constraint constraint, IDecisionVariable register) {
        if (first) {
            target.addFirst(constraint);
        } else {
            target.addLast(constraint);
        }
        this.simpleAssignmentFinder.acceptAndClear(constraint, this.config);
        if (register != null) {
            this.variablesMap.registerConstraint(register, constraint);
            if (this.copiedState != null) {
                this.copiedState.variablesMap.registerConstraint(register, constraint);
            }
        }
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable variable) {
        boolean cvo = this.contexts.constraintVarOnly(true);
        Constraint result = this.createConstraintVariableConstraint(cst, self, !((cst = this.substituteVariables(cst, selfEx, self, null)) instanceof ConstantValue), parent, variable);
        this.contexts.setConstraintVarOnly(cvo);
        return result;
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, AbstractVariable self, boolean checkForInitializers, IModelElement parent, IDecisionVariable variable) {
        ConstraintVariableConstraint constraint = null;
        try {
            constraint = new ConstraintVariableConstraint(cst, parent);
            this.addConstraint(this.otherConstraints, (Constraint)constraint, checkForInitializers, variable, variable);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        return constraint;
    }

    private void analyzeEvaluationResult(Constraint constraint) {
        if (this.evaluator.constraintFailed()) {
            FailedElementDetails failedElementDetails = new FailedElementDetails();
            failedElementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
            failedElementDetails.setProblemConstraintPart(this.getFailedConstraintPart());
            failedElementDetails.setProblemConstraint(constraint);
            failedElementDetails.setErrorClassifier(102);
            this.failedElements.addProblemConstraint(constraint, failedElementDetails);
        } else if (this.evaluator.constraintFulfilled()) {
            this.failedElements.removeProblemConstraint(constraint);
        }
        int j = 0;
        while (j < this.evaluator.getMessageCount()) {
            EvaluationVisitor.Message msg = this.evaluator.getMessage(j);
            AbstractVariable var = msg.getVariable();
            if (var != null) {
                if (!(var.getParent() instanceof OperationDefinition) && !(var.getParent() instanceof Constraint)) {
                    this.usedVariables.clear();
                    this.usedVariables.add(msg.getDecision());
                    FailedElementDetails failedelementDetails = new FailedElementDetails();
                    failedelementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
                    failedelementDetails.setProblemConstraintPart(constraint.getConsSyntax());
                    failedelementDetails.setProblemConstraint(constraint);
                    failedelementDetails.setErrorClassifier(101);
                    this.failedElements.addProblemVariable(var, failedelementDetails);
                }
            } else {
                this.failedElements.addMessage(constraint, msg);
            }
            ++j;
        }
        if (this.evaluator.constraintFulfilled() && Constraint.Type.DEFAULT == constraint.getType()) {
            this.simpleAssignmentFinder.acceptAndClear(constraint, this.config, false);
        }
    }

    ConstraintSyntaxTree substituteVariables(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self, ConstraintSyntaxTree acc) {
        this.substVisitor.setMappings(this.contexts);
        if (acc != null) {
            this.substVisitor.excludeFromMapping(acc);
        }
        if (selfEx != null) {
            this.substVisitor.setSelf(selfEx);
        }
        if (self != null) {
            this.substVisitor.setSelf(self);
        }
        cst = this.substVisitor.acceptAndClear(cst);
        ReasoningUtils.inferTypeSafe(cst, null);
        return cst;
    }

    private void conflictingDefault(AbstractVariable decl) {
    }

    private ConstraintSyntaxTree getFailedConstraintPart() {
        ConstraintSyntaxTree cstPart = null;
        if (this.evaluator.getFailedExpression() != null) {
            cstPart = this.evaluator.getFailedExpression()[0];
        }
        return cstPart;
    }

    IDecisionVariable getConstraintVariable(Constraint constraint) {
        return this.variablesMap.getDecisionVariableForConstraint(constraint);
    }

    int constraintCount() {
        return this.constraintCounter;
    }

    int variableCount() {
        return this.variablesCounter;
    }

    int variableInConstraintCount() {
        return this.variablesInConstraintsCounter;
    }

    int reevaluationCount() {
        return this.reevaluationCounter;
    }

    FailedElements getFailedElements() {
        return this.failedElements;
    }

    boolean setIncremental(boolean incremental) {
        boolean old = this.incremental;
        this.incremental = incremental;
        return old;
    }

    protected EvaluationVisitor createEvaluationVisitor() {
        return new EvalVisitor();
    }

    boolean hasTimeout() {
        return this.hasTimeout;
    }

    boolean wasStopped() {
        return this.wasStopped;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    boolean stop() {
        this.wasStopped = true;
        return true;
    }

    void markForReuse() {
        this.reuseInstance = true;
    }

    void clear() {
        this.tmpBase.clear();
        this.defaultConstraints.clear();
        this.topLevelConstraints.clear();
        this.otherConstraints.clear();
        this.failedElements.clear();
        this.scopeAssignments.clear();
        this.constraintBase.clear();
        this.constraintCounter = 0;
        this.variablesInConstraintsCounter = 0;
        this.reevaluationCounter = 0;
        this.variablesCounter = 0;
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.inRescheduling = false;
        this.usedVariables.clear();
        this.doneProjects.clear();
        this.substVisitor.clear();
        this.contexts.clear();
        this.simpleAssignmentFinder.clear();
    }

    void reInit() {
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.inRescheduling = false;
        this.constraintCounter = 0;
        this.variablesInConstraintsCounter = 0;
        this.reevaluationCounter = 0;
        this.translationTime = 0L;
        this.evaluationTime = 0L;
        this.failedElements.clear();
        this.assignmentState = AssignmentState.DERIVED;
    }

    long getEvaluationTime() {
        return this.evaluationTime;
    }

    long getTranslationTime() {
        return this.translationTime;
    }

    void setAssignmentState(IAssignmentState state) {
        if (state != null) {
            this.assignmentState = state;
        }
    }

    final void addAssignedVariableToScope(IDecisionVariable variable) {
        this.scopeAssignments.addAssignedVariable(variable);
    }

    final boolean contextContainsMapping(AbstractVariable var) {
        return this.contexts.containsMapping(var);
    }

    final void contextRegisterMapping(AbstractVariable var, ConstraintSyntaxTree acc) {
        this.contexts.registerMapping(var, acc);
    }

    final void notifyRescheduling(boolean inRescheduling) {
        this.inRescheduling = inRescheduling;
    }

    @Override
    public boolean inRescheduling() {
        return this.inRescheduling;
    }

    private class CompoundAnnotationMapper
    extends AnnotationVisitor {
        private ConstraintSyntaxTree cAcc;
        private Variable declVar;

        private CompoundAnnotationMapper() {
        }

        protected void initialize(ConstraintSyntaxTree cAcc, Variable declVar) {
            this.cAcc = cAcc;
            this.declVar = declVar;
        }

        protected void clear() {
            this.cAcc = null;
            this.declVar = null;
        }

        protected void processAttributeAssignment(AttributeAssignment assng) throws IvmlException {
        }

        protected void processAttribute(Attribute attr) throws IvmlException {
            AttributeVariable acc = this.cAcc == null ? new AttributeVariable((ConstraintSyntaxTree)this.declVar, attr) : new AttributeVariable(this.cAcc, attr);
            Attribute iter = attr;
            while (iter != null) {
                Resolver.this.contexts.registerMapping((AbstractVariable)iter, (ConstraintSyntaxTree)acc);
                iter = iter.getOrigin();
            }
        }
    }

    private class ConstraintTranslationVisitor
    extends ModelVisitorAdapter {
        private List<PartialEvaluationBlock> evals = null;

        private ConstraintTranslationVisitor() {
        }

        public void visitProject(Project project) {
            int e = 0;
            while (e < project.getElementCount()) {
                project.getElement(e).accept((IModelVisitor)this);
                ++e;
            }
            if (this.evals != null) {
                Resolver.this.inTopLevelEvals = true;
                for (PartialEvaluationBlock block : this.evals) {
                    int i = 0;
                    while (i < block.getNestedCount()) {
                        block.getNested(i).accept((IModelVisitor)this);
                        ++i;
                    }
                    i = 0;
                    while (i < block.getEvaluableCount()) {
                        block.getEvaluable(i).accept((IModelVisitor)this);
                        ++i;
                    }
                }
                Resolver.this.inTopLevelEvals = false;
            }
        }

        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            Resolver.this.translateDeclaration((AbstractVariable)decl, Resolver.this.config.getDecision((AbstractVariable)decl), null);
        }

        public void visitConstraint(Constraint constraint) {
            Resolver.this.addConstraint(Resolver.this.topLevelConstraints, constraint, true, null, null);
        }

        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
            if (!Resolver.this.inTopLevelEvals) {
                if (this.evals == null) {
                    this.evals = new LinkedList<PartialEvaluationBlock>();
                }
                this.evals.add(block);
            }
        }

        public void visitAttributeAssignment(AttributeAssignment assignment) {
            int v = 0;
            while (v < assignment.getElementCount()) {
                assignment.getElement(v).accept((IModelVisitor)this);
                ++v;
            }
            int c = 0;
            while (c < assignment.getConstraintsCount()) {
                Resolver.this.addConstraint(Resolver.this.topLevelConstraints, assignment.getConstraint(c), true, null, null);
                ++c;
            }
            int a = 0;
            while (a < assignment.getAssignmentCount()) {
                assignment.getAssignment(a).accept((IModelVisitor)this);
                ++a;
            }
            if (!Resolver.this.incremental) {
                Resolver.this.translateAnnotationAssignments(assignment, null, null, null);
            }
        }
    }

    private static class DefaultConstraints {
        private ConstraintList defaultConstraints;
        private ConstraintList deferredDefaultConstraints;

        private DefaultConstraints() {
        }

        private DefaultConstraints initialize() {
            this.defaultConstraints = new ConstraintList();
            this.deferredDefaultConstraints = new ConstraintList();
            return this;
        }

        private void clear() {
            this.defaultConstraints.clear();
            this.deferredDefaultConstraints.clear();
        }

        private void transfer(ConstraintList target, boolean clear) {
            target.addAll(this.defaultConstraints, clear);
            target.addAll(this.deferredDefaultConstraints, clear);
        }
    }

    private class OtherConstraintsProcessor
    extends AbstractConstraintProcessor {
        private ConstraintSyntaxTree selfEx;
        private AbstractVariable self;
        private IDecisionVariable variable;

        private OtherConstraintsProcessor() {
        }

        private void setParameter(ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
            this.selfEx = selfEx;
            this.self = self;
            this.variable = variable;
        }

        private void clear() {
            this.selfEx = null;
            this.self = null;
            this.variable = null;
        }

        @Override
        public ConstraintSyntaxTree process(ConstraintSyntaxTree cst, AbstractConstraintProcessor.ExpressionType type, String slot, IModelElement parent) {
            cst = Resolver.this.substituteVariables(cst, this.selfEx, this.self, null);
            try {
                AttachedConstraint constraint = new AttachedConstraint(cst, Resolver.this.contexts.getCurrentType(), parent);
                Resolver.this.addConstraint(Resolver.this.otherConstraints, (Constraint)constraint, true, this.variable, (IDecisionVariable)(AbstractConstraintProcessor.ExpressionType.CONSTRAINT == type || AbstractConstraintProcessor.ExpressionType.ASSIGNMENT_CONSTRAINT == type ? this.variable : null));
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            return cst;
        }

        @Override
        public ContextStack getContextStack() {
            return Resolver.this.contexts;
        }
    }

    private static class ReasonerState {
        private List<ConstraintList> constraintBase = new LinkedList<ConstraintList>();
        private VariablesMap variablesMap = new VariablesMap();

        private ReasonerState() {
        }
    }
}

